/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.command.control;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.logging.Logger;
import netjfwatcher.engine.command.control.AbstractConnectClientCheck;
import netjfwatcher.engine.command.control.ControllerCommand;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.resource.SystemResourceFileParse;
import netjfwatcher.engine.socket.CommandInfo;

public final class CommnadReceiveServer
extends AbstractConnectClientCheck
implements Runnable {
    private static final int WAIT_SLEEP_TIME = 1000;
    private static Logger logger = null;
    private int port;
    private Thread commandReceiveServerThread;
    private ServerSocket socketListener;
    private SystemResourceFileParse resourceInfo;
    private String allowHost;

    private CommnadReceiveServer() {
        logger = Logger.getLogger(this.getClass().getName());
        this.resourceInfo = SystemResourceConfig.getInstance().getResourceFileParse();
        this.port = Integer.parseInt(this.resourceInfo.getResourceInfo().getEnginePort());
        logger.info("Command receive PORT : " + this.port);
        this.allowHost = this.resourceInfo.getResourceInfo().getEngineAllowHost();
    }

    public void startThread() throws IOException {
        this.socketListener = new ServerSocket(this.port);
        this.socketListener.setSoTimeout(0);
        this.commandReceiveServerThread = new Thread(this);
        this.commandReceiveServerThread.start();
    }

    public void stopReceiving() {
        if (this.commandReceiveServerThread == null) {
            return;
        }
        this.commandReceiveServerThread.interrupt();
        if (this.socketListener != null) {
            try {
                this.socketListener.close();
            }
            catch (IOException e1) {
                logger.warning(e1.getMessage());
                e1.printStackTrace();
            }
            while (this.commandReceiveServerThread != null && this.commandReceiveServerThread.isAlive()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    logger.warning(e.getMessage());
                    e.printStackTrace();
                }
            }
            this.socketListener = null;
        }
        this.commandReceiveServerThread = null;
    }

    public void run() {
        try {
            try {
                while (true) {
                    Socket socket;
                    if (!this.checkAllowHost(socket = this.socketListener.accept())) {
                        continue;
                    }
                    logger.info("Connect address : " + socket.getInetAddress().getHostAddress());
                    Thread thread = new Thread(new CommandReceiveThread(socket));
                    thread.start();
                }
            }
            catch (BindException bindException) {
                logger.warning("BindException: Address already in use : " + this.port);
            }
            catch (IOException iOException) {
                logger.warning("ServerReceive IOException");
            }
        }
        finally {
            try {
                if (this.socketListener != null && !this.socketListener.isClosed()) {
                    this.socketListener.close();
                }
            }
            catch (IOException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    private boolean checkAllowHost(Socket socket) {
        logger.info("Accept Address : " + socket.getInetAddress().getHostAddress() + " : port :" + socket.getLocalPort());
        logger.info("allowHost : " + this.allowHost);
        String remoteIPAddress = socket.getInetAddress().getHostAddress();
        logger.info("Connect remote IP Address : " + remoteIPAddress);
        boolean isAllowClient = this.checkHost(this.allowHost, remoteIPAddress);
        if (!isAllowClient) {
            try {
                socket.close();
            }
            catch (IOException e) {
                logger.warning("Reject socket close error" + e.getMessage());
                e.printStackTrace();
            }
            return false;
        }
        return true;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.socketListener != null) {
            this.socketListener.close();
        }
    }

    public static CommnadReceiveServer getInstance() {
        return SingletonResource.RESOURCE;
    }

    public Thread getCommandReceiveThread() {
        return this.commandReceiveServerThread;
    }

    /* synthetic */ CommnadReceiveServer(CommnadReceiveServer commnadReceiveServer) {
        this();
    }

    private static class CommandReceiveThread
    implements Runnable {
        private Socket socket;
        private ObjectInputStream ois = null;
        private ObjectOutputStream oos = null;
        private BufferedInputStream bis = null;
        private BufferedOutputStream bos = null;

        protected CommandReceiveThread(Socket commandSocket) {
            this.socket = commandSocket;
        }

        public void run() {
            logger.info(Thread.currentThread().getName());
            CommandInfo com = null;
            try {
                try {
                    this.bis = new BufferedInputStream(this.socket.getInputStream());
                    this.ois = new ObjectInputStream(this.bis);
                    this.bos = new BufferedOutputStream(this.socket.getOutputStream());
                    this.oos = new ObjectOutputStream(this.bos);
                    com = (CommandInfo)this.ois.readObject();
                    logger.info("Receive command : " + com.getCode());
                    ControllerCommand command = ControllerCommand.getInstance();
                    command.execute(com.getCode(), com, this.ois, this.oos);
                }
                catch (EOFException ex) {
                    logger.warning("EOF Detect " + ex.getMessage());
                }
                catch (IOException ex) {
                    logger.warning("IOException " + ex.getMessage());
                    ex.printStackTrace();
                }
                catch (ClassNotFoundException ex) {
                    logger.warning("ClassNotFoundException " + ex.getMessage());
                    ex.printStackTrace();
                }
                catch (Exception ex) {
                    logger.warning("Exception " + ex.getMessage());
                    ex.printStackTrace();
                }
            }
            finally {
                if (this.ois != null) {
                    try {
                        this.ois.close();
                    }
                    catch (IOException e) {
                        logger.warning(e.getMessage());
                        e.printStackTrace();
                    }
                    this.ois = null;
                }
                if (this.bis != null) {
                    try {
                        this.bis.close();
                    }
                    catch (IOException e) {
                        logger.warning(e.getMessage());
                        e.printStackTrace();
                    }
                    this.bis = null;
                }
                if (this.oos != null) {
                    try {
                        this.oos.close();
                    }
                    catch (IOException e) {
                        logger.warning(e.getMessage());
                        e.printStackTrace();
                    }
                    this.oos = null;
                }
                if (this.bos != null) {
                    try {
                        this.bos.close();
                    }
                    catch (IOException e) {
                        logger.warning(e.getMessage());
                        e.printStackTrace();
                    }
                    this.bos = null;
                }
                if (this.socket != null) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException e) {
                        logger.warning(e.getMessage());
                        e.printStackTrace();
                    }
                    this.socket = null;
                }
                com = null;
            }
        }

        protected void finalize() throws Throwable {
            super.finalize();
            this.ois.close();
            this.bis.close();
            this.oos.close();
            this.bos.close();
            this.socket.close();
        }
    }

    private static class SingletonResource {
        static final CommnadReceiveServer RESOURCE = new CommnadReceiveServer(null);

        private SingletonResource() {
        }
    }
}

