/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.view.editorpart.snmp;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.common.view.AbstractTableView;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableStatisticsMIBControl;
import netjfwatcher.engine.calendar.DataFilterInfo;
import netjfwatcher.engine.model.action.ActionBuilderChart;
import netjfwatcher.engine.model.action.ActionBuilderDataExport;
import netjfwatcher.engine.model.action.ActionBuilderChart.ActionNodeSnmpStatisticsChartView;
import netjfwatcher.engine.model.action.ActionBuilderChart.ActionNodeSnmpStatisticsChartViewSocket;
import netjfwatcher.engine.model.action.ActionBuilderDataExport.ActionExportSnmpStatisticsData;
import netjfwatcher.engine.resourceconfig.ClientEngineInfo;
import netjfwatcher.engine.server.protocol.snmp.ExecuteStatisticsMibGet;
import netjfwatcher.engine.socket.ConnectionStatisticsMibGet;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.socket.info.StatisticsMibControl;
import netjfwatcher.engine.socket.info.StatisticsMibIfDescriptor;
import netjfwatcher.engine.socket.info.StatisticsMibInfo;
import netjfwatcher.engine.socket.info.StatisticsMibProperty;
import netjfwatcher.engine.socket.info.StatisticsMibSetStatus;
import netjfwatcher.engine.view.editorpart.common.AbstractEditorNodeChart;
import netjfwatcher.engine.view.editorpart.common.AbstractEditorNodeView;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.PlatformUI;

/**
 * wm[hSnmpvf[^\Editor ViewNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class EditorNodeSnmpStatisticsData extends AbstractEditorNodeView {
	/** Snmpv\Editor part^Cg */
	public static final String TITLE_SUFFIX = " Snmp Statistics Data View";

	/** \eLXg */
	public static final int TEXT_WIDTH = 100;

	/** f[^\eLXg */
	public static final int COUNT_TEXT_WIDTH = 70;

	/** f[^\eLXg */
	public static final int DATE_TEXT_WIDTH = 150;

	/* Composite Size */
	private static final int[] SCROLL_COMPOSITE_SIZE = { 900, 800 };

	/* MO */
	private static Logger logger;

	/* SNMPvf[^e[uJRatio */
	private static final float COLUMN0_DATE_RATIO = 0.1f;

	private static final float COLUMN1_DATA_RATIO = 0.15f;

	/* GNX|[gANV */
	private ActionBuilderDataExport exportAction = new ActionBuilderDataExport();

	/* Ot\ANV */
	private ActionBuilderChart nodeChart = new ActionBuilderChart();

	/* OID̃CX^Xi[郊Xg */
	private ArrayList oidInstanceList = new ArrayList();

	/* f[^Xg */
	private ArrayList nameList = new ArrayList();

	/* ̎i[郊Xg */
	private ArrayList dateList = new ArrayList();

	/* CX^X̓vf[^Xgi[郊Xg */
	private ArrayList allStatisticsDataList = new ArrayList();

	/* m[hĎ */
	private NodeInformation targetNodeInfo;

	/* wm[hSnmpv񒆂̑ΏOID */
	private String inputOid;

	/* f[^x[X擾vW */
	private String period;

	/* f[^x[X擾vĎ臒l */
	private String thresHold;

	/* f[^x[X擾vĎ^Cv */
	private String thresHoldType;

	/* f[^Jn */
	private String startDate;

	/* f[^ŐV */
	private String endDate;

	/* ől */
	private String[] maxData;

	/* ŏl */
	private String[] minData;

	/* CX^X\eLXg */
	private Text oidInstanceCountText;

	/* f[^\eLXg */
	private Text dataTotalCountText;

	/* Ď\eLXg */
	private Text periodText;

	/* 臒l\eLXg */
	private Text threshHoldText;

	/* 臒lĎType\eLXg */
	private Text threshHoldTypeText;

	/* f[^Jn\eLXg */
	private Text startDateText;

	/* f[^ŐV\eLXg */
	private Text endDateText;

	/* XV{^ */
	private Button refreshButton;

	/* TableViewer */
	private TableViewer viewer;

	/**
	 * EditorEBhEɃuEU\邽߂̃CX^X 𐶐܂B
	 * 
	 */
	public EditorNodeSnmpStatisticsData() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	/**
	 * EditorEBhE𐶐܂B
	 * 
	 * @param parent
	 *            Composite
	 */
	public void createPartControl(Composite parent) {
		logger.info("NodeSnmpView createPartControl start");

		/* ͐ݒlm[hĎyOID擾 */
		EditorInputNodeView nodeViewEditorInput = (EditorInputNodeView) getEditorInput();
		targetNodeInfo = nodeViewEditorInput.getNodeInfo();
		isSocket = nodeViewEditorInput.isSocket();

		if (targetNodeInfo == null) {
			logger.warning("NodeInfo null");
		}

		inputOid = nodeViewEditorInput.getOid();

		/*
		 * ViewCAEg
		 */
		ScrolledComposite scrollComposite = new ScrolledComposite(parent,
				SWT.H_SCROLL | SWT.V_SCROLL);
		GridLayout layout = new GridLayout(1, false);
		scrollComposite.setLayout(layout);

		GridLayout gridLayout0 = new GridLayout(1, false);
		Composite baseComposite = new Composite(scrollComposite, SWT.LEFT);
		baseComposite.setLayout(gridLayout0);
		baseComposite.setLayoutData(new GridData(
				GridData.VERTICAL_ALIGN_BEGINNING));

		GridData gridData = null;

		GridLayout gridLayout = new GridLayout(12, false);
		Composite composite = new Composite(baseComposite, SWT.NULL);

		composite.setLayout(gridLayout);
		composite.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
		gridData = new GridData();

		refreshButton = new Button(composite, SWT.NONE);
		refreshButton.setText("Refresh");
		refreshButton.setLayoutData(new GridData());

		Label label = new Label(composite, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite, SWT.NONE);
		label.setText("OID Instance=");
		label.setLayoutData(new GridData());
		oidInstanceCountText = new Text(composite, SWT.READ_ONLY | SWT.LEFT);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = COUNT_TEXT_WIDTH;

		// oidInstanceCountText.setEditable(false);
		oidInstanceCountText.setEnabled(false);
		oidInstanceCountText.setLayoutData(gridData);

		label = new Label(composite, SWT.NONE);
		label.setText("Total Data=");
		label.setLayoutData(new GridData());
		dataTotalCountText = new Text(composite, SWT.READ_ONLY | SWT.LEFT);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = COUNT_TEXT_WIDTH;
		dataTotalCountText.setEnabled(false);
		dataTotalCountText.setLayoutData(gridData);

		label = new Label(composite, SWT.NONE);
		label.setText("Period(sec)=");
		label.setLayoutData(new GridData());
		periodText = new Text(composite, SWT.READ_ONLY | SWT.LEFT);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = COUNT_TEXT_WIDTH;
		periodText.setEnabled(false);
		periodText.setLayoutData(gridData);

		label = new Label(composite, SWT.NONE);
		label.setText("Threshold=");
		label.setLayoutData(new GridData());
		threshHoldText = new Text(composite, SWT.READ_ONLY | SWT.LEFT);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = COUNT_TEXT_WIDTH;
		threshHoldText.setEnabled(false);
		threshHoldText.setLayoutData(gridData);

		label = new Label(composite, SWT.NONE);
		label.setText("Threshold Type=");
		label.setLayoutData(new GridData());
		threshHoldTypeText = new Text(composite, SWT.READ_ONLY | SWT.LEFT);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = COUNT_TEXT_WIDTH;
		threshHoldTypeText.setEnabled(false);
		threshHoldTypeText.setLayoutData(gridData);

		label = new Label(composite, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite, SWT.NONE);
		label.setText("Start Date=");
		label.setLayoutData(new GridData());
		startDateText = new Text(composite, SWT.READ_ONLY | SWT.LEFT);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = DATE_TEXT_WIDTH;
		startDateText.setEnabled(false);
		startDateText.setLayoutData(gridData);

		label = new Label(composite, SWT.NONE);
		label.setText("End Date=");
		label.setLayoutData(new GridData());
		endDateText = new Text(composite, SWT.READ_ONLY | SWT.LEFT);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = DATE_TEXT_WIDTH;
		endDateText.setEnabled(false);
		endDateText.setLayoutData(gridData);

		try {
			/*  */
			getStatisticsMibInfo(targetNodeInfo.getIpaddress(), inputOid);
		} catch (DatabaseConnectionException e1) {
			logger.warning("Abort statistics data get" + e1.getMessage());
		} catch (SQLException e1) {
			logger.warning("Abort statistics data get" + e1.getMessage());
		}

		StatisticsTable statisticsTable = new StatisticsTable();
		table = statisticsTable.createTable(baseComposite);

		viewer = new TableViewer(table);
		viewer.setUseHashlookup(true);

		scrollComposite.setContent(baseComposite);
		scrollComposite.setMinSize(SCROLL_COMPOSITE_SIZE[0],
				SCROLL_COMPOSITE_SIZE[1]);
		scrollComposite.setExpandHorizontal(true);
		scrollComposite.setExpandVertical(true);

		setTableStatisticsData();
		setTextNodeInfo();
		createContextMenu();

		/*
		 * XV{^Xi[
		 */
		refreshButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				refreshButton.setEnabled(false);

				try {
					getStatisticsMibInfo(targetNodeInfo.getIpaddress(),
							inputOid);
					setTableStatisticsData();
					setTextNodeInfo();
				} catch (DatabaseConnectionException ex) {
					Shell shell = new Shell();
					MessageDialog.openError(shell, "Abort statistics data get",
							ex.getMessage());
					logger.warning("Abort statistics data get"
							+ ex.getMessage());
					shell.dispose();

					return;
				} catch (SQLException ex) {
					Shell shell = new Shell();
					MessageDialog.openError(shell, "Abort statistics data get",
							ex.getMessage());
					logger.warning("Abort statistics data get"
							+ ex.getMessage());
					shell.dispose();

					return;
				} finally {
					refreshButton.setEnabled(true);
				}
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});
	}

	/**
	 * ContextMenu𐶐܂B
	 * 
	 */
	private void createContextMenu() {

		MenuManager mm = new MenuManager();
		mm.setRemoveAllWhenShown(true);
		mm.addMenuListener(new IMenuListener() {
			/**
			 * 
			 */
			public void menuAboutToShow(IMenuManager manager) {
				fillContextMenu(manager);
			}
		});

		/*
		 * ReLXgj[𐶐Zbg
		 */
		Menu menu = mm.createContextMenu(viewer.getControl());
		viewer.getControl().setMenu(menu);
		getSite().registerContextMenu(mm, viewer);
	}

	/**
	 * j[o[ preWindowOpenɌĂ΂܂B
	 * 
	 * @param manager
	 *            IMenuManager
	 */
	protected void fillContextMenu(IMenuManager manager) {

		manager.add(new GroupMarker(IWorkbenchActionConstants.MB_ADDITIONS));

		/* e[ȗI񒊏o */
		if ((table.getSelectionIndex() >= 0) && (table.getSelection() != null)) {
			/* e[u\CSVo̓ANVZbg */
			((ActionExportSnmpStatisticsData) exportAction
					.getActionExportSnmpStatistics()).setTable(table);
			manager.add(exportAction.getActionExportSnmpStatistics());

			/* vOt\ANV */
			String title = targetNodeInfo.getNodename() + "("
					+ targetNodeInfo.getIpaddress() + ") " + " OID=" + inputOid
					+ AbstractEditorNodeChart.TITLE_SUFFIX;

			if (!isSocket) {
				ActionNodeSnmpStatisticsChartView actionSnmpStatistics = (ActionNodeSnmpStatisticsChartView) nodeChart
						.getActionNodeSnmpStatisticsChartView();

				actionSnmpStatistics.setText("Chart OID=" + inputOid);
				actionSnmpStatistics.setToolTipText("Chart OID=" + inputOid);

				actionSnmpStatistics.setTitle(title);
				actionSnmpStatistics.setNodeInfo(targetNodeInfo);
				actionSnmpStatistics.setOid(inputOid);

				actionSnmpStatistics.setMaxData(maxData);
				actionSnmpStatistics.setMinData(minData);
				actionSnmpStatistics.setDateList(dateList);
				actionSnmpStatistics.setDataList(allStatisticsDataList);
				actionSnmpStatistics.setNameList(nameList);
				manager.add(nodeChart.getActionNodeSnmpStatisticsChartView());
			} else {
				ActionNodeSnmpStatisticsChartViewSocket actionSnmpStatistics = (ActionNodeSnmpStatisticsChartViewSocket) nodeChart
						.getActionNodeSnmpStatisticsChartViewSocket();

				actionSnmpStatistics.setText("Chart OID=" + inputOid);
				actionSnmpStatistics.setToolTipText("Chart OID=" + inputOid);

				actionSnmpStatistics.setTitle(title);
				actionSnmpStatistics.setNodeInfo(targetNodeInfo);
				actionSnmpStatistics.setOid(inputOid);

				actionSnmpStatistics.setMaxData(maxData);
				actionSnmpStatistics.setMinData(minData);
				actionSnmpStatistics.setDateList(dateList);
				actionSnmpStatistics.setDataList(allStatisticsDataList);
				actionSnmpStatistics.setNameList(nameList);
				manager.add(nodeChart
						.getActionNodeSnmpStatisticsChartViewSocket());
			}
		}
	}

	/*
	 * SnmpvĎvpeBTextɃZbg܂B
	 * 
	 */
	private void setTextNodeInfo() {
		/* OIDCX^X */
		oidInstanceCountText.setText(Integer.toString(oidInstanceList.size()));

		/* f[^ */
		dataTotalCountText.setText(Integer.toString(dateList.size()));

		/* ̎ */
		if (period != null) {
			periodText.setText(period);
		}

		/* 臒l */
		if (thresHold != null) {
			threshHoldText.setText(thresHold);
		}

		/* Ď^Cv */
		if (thresHoldType != null) {
			threshHoldTypeText.setText(thresHoldType);
		}

		/* ̎Jn */
		if (startDate != null) {
			startDateText.setText(startDate);
		}

		/* ̎ŐV */
		if (endDate != null) {
			endDateText.setText(endDate);
		}
	}

	/*
	 * f[^x[XWSnmpvf[^Xge[u\ s܂B
	 */
	private void setTableStatisticsData() {
		/* e[ȗSč폜ătbV */
		table.removeAll();
		viewer.refresh();

		/* ̎[v */
		for (int dateCount = 0; dateCount < dateList.size(); dateCount++) {

			ArrayList[] statisticsDataList = new ArrayList[allStatisticsDataList
					.size()];

			String[] statisticsMibTableCellArray = new String[oidInstanceList
					.size() + 1];

			statisticsMibTableCellArray[0] = (String) dateList.get(dateCount);

			/* CX^X[v */
			for (int instanceCount = 0; instanceCount < allStatisticsDataList
					.size(); instanceCount++) {
				/* CX^Xf[^Xgi[XgCX^Xf[^Xgo */
				statisticsDataList[instanceCount] = (ArrayList) allStatisticsDataList
						.get(instanceCount);

				/* CX^Xf[^ǂݏo */
				statisticsMibTableCellArray[instanceCount + 1] = (String) statisticsDataList[instanceCount]
						.get(dateCount);
			}

			/*
			 * ̎ɃCX^Xf[^Zbg
			 */
			TableItem item = new TableItem(table, SWT.NULL);

			item.setText(statisticsMibTableCellArray);
			item.setData(statisticsMibTableCellArray);
		}
	}

	/*
	 * f[^x[XSnmpvWXgɕێ܂B
	 * 
	 * @param ipAddress m[hIPAhX @param selectOid OID @throws
	 * DatabaseConnectionException f[^x[XRlNV擾łȂꍇ @throws SQLException
	 * f[^x[XANZXɎsꍇ
	 */
	private void getStatisticsMibInfo(String ipAddress, String selectOid)
			throws DatabaseConnectionException, SQLException {
		ArrayList ifDescriptorList = null;
		DBTableStatisticsMIBControl mibDBTable = null;

		String engineAddress = "";

		if (!isSocket) {
			/* ifDescriptionXg擾 */
			mibDBTable = DBTableStatisticsMIBControl.getInstance();
			ifDescriptorList = mibDBTable.findIfDescriptor(ipAddress);
		} else {
			/*
			 * vMIB̎ɂāAOIDC^tF[Xn̏ꍇifDesc 擾邽߂̃CX^XZbg
			 */
			StatisticsMibControl control = new StatisticsMibControl();
			control.setSubCommand(StatisticsMibControl.IF_DESCRIPTOR_GET);
			control.setIpaddress(ipAddress);

			engineAddress = ClientEngineInfo.getClientEngineInfoInstance()
					.getEngineAddress();

			/* GWƂ̃RlNV擾 */
			ConnectionStatisticsMibGet statisticsMibGet = new ConnectionStatisticsMibGet(
					engineAddress);

			try {
				StatisticsMibProperty mibproperty = statisticsMibGet
						.getStatisticsMib(control);
				ifDescriptorList = mibproperty.getMibIfDescriptorList();
			} catch (EngineConnectException e) {
				Shell shell = new Shell();
				MessageDialog.openError(shell, "Error", "Engine connect error "
						+ e.getMessage() + " Engine=" + engineAddress);
				shell.dispose();

				return;
			} catch (IOException e) {
				Shell shell = new Shell();
				MessageDialog.openError(shell, "Error", "Engine connect error "
						+ e.getMessage() + " Engine=" + engineAddress);
				shell.dispose();

				return;
			}
		}

		if (ifDescriptorList == null) {
			return;
		}

		oidInstanceList.clear();
		nameList.clear();
		dateList.clear();
		allStatisticsDataList.clear();

		/* wOID̃CX^X𒊏oăXgɊi[ */
		for (int i = 0; i < ifDescriptorList.size(); i++) {
			StatisticsMibIfDescriptor mibIfDesc = (StatisticsMibIfDescriptor) ifDescriptorList
					.get(i);
			String workOid = mibIfDesc.getOid();

			int checkPoint = "Oid=".length();

			if (checkPoint >= 0) {
				/* w肳ꂽOIDɈvCX^XXgɊi[ */
				if (workOid.substring(checkPoint).equals(selectOid)) {
					oidInstanceList.add(mibIfDesc.getInstance());

					if (mibIfDesc.getIfDescriptor().equals("")) {
						nameList.add(mibIfDesc.getInstance());
					} else {
						nameList.add(mibIfDesc.getInstance() + " ("
								+ mibIfDesc.getIfDescriptor() + ")");
					}
				}
			}
		}

		ArrayList statisticsMibSetStatusList = null;

		if (!isSocket) {
			statisticsMibSetStatusList = mibDBTable.getList(ipAddress);
		} else {
			System.out.println("Socket1");

			StatisticsMibControl control = new StatisticsMibControl();
			control
					.setSubCommand(StatisticsMibControl.STATISTICS_SET_STATUS_GET);
			control.setIpaddress(ipAddress);

			ConnectionStatisticsMibGet statisticsMibGet = new ConnectionStatisticsMibGet(
					engineAddress);

			try {
				StatisticsMibProperty mibproperty = statisticsMibGet
						.getStatisticsMib(control);

				if (mibproperty != null) {
					statisticsMibSetStatusList = mibproperty
							.getStatisticsMibSetList();
				}
			} catch (EngineConnectException e) {
				Shell shell = new Shell();
				MessageDialog.openError(shell, "Error", "Engine connect error "
						+ e.getMessage() + " Engine=" + engineAddress);
				shell.dispose();

				return;
			} catch (IOException e) {
				Shell shell = new Shell();
				MessageDialog.openError(shell, "Error", "Engine connect error "
						+ e.getMessage() + " Engine=" + engineAddress);
				shell.dispose();

				return;
			}
		}

		/*
		 * wOIDɑΉ̎AĎ臒lyъĎ^Cv f[^x[X璊o
		 */
		String readOid = "";

		for (int i = 0; i < statisticsMibSetStatusList.size(); i++) {
			StatisticsMibSetStatus statisticsMibSetStatus = (StatisticsMibSetStatus) statisticsMibSetStatusList
					.get(i);
			readOid = statisticsMibSetStatus.getReadOid();

			if (readOid.equals(selectOid)) {
				period = statisticsMibSetStatus.getReadPeriod();
				thresHold = statisticsMibSetStatus.getReadThreshold();

				if (statisticsMibSetStatus.getReadThresholdType().equals("")) {
					thresHoldType = ExecuteStatisticsMibGet.THRESHOLD_TYPE_NONE;
				} else {
					thresHoldType = statisticsMibSetStatus
							.getReadThresholdType();
				}
			}
		}

		maxData = new String[oidInstanceList.size()];
		minData = new String[oidInstanceList.size()];

		StatisticsMibProperty mibProperty = null;

		for (int k = 0; k < oidInstanceList.size(); k++) {
			String oidIns = (String) oidInstanceList.get(k);

			if (!isSocket) {
				/* OIDCX^X̃f[^A̎ԁAPʂȂ */
				mibProperty = mibDBTable.getDataCount(ipAddress, selectOid,
						oidIns);
			} else {
				/* vMIB̎ɂāAOIDC^tF[Xn̏ꍇifDesc擾邽߂̃CX^XZbg */
				StatisticsMibControl statisticsMibControl = new StatisticsMibControl();
				statisticsMibControl
						.setSubCommand(StatisticsMibControl.STATISTICS_DATA_GET);
				statisticsMibControl.setIpaddress(ipAddress);
				statisticsMibControl.setOid(selectOid);
				statisticsMibControl.setOidInstance(oidIns);

				ConnectionStatisticsMibGet statisticsMibGet = new ConnectionStatisticsMibGet(
						engineAddress);

				try {
					mibProperty = statisticsMibGet
							.getStatisticsMib(statisticsMibControl);
				} catch (EngineConnectException e) {
					Shell shell = new Shell();
					MessageDialog.openError(shell, "Error",
							"Engine connect error " + e.getMessage()
									+ " Engine=" + engineAddress);
					shell.dispose();

					return;
				} catch (IOException e) {
					Shell shell = new Shell();
					MessageDialog.openError(shell, "Error",
							"Engine connect error " + e.getMessage()
									+ " Engine=" + engineAddress);
					shell.dispose();

					return;
				}
			}

			/*
			 * f[^́A̎斳ɂreturn
			 */
			if ((mibProperty.getTotalDataCount() == 0)
					|| (mibProperty.getStartDate() == null)
					|| (mibProperty.getEndDate() == null)) {
				return;
			}

			startDate = mibProperty.getStartDate().toString();
			endDate = mibProperty.getEndDate().toString();

			maxData[k] = mibProperty.getMaxData();
			minData[k] = mibProperty.getMinData();
			/*
			 * logger.info("maxData[k] : " + maxData[k]);
			 * logger.info("minData[k] : " + minData[k]); logger.info("startDate : " +
			 * startDate); logger.info("endDate : " + endDate);
			 */
		}

		String filterStart;
		String filterEnd;

		String filterCheckStart = DataFilterInfo.getInstance().getStartDate();
		String filterCheckEnd = DataFilterInfo.getInstance().getEndDate();
		if (filterCheckStart == null || filterCheckStart.equals("")) {
			filterStart = startDate;
		} else {
			filterStart = filterCheckStart;
		}
		if (filterCheckEnd == null || filterCheckEnd.equals("")) {
			filterEnd = endDate;
		} else {
			filterEnd = filterCheckEnd;
		}
		int limit = DataFilterInfo.getInstance().getLimit();
		/*
		 * wOID̓vf[^ƍ̎CX^X f[^x[X擾ăXgɕێ
		 */
		for (int j = 0; j < oidInstanceList.size(); j++) {
			String instance = (String) oidInstanceList.get(j);
			// logger.info("instance : " + instance);

			ArrayList instanceDataList = new ArrayList();
			ArrayList dataList = null;

			if (!isSocket) {
				dataList = mibDBTable.findInstance(ipAddress, selectOid,
						instance, filterStart, filterEnd);
			} else {
				/* GWƒʐM邽߂ɁAvMIBOIDCX^XAWԂȂǂ̐CX^XZbg */
				StatisticsMibControl statisticsMibControl = new StatisticsMibControl();
				statisticsMibControl
						.setSubCommand(StatisticsMibControl.STATISTICS_DATA_GET);
				statisticsMibControl.setIpaddress(ipAddress);
				statisticsMibControl.setOid(selectOid);
				statisticsMibControl.setOidInstance(instance);
				statisticsMibControl.setPeriodStartDate(filterStart);
				statisticsMibControl.setPeriodEndDate(filterEnd);

				/* GWƒʐMAf[^擾 */
				ConnectionStatisticsMibGet statisticsMibGet = new ConnectionStatisticsMibGet(
						engineAddress);

				try {
					StatisticsMibProperty mibproperty = statisticsMibGet
							.getStatisticsMib(statisticsMibControl);
					dataList = mibproperty.getMibInfoList();
				} catch (EngineConnectException e) {
					Shell shell = new Shell();
					MessageDialog.openError(shell, "Error",
							"Engine connect error " + e.getMessage()
									+ " Engine=" + engineAddress);
					shell.dispose();

					return;
				} catch (IOException e) {
					Shell shell = new Shell();
					MessageDialog.openError(shell, "Error",
							"Engine connect error " + e.getMessage()
									+ " Engine=" + engineAddress);
					shell.dispose();

					return;
				}
			}

			/*
			 * ̎XgɃZbg
			 */
			for (int i = 0; i < dataList.size(); i++) {
				StatisticsMibInfo statisticsMibInfo = (StatisticsMibInfo) dataList
						.get(i);

				/* ŏ̃CX^Xf[^̓XgɃZbg */
				if (j == 0) {
					/* ̎XgɃZbg */
					dateList.add(statisticsMibInfo.getDate().toString());
				}

				/* ̎f[^XgɃZbg */
				instanceDataList.add(statisticsMibInfo.getStatisMibValue());
				if (limit != 0 && i >= limit) {
					break;
				}
			}

			/* CX^X̍̎f[^XgSi[XgɊi[ */
			allStatisticsDataList.add(instanceDataList);
		}
	}

	/*
	 * J̕Ԃ܂B
	 * 
	 * @return J
	 */
	private int computeCol0Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN0_DATE_RATIO);
	}

	/*
	 * f[^J̕Ԃ܂B
	 * 
	 * @return f[^J
	 */
	private int computeCol1Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN1_DATA_RATIO);
	}

	/**
	 * Xe[^XC\Zbg܂B
	 */
	protected void setStatusLine() {
		/* Xe[^XC\L */
		statusLineManager = (SubStatusLineManager) (getEditorSite()
				.getActionBars().getStatusLineManager());
		statusLineManager.setVisible(true);
	}

	/*
	 * SNMPvMIBe[uNXłB J0̎ƂAȍ~̃JOIDCX^X\ ܂B
	 * 
	 * @author Yoshimasa Matsumoto
	 * 
	 * @version 1.0
	 */
	private final class StatisticsTable extends AbstractTableView {
		/* J\[gێ */
		private boolean[] isColDirection;

		/*
		 * SnmpvMIB\e[u𐶐ĕԂ܂B
		 * 
		 * @return table Table
		 */
		private Table createTable(Composite parent) {
			GridData data2 = new GridData();
			data2.horizontalAlignment = GridData.FILL;
			data2.verticalAlignment = GridData.FILL;
			data2.grabExcessHorizontalSpace = true;
			data2.grabExcessVerticalSpace = true;

			/* e[u */
			table = new Table(parent, SWT.H_SCROLL | SWT.V_SCROLL
					| SWT.FULL_SELECTION);
			table.setLinesVisible(true);
			table.setHeaderVisible(true);
			table.setLayoutData(data2);

			/* \[gtO */
			isColDirection = new boolean[oidInstanceList.size() + 1];

			/* e[uColumn */
			TableColumn[] col = new TableColumn[oidInstanceList.size() + 1];

			/* vMIB̎Column */
			col[0] = new TableColumn(table, SWT.CENTER);
			col[0].setText("Date");
			col[0].setWidth(computeCol0Width());

			/* vMIB̎Column\[gXi[Zbg */
			isColDirection[0] = true;
			col[0].addListener(SWT.Selection, new Listener() {
				public void handleEvent(Event event) {
					/* J\[gA\[gێ */
					isColDirection[0] = sortTable(table, 0, isColDirection[0],
							null);
				}
			});

			/*
			 * vMIBCX^XColumn𐶐
			 */
			for (int i = 1; i < col.length; i++) {
				col[i] = new TableColumn(table, SWT.CENTER);
				col[i].setText((String) nameList.get(i - 1));
				col[i].setWidth(computeCol1Width());
				isColDirection[i] = true;

				/*
				 * vMIBCX^XColumn\[gXi[Zbg
				 */
				final int count = i;
				col[i].addListener(SWT.Selection, new Listener() {
					public void handleEvent(Event event) {
						/* J\[gA\[gێ */
						isColDirection[count] = sortDoubleTable(table, count,
								isColDirection[count]);
					}
				});
			}

			/*
			 * e[uړꍇ͂TCYꍇ̃Xi[łB
			 * 
			 */
			PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()
					.addControlListener(new ControlListener() {
						public void controlMoved(ControlEvent event) {
						}

						public void controlResized(ControlEvent event) {
							setResizedTableColumnWidth();
						}
					});

			return table;
		}

		protected void setResizedTableColumnWidth() {
			/*
			 * e[u\Ԃł΃e[uJZbg
			 */
			if (getEditorSite().getPage().isPartVisible(
					getEditorSite().getPart())
					&& getEditorSite().getShell() != null) {
				if (getEditorSite().getShell().getSize() != null) {

				}

			}
		}
	}
}
