/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.view.editorpart.ping;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.common.view.AbstractTableView;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTablePingResponse;
import netjfwatcher.engine.calendar.DataFilterInfo;
import netjfwatcher.engine.model.action.ActionBuilderChart;
import netjfwatcher.engine.model.action.ActionBuilderDataExport;
import netjfwatcher.engine.model.action.ActionBuilderChart.ActionNodePingChartView;
import netjfwatcher.engine.model.action.ActionBuilderChart.ActionNodePingChartViewSocket;
import netjfwatcher.engine.model.action.ActionBuilderDataExport.ActionExportPingResponse;
import netjfwatcher.engine.resourceconfig.ClientEngineInfo;
import netjfwatcher.engine.socket.ConnectionPing;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.socket.info.PingInfo;
import netjfwatcher.engine.socket.info.PingProperty;
import netjfwatcher.engine.socket.info.PingResponseInfo;
import netjfwatcher.engine.view.editorpart.common.AbstractEditorNodeChart;
import netjfwatcher.engine.view.editorpart.common.AbstractEditorNodeView;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.PlatformUI;

/**
 * Pingf[^EditorPartɃe[u\ViewNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class EditorNodePingResponseData extends AbstractEditorNodeView {
	/** Pingf[^\View^Cg */
	public static final String TITLE_SUFFIX = " Ping Data View";

	/** eLXg */
	public static final int TEXT_WIDTH = 100;

	/** f[^\eLXg */
	public static final int COUNT_TEXT_WIDTH = 70;

	/** f[^\eLXg */
	public static final int DATE_TEXT_WIDTH = 150;

	/* Composite Size */
	private static final int[] SCROLL_COMPOSITE_SIZE = { 900, 800 };

	/* MO */
	private static Logger logger;

	/* Pingf[^e[uJRatio */
	private static final float COLUMN0_DATE_RATIO = 0.15f;

	private static final float COLUMN1_DATA_RATIO = 0.15f;

	/* f[^GNX|[gANV */
	private ActionBuilderDataExport exportDataAction = new ActionBuilderDataExport();

	/* Ot\ANV */
	private ActionBuilderChart nodeChartAction = new ActionBuilderChart();

	/* m[hĎ */
	private NodeInformation targetNodeInfo;

	/* Pingf[^ */
	private PingResponseInfo responseInfo = new PingResponseInfo();

	/* f[^\eLXg */
	private Text dataTotalCountText;

	/* Ď\eLXg */
	private Text periodText;

	/* ől\eLXg */
	private Text maxDataText;

	/* 臒l\eLXg */
	private Text thresholdDataText;

	/* f[^Jn\eLXg */
	private Text startDateText;

	/* f[^ŐV\eLXg */
	private Text endDateText;

	/* XV{^ */
	private Button refreshButton;

	/* TableViewer */
	private TableViewer viewer;

	/* Ot`p̃f[^i[Xgyэ̎f[^i[Xg */
	private ArrayList dateList = new ArrayList();

	private ArrayList dataList = new ArrayList();

	/* Ot`p̃f[^őlyэŏl */
	private String[] maxData = new String[1];

	private String[] minData = new String[1];

	/**
	 * EditorEBhEɃuEU\邽߂̃CX^X 𐶐܂B
	 * 
	 */
	public EditorNodePingResponseData() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	/**
	 * EditorEBhE𐶐܂B
	 * 
	 * @param parent
	 *            Composite
	 */
	public void createPartControl(Composite parent) {
		/* ͐ݒlm[hĎyOID擾 */
		EditorInputNodeView nodeViewEditorInput = (EditorInputNodeView) getEditorInput();
		targetNodeInfo = nodeViewEditorInput.getNodeInfo();
		isSocket = nodeViewEditorInput.isSocket();

		if (targetNodeInfo == null) {
			logger.warning("NodeInfo null");
		}

		ScrolledComposite scrollComposite = new ScrolledComposite(parent,
				SWT.H_SCROLL | SWT.V_SCROLL);
		GridLayout layout = new GridLayout(1, false);
		scrollComposite.setLayout(layout);

		GridLayout gridLayout0 = new GridLayout(1, false);
		Composite baseComposite = new Composite(scrollComposite, SWT.LEFT);
		baseComposite.setLayout(gridLayout0);
		baseComposite.setLayoutData(new GridData(
				GridData.VERTICAL_ALIGN_BEGINNING));

		GridData gridData = null;

		GridLayout gridLayout = new GridLayout(10, false);
		Composite composite = new Composite(baseComposite, SWT.LEFT);

		composite.setLayout(gridLayout);
		composite.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
		gridData = new GridData();

		refreshButton = new Button(composite, SWT.NONE);
		refreshButton.setText("Refresh");
		refreshButton.setLayoutData(new GridData());

		Label label = new Label(composite, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite, SWT.NONE);
		label.setText("Total Data=");
		label.setLayoutData(new GridData());
		dataTotalCountText = new Text(composite, SWT.READ_ONLY | SWT.LEFT);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = COUNT_TEXT_WIDTH;
		dataTotalCountText.setEnabled(false);
		dataTotalCountText.setLayoutData(gridData);

		label = new Label(composite, SWT.NONE);
		label.setText("Period(sec)=");
		label.setLayoutData(new GridData());
		periodText = new Text(composite, SWT.READ_ONLY | SWT.LEFT);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = COUNT_TEXT_WIDTH;
		periodText.setEnabled(false);
		periodText.setLayoutData(gridData);

		label = new Label(composite, SWT.NONE);
		label.setText("Max Data(msec)=");
		label.setLayoutData(new GridData());
		maxDataText = new Text(composite, SWT.READ_ONLY | SWT.LEFT);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = COUNT_TEXT_WIDTH;
		maxDataText.setEnabled(false);
		maxDataText.setLayoutData(gridData);

		label = new Label(composite, SWT.NONE);
		label.setText("Threshold(msec)=");
		label.setLayoutData(new GridData());
		thresholdDataText = new Text(composite, SWT.READ_ONLY | SWT.LEFT);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = COUNT_TEXT_WIDTH;
		thresholdDataText.setEnabled(false);
		thresholdDataText.setLayoutData(gridData);

		label = new Label(composite, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite, SWT.NONE);
		label.setText("Start date=");
		label.setLayoutData(new GridData());
		startDateText = new Text(composite, SWT.READ_ONLY | SWT.LEFT);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = DATE_TEXT_WIDTH;
		startDateText.setEnabled(false);
		startDateText.setLayoutData(gridData);

		label = new Label(composite, SWT.NONE);
		label.setText("End date=");
		label.setLayoutData(new GridData());
		endDateText = new Text(composite, SWT.READ_ONLY | SWT.LEFT);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = DATE_TEXT_WIDTH;
		endDateText.setEnabled(false);
		endDateText.setLayoutData(gridData);

		// getSystemMib(targetNodeInfo);
		PingTable statisticsTable = new PingTable();
		table = statisticsTable.createTable(baseComposite);

		// createTable(parent);
		viewer = new TableViewer(table);
		viewer.setUseHashlookup(true);

		scrollComposite.setContent(baseComposite);
		scrollComposite.setMinSize(SCROLL_COMPOSITE_SIZE[0],
				SCROLL_COMPOSITE_SIZE[1]);
		scrollComposite.setExpandHorizontal(true);
		scrollComposite.setExpandVertical(true);

		createContextMenu();

		try {
			getPingData();
		} catch (DatabaseConnectionException e1) {
			logger.warning(e1.getMessage());
		} catch (SQLException e1) {
			logger.warning(e1.getMessage());
		}

		setTablePingData();

		// setTableStatisticsData();
		// setTextNodeInfo();
		setRefreshButtonListener();
	}

	/*
	 * XV{^Xi[
	 */
	private void setRefreshButtonListener() {
		refreshButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				refreshButton.setEnabled(false);

				try {
					getPingData();
					setTablePingData();
				} catch (DatabaseConnectionException ex) {
					logger.warning(ex.getMessage());

					Shell shell = new Shell();
					MessageDialog.openError(shell,
							"Abort Ping response data get", ex.getMessage());
					shell.dispose();
				} catch (SQLException ex) {
					logger.warning(ex.getMessage());

					Shell shell = new Shell();
					MessageDialog.openError(shell,
							"Abort Ping response data get", ex.getMessage());
					shell.dispose();
				} finally {
					refreshButton.setEnabled(true);
				}
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});
	}

	/*
	 * ContextMenu𐶐܂B
	 * 
	 */
	private void createContextMenu() {
		/* j[}l[WZbg */
		MenuManager mm = new MenuManager();
		mm.setRemoveAllWhenShown(true);
		mm.addMenuListener(new IMenuListener() {
			public void menuAboutToShow(IMenuManager manager) {
				fillContextMenu(manager);
			}
		});

		/*
		 * ReLXgj[𐶐Zbg
		 */
		Menu menu = mm.createContextMenu(viewer.getControl());
		viewer.getControl().setMenu(menu);
		getSite().registerContextMenu(mm, viewer);
	}

	/**
	 * j[o[ preWindowOpenɌĂ΂܂B
	 * 
	 * @param manager
	 *            IMenuManager
	 */
	protected void fillContextMenu(IMenuManager manager) {
		manager.add(new GroupMarker(IWorkbenchActionConstants.MB_ADDITIONS));

		/* e[ȗI񒊏o */
		if ((table.getSelectionIndex() >= 0) && (table.getSelection() != null)) {
			/* e[u\CSVo̓ANVZbg */
			((ActionExportPingResponse) exportDataAction.getActionExportPing())
					.setTable(table);
			manager.add(exportDataAction.getActionExportPing());
		}

		/* Pingf[^Ot\ANV */
		String title = targetNodeInfo.getNodename() + "("
				+ targetNodeInfo.getIpaddress() + ") " + "Ping "
				+ AbstractEditorNodeChart.TITLE_SUFFIX;

		ArrayList nameList = new ArrayList();
		nameList.add(targetNodeInfo.getNodename() + "("
				+ targetNodeInfo.getIpaddress() + ")");

		if (!isSocket) {
			((ActionNodePingChartView) nodeChartAction
					.getActionNodePingChartView()).setTitle(title);
			((ActionNodePingChartView) nodeChartAction
					.getActionNodePingChartView()).setNodeInfo(targetNodeInfo);

			((ActionNodePingChartView) nodeChartAction
					.getActionNodePingChartView()).setMaxData(maxData);
			((ActionNodePingChartView) nodeChartAction
					.getActionNodePingChartView()).setMinData(minData);
			((ActionNodePingChartView) nodeChartAction
					.getActionNodePingChartView()).setDateList(dateList);

			ArrayList list = new ArrayList();
			list.add(dataList);
			((ActionNodePingChartView) nodeChartAction
					.getActionNodePingChartView()).setDataList(list);

			((ActionNodePingChartView) nodeChartAction
					.getActionNodePingChartView()).setNameList(nameList);
			manager.add(nodeChartAction.getActionNodePingChartView());
		} else {
			((ActionNodePingChartViewSocket) nodeChartAction
					.getActionNodePingChartViewSocket()).setTitle(title);
			((ActionNodePingChartViewSocket) nodeChartAction
					.getActionNodePingChartViewSocket())
					.setNodeInfo(targetNodeInfo);

			((ActionNodePingChartViewSocket) nodeChartAction
					.getActionNodePingChartViewSocket()).setMaxData(maxData);
			((ActionNodePingChartViewSocket) nodeChartAction
					.getActionNodePingChartViewSocket()).setMinData(minData);
			((ActionNodePingChartViewSocket) nodeChartAction
					.getActionNodePingChartViewSocket()).setDateList(dateList);

			ArrayList list = new ArrayList();
			list.add(dataList);
			((ActionNodePingChartViewSocket) nodeChartAction
					.getActionNodePingChartViewSocket()).setDataList(list);

			((ActionNodePingChartViewSocket) nodeChartAction
					.getActionNodePingChartViewSocket()).setNameList(nameList);
			manager.add(nodeChartAction.getActionNodePingChartViewSocket());
		}
	}

	/*
	 * pingf[^擾܂B
	 * 
	 * @throws DatabaseConnectionException f[^x[XRlNV擾Ɏsꍇ @throws
	 * SQLException f[^x[XANZXɎsꍇ
	 */
	private void getPingData() throws DatabaseConnectionException, SQLException {
		periodText.setText(targetNodeInfo.getPingPeriod());
		thresholdDataText.setText(targetNodeInfo.getPingThreshold());

		ArrayList list = null;
		PingProperty property = null;

		String filterStart;
		String filterEnd;

		String filterCheckStart = DataFilterInfo.getInstance().getStartDate();
		String filterCheckEnd = DataFilterInfo.getInstance().getEndDate();
		if (filterCheckStart == null || filterCheckStart.equals("")) {
			filterStart = null;
		} else {
			filterStart = filterCheckStart;
		}
		if (filterCheckEnd == null || filterCheckEnd.equals("")) {
			filterEnd = null;
		} else {
			filterEnd = filterCheckEnd;
		}

		if (!isSocket) {
			DBTablePingResponse pingDBTable = DBTablePingResponse.getInstance();

			/* wԂPingf[^f[^x[X擾 */
			list = pingDBTable.findAll(targetNodeInfo.getIpaddress(),
					filterStart, filterEnd);
			property = pingDBTable.getDataCount(targetNodeInfo.getIpaddress());

			if ((list != null) && (property != null)) {
				System.out.println("List size : " + list.size());
				System.out.println("getStartDate : " + property.getStartDate());
				System.out.println("getEndDat : " + property.getEndDate());
				System.out.println("getMaxData : " + property.getMaxData());
				System.out.println("getTotalDataCount : "
						+ property.getTotalDataCount());

				if (list.size() > 0) {
					dataTotalCountText.setText(Integer.toString(list.size()));
					maxDataText.setText(property.getMaxData());
					startDateText.setText(property.getStartDate().toString());
					endDateText.setText(property.getEndDate().toString());

					maxData[0] = property.getMaxData();
					minData[0] = property.getMinData();
				}
			}
		} else {
			String engineAddress = ClientEngineInfo
					.getClientEngineInfoInstance().getEngineAddress();

			try {
				ConnectionPing connectionPing = new ConnectionPing(
						engineAddress);
				PingResponseInfo pingResponseInfo = connectionPing.getPingInfo(
						targetNodeInfo.getIpaddress(), filterStart, filterEnd);

				list = pingResponseInfo.getPingDataList();
				property = pingResponseInfo.getPingProperty();

				if ((list != null) && (property != null)) {
					if (list.size() > 0) {
						dataTotalCountText.setText(Integer
								.toString(list.size()));
						maxDataText.setText(property.getMaxData());
						startDateText.setText(property.getStartDate()
								.toString());
						endDateText.setText(property.getEndDate().toString());

						maxData[0] = property.getMaxData();
						minData[0] = property.getMinData();
					}
				}
			} catch (EngineConnectException ex) {
				Shell shell = new Shell();
				MessageDialog.openError(shell, "Engine connect error",
						"Engine connect error " + ex.getMessage() + " Engine="
								+ engineAddress);
				logger.warning("Engine connect error " + ex.getMessage());
				shell.dispose();
				ex.printStackTrace();
			} catch (IOException e) {
				Shell shell = new Shell();
				MessageDialog.openError(shell, "Engine connect error",
						"Engine connect error " + e.getMessage() + " Engine="
								+ engineAddress);
				logger.warning("Engine connect error " + e.getMessage());
				shell.dispose();
				e.printStackTrace();
			}
		}

		/* Pingf[^CX^XɃZbg */
		responseInfo.setPingDataList(list);
		responseInfo.setPingProperty(property);
	}

	/*
	 * f[^x[XWSnmpvf[^Xge[u\ s܂B
	 */
	private void setTablePingData() {
		/* e[ȗSč폜ătbV */
		table.removeAll();
		viewer.refresh();

		dateList.clear();
		dataList.clear();

		if (responseInfo == null) {
			return;
		}
		int limit = DataFilterInfo.getInstance().getLimit();
		ArrayList pingDataList = responseInfo.getPingDataList();

		if (pingDataList == null) {
			return;
		}

		for (int i = 0; i < pingDataList.size(); i++) {
			PingInfo pingInfo = (PingInfo) pingDataList.get(i);

			String[] pingResponseTableCellArray = new String[2];

			pingResponseTableCellArray[0] = pingInfo.getPingCheckDate()
					.toString();
			pingResponseTableCellArray[1] = Long.toString(pingInfo
					.getPingDiffTime());

			dateList.add(pingInfo.getPingCheckDate().toString());
			dataList.add(Long.toString(pingInfo.getPingDiffTime()));

			TableItem item = new TableItem(table, SWT.NULL);

			item.setText(pingResponseTableCellArray);
			item.setData(pingResponseTableCellArray);

			if (limit != 0 && i >= limit) {
				break;
			}
		}
	}

	/**
	 * J0iPingf[^̎j̕Ԃ܂B
	 * 
	 * @return J0iPingf[^̎j
	 */
	private int computeCol0Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN0_DATE_RATIO);
	}

	/**
	 * J1iPingf[^j̕Ԃ܂B
	 * 
	 * @return J1iPingf[^j̕
	 */
	private int computeCol1Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN1_DATA_RATIO);
	}

	/**
	 * Xe[^XC\Zbg܂B
	 */
	protected void setStatusLine() {
		/* Xe[^XC\L */
		statusLineManager = (SubStatusLineManager) (getEditorSite()
				.getActionBars().getStatusLineManager());
		statusLineManager.setVisible(true);
	}

	/**
	 * Pingf[^e[u\NXłB
	 * 
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	private final class PingTable extends AbstractTableView {
		/* J\[g */
		private boolean[] isColDirection;

		/*
		 * Pingf[^\e[u𐶐ĕԂ܂B
		 * 
		 * @return table Table
		 */
		private Table createTable(Composite parent) {
			GridData data2 = new GridData();
			data2.horizontalAlignment = GridData.FILL;
			data2.verticalAlignment = GridData.FILL;
			data2.grabExcessHorizontalSpace = true;
			data2.grabExcessVerticalSpace = true;

			table = new Table(parent, SWT.H_SCROLL | SWT.V_SCROLL
					| SWT.FULL_SELECTION);
			table.setLinesVisible(true);
			table.setHeaderVisible(true);
			table.setLayoutData(data2);

			isColDirection = new boolean[2];

			TableColumn[] col = new TableColumn[2];

			col[0] = new TableColumn(table, SWT.CENTER);
			col[0].setText("Response Date");
			col[0].setWidth(computeCol0Width());
			isColDirection[0] = true;

			col[0].addListener(SWT.Selection, new Listener() {
				public void handleEvent(Event event) {
					/* J\[gA\[gێ */
					isColDirection[0] = sortTable(table, 0, isColDirection[0]);
				}
			});

			col[1] = new TableColumn(table, SWT.CENTER);
			col[1].setText("Data");
			col[1].setWidth(computeCol1Width());
			isColDirection[1] = true;

			col[1].addListener(SWT.Selection, new Listener() {
				public void handleEvent(Event e) {
					/* J\[gA\[gێ */
					isColDirection[1] = sortIntegerTable(table, 1,
							isColDirection[1]);
				}
			});

			/*
			 * e[uړꍇ͂TCYꍇ̃Xi[łB
			 * 
			 */
			PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()
					.addControlListener(new ControlListener() {
						public void controlMoved(ControlEvent event) {
						}

						/**
						 * e[uTCYɃe[uJZbg܂B
						 */
						public void controlResized(ControlEvent event) {
							setResizedTableColumnWidth();
						}
					});

			return table;
		}

		protected void setResizedTableColumnWidth() {
			/*
			 * e[u\Ԃł΃e[uJZbg
			 */
			if (getEditorSite().getPage().isPartVisible(
					getEditorSite().getPart())
					&& getEditorSite().getShell() != null) {
				if (getEditorSite().getShell().getSize() != null) {
					
				}

			}
		}
	}
}
