/*
 * Created on 2004/08/07
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.server.protocol.smtp;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Properties;
import java.util.logging.Logger;

import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;

import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.LastCheckTimeUpDate;
import netjfwatcher.engine.alarm.AlarmMessageMake;
import netjfwatcher.engine.alarm.AlarmMessageResource;
import netjfwatcher.engine.alarm.AlarmRecovery;
import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;
import netjfwatcher.engine.view.editorpart.node.EditorNodeOperationInitialData;


/**
 * SMTPT[o̊ĎsNXłB
 *
 * @author Yoshimasa matsumoto
 *@@version 1.0
 */
public class ExecuteSMTPCheck {
    /* fobOpɎMMailMe\邩ۂFlag */
    private static final boolean IS_SHOW_MESSAGE = false;

    /** SMTPT[oւ̑MMail Encoding */
    public static final String MAIL_ENCODING = "iso-2022-jp";

    /** SMTPT[oւ̑MMail From */
    public static final String SMTP_TEST_MAIL_FROM = "netjfwatcher";

    /** SMTPT[oւ̑Mmail^Cg */
    public static final String SMTP_TEST_MAIL_TITLE = "SMTP Test mail";

    /* MO */
    private static Logger logger = null;

    /**
     * SMTPT[o`FbNNXCX^X𐶐܂B
     *
     */
    public ExecuteSMTPCheck() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * SMTPT[oMailMs\bhłB
     *
     * @param nodeInfo m[hĎ
     */
    public void checkSmtp(NodeWatchInfo nodeInfo) {
        /* SMTPĎvpeB擾 */
        String smtpHost = nodeInfo.getIpaddress();
        String sendAddress = nodeInfo.getSmtpTestAddress();
        String smtpPort = EditorNodeOperationInitialData.INITIAL_NODE_SMTP_PORT;
        String smtpTimeout = nodeInfo.getSmtpTimeout();

        try {
            // System.out.println("Smtp check");
            Properties props = System.getProperties();
            int port = 0;

            try {
                port = Integer.parseInt(nodeInfo.getSmtpPort());
                smtpPort = nodeInfo.getSmtpPort();
                props.put("mail.smtp.port", smtpPort);
            } catch (NumberFormatException e1) {
                /* Ď|[gwُ */
                logger.warning(
                    "Illegal SMTP Port = " + port + " , param = "
                    + nodeInfo.getSmtpPort());
            }

            try {
                int timeout = Integer.parseInt(smtpTimeout);

                if (timeout > 0) {
                    props.put("mail.smtp.connectiontimeout", smtpTimeout);
                    props.put("mail.smtp.timeout", smtpTimeout);
                }
            } catch (NumberFormatException e2) {
                /* Ď^CAEglwُ */
                logger.warning("Illegal SMTP Timeout = " + smtpTimeout);
            }

            // SMTPT[o[̃AhXw
            props.put("mail.smtp.host", smtpHost);

            // props.put("mail.smtp.user", smtpHost);

            /* System.out.println(props.getProperty("mail.smtp.host"));
            System.out.println(props.getProperty("mail.smtp.port"));
            System.out.println(
                props.getProperty("mail.smtp.connectiontimeout"));
            System.out.println(props.getProperty("mail.smtp.timeout"));
            System.out.println(props.getProperty("mail.smtp.user"));
            */
            Session session = Session.getDefaultInstance(props, null);
            MimeMessage mimeMessage = new MimeMessage(session);

            // M[AhXƑMҖw
            mimeMessage.setFrom(
                new InternetAddress(
                    "NetWatch" + "@" + smtpHost, SMTP_TEST_MAIL_FROM,
                    MAIL_ENCODING));

            // M惁[AhXw
            mimeMessage.setRecipients(Message.RecipientType.TO, sendAddress);

            // [̃^Cgw
            mimeMessage.setSubject(SMTP_TEST_MAIL_TITLE, MAIL_ENCODING);

            // [̓ew
            mimeMessage.setText("<h1>Hello World JavaMail</h1>", MAIL_ENCODING);

            // [̌`w
            mimeMessage.setHeader("Content-Type", "text/html");

            // Mtw
            mimeMessage.setSentDate(Calendar.getInstance().getTime());

            // M܂
            Transport.send(mimeMessage);

            /*
             * SMTPT[oւMailMɎMMail̊mF̂߂
             * POP3T[oMMailmF
             */
            checkPop(nodeInfo);

            if (
                AlarmRecovery.getInstance().isOccurredAlarmId(
                        nodeInfo.getIpaddress(),
                        AlarmMessageResource.SMTP_CHECK_ERROR)) {
                /* SMTPMeXgG[Zbg */
                AlarmMessageMake message = AlarmMessageMake.getInstance();
                message.setRecoverySmtpError(
                    nodeInfo.getIpaddress(), "SMTP server = " + smtpHost);
            }
        } catch (IllegalStateException e) {
            logger.warning(e.getMessage());

            AlarmMessageMake makeAlarm = AlarmMessageMake.getInstance();
            makeAlarm.setSmtpError(
                nodeInfo.getIpaddress(),
                "IllegalStateException : " + e.getMessage());
        } catch (UnsupportedEncodingException e) {
            logger.warning(e.getMessage());

            AlarmMessageMake makeAlarm = AlarmMessageMake.getInstance();
            makeAlarm.setSmtpError(
                nodeInfo.getIpaddress(),
                "UnsupportedEncodingException : " + e.getMessage());
        } catch (MessagingException e) {
            logger.warning(e.getMessage());

            AlarmMessageMake makeAlarm = AlarmMessageMake.getInstance();
            makeAlarm.setSmtpError(
                nodeInfo.getIpaddress(),
                "MessagingException : " + e.getMessage());
        } catch (IOException e) {
            logger.warning(e.getMessage());

            AlarmMessageMake makeAlarm = AlarmMessageMake.getInstance();
            makeAlarm.setSmtpError(
                nodeInfo.getIpaddress(), "IOException : " + e.getMessage());
        }

        try {
            /* Ďm[hŏI`FbNԍXV */
            LastCheckTimeUpDate updateLastCheckTime =
                LastCheckTimeUpDate.getInstance();
            updateLastCheckTime.updateCheckTime(nodeInfo.getIpaddress());
        } catch (DatabaseConnectionException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        } catch (SQLException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
    }

    /**
     * SMTPMeXgɑΉMPopݒ肳ĂꍇɁA
     * MeXgbZ[WM{bNX폜܂B
     *
     * @param nodeInfo m[hĎ
     * @throws UnsupportedEncodingException UnsupportedEncodingꍇ
     * @throws MessagingException Messagingňُ킪ꍇ
     * @throws IOException bZ[WANZXɎsꍇ
     */
    private void checkPop(NodeWatchInfo nodeInfo)
        throws UnsupportedEncodingException, MessagingException, IOException {
        String pop3Host = nodeInfo.getSmtpCheckPop3Host();
        String pop3User = nodeInfo.getSmtpCheckPop3User();
        String pop3Password = nodeInfo.getSmtpCheckPop3Password();
        String pop3Port = nodeInfo.getSmtpCheckPop3Port();
        String pop3Timeout = nodeInfo.getSmtpCheckPop3Timeout();

        if (
            (pop3Host == null) || pop3Host.equals("") || (pop3User == null)
                || pop3User.equals("") || (pop3Password == null)
                || pop3Password.equals("")) {
            /*
             * SMTPM`FbN̎M`FbNpPopzXg
             * ݒ肳ĂȂΉReturn
             */
            return;
        }

        int popPort = -1;

        try {
            popPort = Integer.parseInt(pop3Port);
        } catch (NumberFormatException e1) {
            logger.warning(e1.getMessage());
            e1.printStackTrace();
        }

        /*
         * Pop3T[oɐڑ
         *
         */
        Properties props = System.getProperties();

        try {
            int timeout = Integer.parseInt(pop3Timeout);

            if (timeout > 0) {
                props.put("mail.pop3.connectiontimeout", pop3Timeout);
                props.put("mail.pop3.timeout", pop3Timeout);
            }
        } catch (NumberFormatException e2) {
            logger.warning(e2.getMessage());
            e2.printStackTrace();
        }

        Store store = null;
        Folder folder = null;

        try {
            /*
             * Pop3ɐڑ
             *
             */
            Session session = Session.getDefaultInstance(props, null);
            store = session.getStore("pop3");
            store.connect(pop3Host, popPort, pop3User, pop3Password);

            /* tH_[open */
            folder = store.getFolder("INBOX");
            folder.open(Folder.READ_WRITE);

            /* tH_[ɂ郁bZ[W̐擾 */
            int totalMessages = folder.getMessageCount();

            if (IS_SHOW_MESSAGE) {
                System.out.println("[" + totalMessages + "ł");
            }

            if (totalMessages == 0) {
                return;
            }

            // bZ[W擾܂
            Message[] messages = folder.getMessages();

            for (int i = 0; i < messages.length; i++) {
                if (IS_SHOW_MESSAGE) {
                    // bZ[W\܂
                    showMessage(nodeInfo, messages[i]);
                }

                /*
                 * MbZ[W̒SMTPMeXgbZ[W
                 * 폜
                 */
                checkReceiveMessage(messages[i]);
            }
        } finally {
            /*
            * tH_[܂
            * MailMtH_[e폜
            */
            if ((folder != null) && folder.isOpen()) {
                try {
                    folder.close(true);
                } catch (MessagingException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }

            if ((store != null) && store.isConnected()) {
                try {
                    store.close();
                } catch (MessagingException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }
        }
    }

    /**
     * MailMbZ[WSMTP MailMeXgpbZ[W폜܂B
     *
     * @param msg MailMbZ[W
     * @throws MessagingException Messagingňُ킪ꍇ
     * @throws UnsupportedEncodingException UnsupportedEncodingꍇ
     */
    private void checkReceiveMessage(Message msg)
        throws MessagingException, UnsupportedEncodingException {
        /* SMTPM`FbNfp̎Mf[^i[[N */
        Address[] addr;
        String checkFrom = "";
        int isMuchFrom = -1;

        /*
         * SMTPM`FbNolƎMł̍oly
         * SMTPM`FbNSujectƎMłSubjectv
         * SMTPM`FbNbZ[WƂč폜
         */
        if ((addr = msg.getFrom()) != null) {
            checkFrom = MimeUtility.decodeText(addr[0].toString());
            isMuchFrom = checkFrom.indexOf(SMTP_TEST_MAIL_FROM);
        }

        String checkSubject = msg.getSubject();

        if (checkSubject.equals(SMTP_TEST_MAIL_TITLE) && (isMuchFrom >= 0)) {
            /* set the DELETED flag */
            msg.setFlag(Flags.Flag.DELETED, true);
        }

        /* System.out.println("message " + checkSubject);
        System.out.println("message " + checkFrom);
        */
    }

    /**
     * MailMbZ[We\܂B
     *
     * @param nodeInfo m[hĎ
     * @param msg MbZ[W
     * @throws UnsupportedEncodingException UnsupportedEncodingꍇ
     * @throws MessagingException Messagingňُ킪ꍇ
     * @throws IOException bZ[WRec̎łȂꍇ
     */
    private void showMessage(NodeWatchInfo nodeInfo, Message msg)
        throws UnsupportedEncodingException, MessagingException, IOException {
        Address[] addr;

        // ol
        if ((addr = msg.getFrom()) != null) {
            for (int j = 0; j < addr.length; j++) {
                logger.info(
                    "From : " + MimeUtility.decodeText(addr[j].toString()));
            }
        }

        // 
        if ((addr = msg.getRecipients(Message.RecipientType.TO)) != null) {
            for (int j = 0; j < addr.length; j++) {
                logger.info(
                    "To : " + MimeUtility.decodeText(addr[j].toString()));
            }
        }

        // 薼
        logger.info("Subject : " + msg.getSubject());

        // t
        /*
        Date d = msg.getSentDate();
        logger.info("Date : " + ((d != null) ? d.toString() : "Unknown"));
        */
        // TCY
        logger.info("Size : " + msg.getSize());

        // e
        logger.info("ContentsF\n" + msg.getContent());
    }
}
