/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.database.access.model.hsqldb;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.hsqldb.util.DatabaseManager;


/**
 * HSQLDB}l[W̐s\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class HsqldbDatabaseManager implements IObjectActionDelegate {
    /* HSQLDB DatabaseManagerCX^X */
    private static DatabaseManager dm = null;

    /* HSQLDBhCo[RlNV */
    private static Connection con = null;

    /**
     * HSQLDB}l[W̐sNXCX^X𐶐܂B
     *
     */
    public HsqldbDatabaseManager() {
        super();
    }

    /*
     *  ( Javadoc)
     * @see org.eclipse.ui.
     * IObjectActionDelegate#setActivePart(org.eclipse.jface.action.IAction,
     * org.eclipse.ui.IWorkbenchPart)
     */
    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    /*
     *  ( Javadoc)
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     */
    public void run(IAction action) {
        /* IWorkbenchWindow window =
            PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Cursor waitCursor =
            new Cursor(window.getShell().getDisplay(), SWT.CURSOR_WAIT);
        */
        try {
            /* window.getShell().setCursor(waitCursor);
            ((ApplicationWindow) window).setStatus(
                "Starting HSQLDB Database Manager.");
                */
            /* HSQLDB}l[WN */
            runDatabaseManager();

            /* ((ApplicationWindow) window).setStatus(
                "HSQLDB Database Manager Started.");
                */
        } catch (Exception e) {
            Shell shell = new Shell();
            MessageDialog.openInformation(
                shell, "Hsqldb Ui Plug-in",
                "Cannot start HSQLDB Database Manager:\n" + e.getMessage());
            shell.dispose();
        } finally {
            // window.getShell().setCursor(null);
            // waitCursor.dispose();
        }
    }

    /*
     *  ( Javadoc)
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.
     * eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {
        // currentProject = ActionUtil.findSelectedJavaProject(selection);
    }

    /*
     *@HSQLDB}l[WN܂B
     *
     */
    private static void runDatabaseManager()
        throws ClassNotFoundException, SQLException {
        /* HSQLDB URL擾 */
        String url = HsqldbParams.getInstance().getAccessUrl();

        /* HSQLDBhCo[RlNV擾 */
        Class.forName(HsqldbParams.getInstance().getDriver());
        con = DriverManager.getConnection(
                url, HsqldbParams.getInstance().getUser(),
                HsqldbParams.getInstance().getPasswd());

        if (con != null) {
            // needed to patch DatabaseManager so it could
            // be initialized and use the suplied connection

            /* PatchedDatabaseManager dm = new PatchedDatabaseManager();
            */
            dm = new DatabaseManager();
            dm.main();

            /* f[^x[X}l[W̊RlNVClose
             * Connecticonnect\bhclose܂ށj
             */
            dm.connect(con);
        }
    }

    /**
     * HSQLDBRlNVClose܂B
     *
     * @throws ClassNotFoundException hCoȂꍇ
     * @throws SQLException f[^x[XANZXɎsꍇ
     */
    public static void createEmptyHsqlDatabase()
        throws ClassNotFoundException, SQLException {
        /* HSQLDBhCo[h */
        String url = HsqldbParams.getInstance().getAccessUrl();
        Class.forName(HsqldbParams.getInstance().getDriver());

        /* f[^x[XRlNVClose */
        con = DriverManager.getConnection(
                url, HsqldbParams.getInstance().getUser(),
                HsqldbParams.getInstance().getPasswd());

        if (con != null) {
            con.close();
            con = null;
        }
    }

    /* ( Javadoc)
         * @see java.lang.Object#finalize()
         */
    protected void finalize() throws Throwable {
        super.finalize();

        if (con != null) {
            con.close();
            con = null;
        }
    }
}
