/*
 * Created on 2006/06/28
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.database.access.model;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Logger;
import java.util.regex.Pattern;

import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.filepreference.FilePreference;

import org.osgi.framework.Bundle;


/**
 * SNMP ifTypeC^tF[Xʂ𔻕ʂ邽߂̏Lqt@C
 * ͂ێNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class IfTypeDetectFile {
    /* MO */
    private static Logger logger;

    /* ifTypeR[hKeyƂăC^tF[XʖێMap */
    private HashMap ifTypeMap = new HashMap();

    private IfTypeDetectFile() {
        logger = Logger.getLogger(this.getClass().getName());
        parseIfTypeDefineFile();
    }

    /*
     * ifTypeC^tF[Xʂ𔻕ʂ邽߂̒`t@C͂܂B
     *
     */
    private void parseIfTypeDefineFile() {
        String fileName = FilePreference.IF_TYPE_DEFINE_FILE;

        int cnt = 0;

        InputStream instream = null;
        InputStreamReader instreamReader = null;
        BufferedReader bufReader = null;

        try {
            URL url = this.getDocumentURL(fileName);
            instream = url.openStream();
            instreamReader = new InputStreamReader(instream);
            bufReader = new BufferedReader(instreamReader);

            String lineString;
            Pattern pattern;
            String[] ifTypeJudgeArray;

            while ((lineString = bufReader.readLine()) != null) {
                if (lineString.indexOf("#") >= 0) {
                    // cnt++;
                    continue;
                }

                pattern = Pattern.compile("=");
                ifTypeJudgeArray = pattern.split(lineString);

                try {
                    if (ifTypeJudgeArray.length != 2) {
                        logger.info(lineString);
                    } else {
                        // logger.info("ifType code = " + ifTypeJudgeArray[0]);
                        // logger.info("if Name = " + ifTypeJudgeArray[1]);
                        ifTypeMap.put(ifTypeJudgeArray[0], ifTypeJudgeArray[1]);
                    }
                } catch (Exception e1) {
                    logger.warning(lineString);
                    e1.printStackTrace();
                }

                cnt++;
            }
        } catch (FileNotFoundException e) {
            // logger.severe("FileNotFoundException : " + filePath);
            e.printStackTrace();
        } catch (IOException e) {
            logger.severe(e.getMessage());
            e.printStackTrace();
        } finally {
            if (bufReader != null) {
                try {
                    bufReader.close();
                } catch (IOException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }

            if (instreamReader != null) {
                try {
                    instreamReader.close();
                } catch (IOException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }

            if (instream != null) {
                try {
                    instream.close();
                } catch (IOException e1) {
                    logger.warning(e1.getMessage());
                    e1.printStackTrace();
                }
            }
        }
    }

    /**
     * w̃t@CURLԂ܂B
     *
     * @param fileName t@C
     * @return url URL
     */
    public URL getDocumentURL(String fileName) {
        /* 摜肷邽߂PluginResource bundle */
        Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();
        URL url = null;
        url = bundle.getEntry(fileName);

        if (url == null) {
            /* bZ[W\[Xt@CȂꍇMO̎ */
            logger.severe("ifType defined file : " + fileName);
        }

        return url;
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static IfTypeDetectFile getInstance() {
        return SingletonResource.INSTANCE;
    }

    /**
     * ifTypeR[hKeyƂifʂi[MapԂ܂B
     *
     * @return ifTypeMap ifTypeR[hKeyƂifʂi[Map
     */
    public HashMap getIfTypeMap() {
        return ifTypeMap;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final IfTypeDetectFile INSTANCE = new IfTypeDetectFile();
    }
}
