/*
 * Created on 2004/10/16
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpagent.process;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;

import netjfwatcher.engine.resource.SnmpAgentConfigInfo;
import netjfwatcher.engine.resource.SnmpV3AgentConfig;
import netjfwatcher.snmp.messageformat.SNMPTLV;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.messageformat.SnmpErrorStatusException;
import netjfwatcher.snmp.messageformat.SnmpTrapPDU;
import netjfwatcher.snmp.preference.SnmpBERCodec;
import netjfwatcher.snmp.preference.SnmpPreference;
import netjfwatcher.snmp.snmpobject.message.SnmpMessage;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;
import netjfwatcher.snmpagent.model.AgentMonitorMessageQueue;



/**
 * SNMPv1G[WFgs\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class AgentV1MP extends AbstractAgentMessageProcessing {
    /* MO */
    private static Logger logger;

    /* Agent\` */
    private SnmpAgentConfigInfo info;

    /**
     * TrapMɌĂ΂A^G[WFgCX^X𐶐܂B
     *
     * @throws SocketException Socketňُ킪ꍇ
     */
    public AgentV1MP() throws SocketException {
        logger = Logger.getLogger(this.getClass().getName());
        this.version = SnmpPreference.SNMP_VERSION_1;
    }

    /**
     * Manager̃R}hMɌĂ΂^G[WFgCX^X
     * 𐶐܂B
     *
     * @param dSocket DatagramSocket
     * @throws SocketException Socketňُ킪ꍇ
     */
    public AgentV1MP(DatagramSocket dSocket) throws SocketException {
        logger = Logger.getLogger(this.getClass().getName());
        this.version = SnmpPreference.SNMP_VERSION_1;
        info =
            SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo()
                             .getSnmpAgentResourceInfo();

        this.resSendDatagramSocket = dSocket;
    }

    /**
     * Mf[^R}h𒊏oACommunity`FbNAΉ
     * R}hs܂B
     *
     * @param inPacket ̂߂̃f[^OpPbg
     * @param encodedMessage Mf[^oCg
     * @param receiveLength Mf[^
     * @throws SnmpErrorStatusException G[Xe[^XłȂꍇ
     * @throws SnmpBadValueException f[^͂܂͐ňُ킪ꍇ
     * @throws IOException f[^MɎsꍇ
     */
    public void process(
        DatagramPacket inPacket, byte[] encodedMessage, int receiveLength)
        throws SnmpErrorStatusException, SnmpBadValueException, IOException {
        this.inPacket = inPacket;

        String community = "";
        byte command = 0;
        SnmpMessage receivedMessage = null;

        // MR}ho
        try {
            receivedMessage = new SnmpMessage();

            SNMPTLV nextTLV = receivedMessage.extractNextTLV(encodedMessage, 0);
            receivedMessage.setTLV(nextTLV);

            byte[] versionByte = receivedMessage.getVersion();
            byte[] communityByte = receivedMessage.getCommunity();

            community = bytetoChar(communityByte);
            command = receivedMessage.getCommand();

            logger.info("Version : " + versionByte[0]);
            logger.info("Community : " + bytetoChar(communityByte));
            logger.info("Command : " + hexByte(command));
        } catch (SnmpBadValueException e) {
            logger.warning(e.getMessage());
            throw e;
        }

        this.receivedMessage = receivedMessage;

        switch (command) {
        case SnmpBERCodec.SNMPGETREQUEST:

            if (community.equals(info.getReadCommunity())) {
                this.getRequest(
                    version, info.getReadCommunity(), inPacket, receivedMessage);
            } else {
                logger.warning(
                    "Receive read community : " + community
                    + " Allow read community : " + info.getReadCommunity());

                Date date = Calendar.getInstance().getTime();

                /* SnmpG[WFgj^[\pZbg */
                AgentMonitorMessageQueue.getInstance().pushAgentMessage(
                    "Community error : " + dateformat.format(date)
                    + "Receive write community : " + community
                    + " Allow write community : " + info.getReadCommunity());
            }

            break;

        case SnmpBERCodec.SNMPGETNEXTREQUEST:


            if (community.equals(info.getReadCommunity())) {
                this.getNextRequest(
                    version, info.getReadCommunity(), inPacket, receivedMessage);
            } else {
                /* Access error */
                logger.warning(
                    "Receive read community : " + community
                    + " Allow read community : " + info.getReadCommunity());

                Date date = Calendar.getInstance().getTime();

                /* SnmpG[WFgj^[\pZbg */
                AgentMonitorMessageQueue.getInstance().pushAgentMessage(
                    "Community error : " + dateformat.format(date)
                    + "Receive write community : " + community
                    + " Allow write community : " + info.getReadCommunity());
            }

            break;

        case SnmpBERCodec.SNMPSETREQUEST:

            /*  */
            if (community.equals(info.getWriteCommunity())) {
                this.setRequest(
                    version, info.getWriteCommunity(), inPacket, receivedMessage);
            } else {
                logger.warning(
                    "Receive write community : " + community
                    + " Allow write community : " + info.getReadCommunity());

                Date date = Calendar.getInstance().getTime();

                /* SnmpG[WFgj^[\pZbg */
                AgentMonitorMessageQueue.getInstance().pushAgentMessage(
                    "Community error : " + dateformat.format(date)
                    + "Receive write community : " + community
                    + " Allow write community : " + info.getReadCommunity());
            }

            break;

        default:
            logger.warning("Undefined command : " + hexByte(command));

            Date date = Calendar.getInstance().getTime();
            DateFormat dateformat = new SimpleDateFormat("HH:mm:ss");

            /* SnmpG[WFgj^[\pZbg */
            AgentMonitorMessageQueue.getInstance().pushAgentMessage(
                "Undefined command : " + hexByte(command) + ": "
                + dateformat.format(date));
        }
    }

    /**
     * wPDUŃbZ[W𐶐A}l[WTrap𑗐M܂B
     *
     * @param hostAddress ManagerAhX
     * @param community R~jeB
     * @param pdu Trap PDU
     * @throws GeneralSecurityException ZLeB֘Aňُ킪ꍇ
     * @throws UnknownHostException MAhXs̏ꍇ
     * @throws SnmpBadValueException MTrapbZ[W̐Ɏsꍇ
     * @throws IOException Trap̑MɎsꍇ
     */
    public void sendTrap(
        final String hostAddress, final String community, final SnmpSequence pdu)
        throws GeneralSecurityException, UnknownHostException, 
            SnmpBadValueException, IOException {
        InetAddress targetAddress = null;

        try {
            targetAddress = InetAddress.getByName(hostAddress);
        } catch (UnknownHostException e) {
            logger.warning(e.getMessage());

            /* SnmpG[WFgj^[\pZbg */
            Date date = Calendar.getInstance().getTime();
            AgentMonitorMessageQueue.getInstance().pushAgentMessage(
                "Abort send trap to " + hostAddress + " : "
                + dateformat.format(date));
            AgentMonitorMessageQueue.getInstance().pushAgentMessage(
                e.getMessage());
            e.printStackTrace();
            throw e;
        }

        SnmpMessage message = null;

        if (pdu instanceof SnmpTrapPDU) {
            message = new SnmpMessage(version, community, (SnmpTrapPDU) pdu);
        } else {
            throw new SnmpBadValueException("Illegal Trap pdu");
        }

        byte[] messageEncoding = message.getBEREncoding();
        DatagramPacket outPacket =
            new DatagramPacket(
                messageEncoding, messageEncoding.length, targetAddress, trapPort);

        trapDatagramSocket.send(outPacket);
    }
}
