/*
 * Created on 2004/12/30
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.snmp.snmpobject.opaque;

import java.util.logging.Logger;

import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.preference.SnmpBERCodec;



/**
 * ASN.1 Type(^O)ɂOPAQUE_FLOAT(^O 0x78)ɑΉSNMPIuWFNg
 * 𑀍삷郁\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class SnmpOpaqueFloat extends SnmpOpaque {

    private static Logger logger;

    /** l(32bits _(float)) */
    private float opaqueFloatValue;

    /**
     * <p>OpaqueFloatData ̃CX^X𐶐܂B</p>
     *
     * @param value l
     */
    protected SnmpOpaqueFloat(float value) {
        logger = Logger.getLogger(this.getClass().getName());
        this.opaqueFloatValue = value;
    }

    /**
     * <p>OpaqueFloatData ̃CX^X𐶐܂B</p>
     *
     * @param data byte 
     * @param offset ǂݏoJnʒu
     * @param length (oCg)
     * @throws SnmpBadValueException f[^sȏꍇɃX[܂B
     */
    protected SnmpOpaqueFloat(byte[] data, int offset, int length)
        throws SnmpBadValueException {
        logger = Logger.getLogger(this.getClass().getName());
        opaqueFloatValue = decode(data, offset, length);
    }

    /**
     * <p>̃IuWFNg̕\Ԃ܂</p>
     *
     * @return 
     */
    public String toString() {
        return Float.toString(opaqueFloatValue);
    }

    /**
     * <p>̃IuWFNg̒l Basic Encoding Rule ɏ] byte ɕϊ܂B</p>
     *
     * @return ϊ byte 
     */
    byte[] encode() {
        return encode(opaqueFloatValue);
    }

    /**
     * <p>w肳ꂽ float l Basic Encoding Rule ɏ] byte ɕϊ܂B</p>
     *
     * @param value l
     * @return ϊ byte 
     */
    public byte[] encode(float value) {
        int intValue = Float.floatToIntBits(value);
        byte[] array = new byte[9];
        array[0] = (byte) 0x44;
        array[1] = (byte) 7;
        array[2] = (byte) 0x9f;
        array[3] = (byte) SnmpBERCodec.OPAQUE_FLOAT;
        array[4] = (byte) 4;
        array[5] = (byte) ((intValue >> 24) & MASK_0XFF);
        array[6] = (byte) ((intValue >> 16) & MASK_0XFF);
        array[7] = (byte) ((intValue >> 8) & MASK_0XFF);
        array[8] = (byte) (intValue & MASK_0XFF);

        return array;
    }

    /**
     * <p>w肳ꂽ byte  Basic Encoding Rule ɏ] float lɕϊ܂B</p>
     *
     * @param data byte 
     * @param offset ǂݏoJnʒu
     * @param length (oCg)
     * @return ϊ̒l
     * @throws SnmpBadValueException f[^sȏꍇɃX[܂B
     */
    public float decode(byte[] data, int offset, int length)
        throws SnmpBadValueException {
        if (length != 4) {
            throw new SnmpBadValueException(
                new StringBuffer().append("length is not 4: ").append(length)
                                  .toString());
        }

        int intValue = 0;

        try {
            for (int i = 0; i < length; i++) {
                intValue <<= 8;
                intValue |= (data[offset + i] & MASK_0XFF);
            }
        } catch (ArrayIndexOutOfBoundsException e) {
            throw new SnmpBadValueException(e.getMessage());
        }

        return Float.intBitsToFloat(intValue);
    }

    /**
     * OpaqueIuWFNgԂ܂B
     *
     * @return obj OpaqueIuWFNg
     */
    public Object getValue() {
        Float valued = new Float(opaqueFloatValue);

        return valued;
    }
}
