/*
 * Created on 2004/04/01
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.snmp.messageformat;

import netjfwatcher.snmp.preference.SnmpBERCodec;
import netjfwatcher.snmp.snmpobject.integer.SnmpCounter32;
import netjfwatcher.snmp.snmpobject.integer.SnmpCounter64;
import netjfwatcher.snmp.snmpobject.integer.SnmpGauge32;
import netjfwatcher.snmp.snmpobject.integer.SnmpInteger;
import netjfwatcher.snmp.snmpobject.integer.SnmpTimeTicks;
import netjfwatcher.snmp.snmpobject.integer.SnmpUInteger32;
import netjfwatcher.snmp.snmpobject.message.SnmpNull;
import netjfwatcher.snmp.snmpobject.message.SnmpObjectIdentifier;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;
import netjfwatcher.snmp.snmpobject.octetstring.SnmpIPAddress;
import netjfwatcher.snmp.snmpobject.octetstring.SnmpNSAPAddress;
import netjfwatcher.snmp.snmpobject.octetstring.SnmpOctetString;


/**
 * SNMP ASN.1 BERGR[fBOTAGR[hɑΉSNMPIuWFNg
 * CX^X̃}bsOe[uێNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class SnmpMappingResource {
    /* R}hIDɑΉR}hCX^X̔z */
    private Object[][] commandMappingTable =
    {
        { SnmpBERCodec.SNMPINTEGER, new SnmpInteger() },
        { SnmpBERCodec.SNMPOCTETSTRING, new SnmpOctetString() },
        { SnmpBERCodec.SNMPNULL, new SnmpNull() },
        { SnmpBERCodec.SNMPOBJECTIDENTIFIER, new SnmpObjectIdentifier() },
        { SnmpBERCodec.SNMPSEQUENCE, new SnmpSequence() },
        { SnmpBERCodec.SNMPIPADDRESS, new SnmpIPAddress() },
        { SnmpBERCodec.SNMPUINTEGER32, new SnmpUInteger32() },
        { SnmpBERCodec.SNMPCOUNTER32, new SnmpCounter32() },
        { SnmpBERCodec.SNMPCOUNTER64, new SnmpCounter64() },
        { SnmpBERCodec.SNMPGAUGE32, new SnmpGauge32() },
        { SnmpBERCodec.SNMPTIMETICKS, new SnmpTimeTicks() },
        { SnmpBERCodec.SNMPNSAPADDRESS, new SnmpNSAPAddress() }
    };

    /**
     * R}h}bsOe[uԂ܂B<BR>
     *
     * @return commandMappingTable R}h}bsOe[u
     */
    public Object[][] getCommandMappingTable() {
        return commandMappingTable;
    }
}
