/*
 * Created on 2004/05/09
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.server.protocol.control;

import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

import netjfwatcher.engine.nodecontrol.NodeKind;
import netjfwatcher.engine.nodewatchinfo.BaseNodeWatchInfoList;
import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;



/**
 * SNMPftHgMIBĎi[Ă郊XgǂŃJE^1b
 * JEg_EJE^0ƂȂsL[PushThread
 * NXłB
 *
 *
 *            ThreadListReadQ
 *           iĎJEgAĎŃL[Pushj
 *        Read         Push
 * |  | ---------+   +---------------+   Queue
 * |--|                            |  |
 * |--|                            |   |
 * |--|                            |   |
 * |--|                            |   |    ThreadQueueCheck
 * +--+                            |   |   iL[Ƀf[^
 *                                 |   |      `FbNsj
 * ListQueue                                    
 * im[ho^/폜                    +----------+  +----- Exec
 *  ŃXgZbgj
 *
 *
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ThreadListReadQueuePushDefaultSnmpMib implements Runnable {
    /* Thread sleep */
    private static final int WAIT_SLEEP_TIME = 1000;

    /* MO */
    private static Logger logger = null;

    /**
     * ISNMPftHgMIB̎m[h̃XgIɓǂŃL[Push
     * ThreadNXCX^X𐶐܂B
     */
    public ThreadListReadQueuePushDefaultSnmpMib() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * ISNMPftHgMIB̎m[h̃XgIɓǂŃL[Push
     * ܂B
     */
    public void run() {
        int count = 0;
        Iterator it = null;

        while (true) {
            // SnmpĎm[hXgǂݍ
            Map list =
                ListQueueDefaultSnmpMibControl.getInstance()
                                              .getDefaultSnmpMibHashMap();

            for (it = list.keySet().iterator(); it.hasNext();) {
                String key = (String) it.next();
                NodeWatchInfo info = (NodeWatchInfo) list.get(key);

                if (info == null) {
                    continue;
                }

                NodeWatchInfo nodeInfo =
                    BaseNodeWatchInfoList.getInstance().getNodeWatchInfo(
                        info.getIpaddress());

                if (
                    (nodeInfo == null)
                        || !nodeInfo.getSystemMIBStatus().equals(
                            NodeWatchInfo.SYSTEM_MIB_OK)
                        || !nodeInfo.getInterfaceMIBStatus().equals(
                            NodeWatchInfo.INTERFACE_MIB_OK)) {
                    continue;
                }

                if(nodeInfo.getNodeKind().equals(NodeKind.PRINTER) && !nodeInfo.getPrintMIBStatus().equals(
                        NodeWatchInfo.PRINT_MIB_OK)) {
                	continue;
                }
                // o
                count = Integer.parseInt(info.getCountSnmpPeriod());

                if (count != 0) {
                    count--;
                    info.setCountSnmpPeriod(Integer.toString(count));

                    if (count == 0) {
                        // Snmp configĎsL[Push
                        QueueForDefaultSnmpMib.getInstance().pushQue(info);

                        // Snmp configĎJE^Zbg
                        info.setCountSnmpPeriod(info.getSnmpPeriod());
                    }
                }
            }

            try {
                Thread.sleep(WAIT_SLEEP_TIME);
            } catch (InterruptedException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }
}
