/*
 * Created on 2004/12/13
 *
 *
 *
 */
package netjfwatcher.engine.command.model;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableStatisticsMIBControl;
import netjfwatcher.engine.command.control.TemplateCommandImpl;
import netjfwatcher.engine.resource.StatisticsMibFileLoad;
import netjfwatcher.engine.socket.CommandInfo;
import netjfwatcher.engine.socket.info.StatisticsMibControl;
import netjfwatcher.engine.socket.info.StatisticsMibProperty;


/**
 * vMIB̎EĎݒ擾郁\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class CommandStatisticsMibGet extends TemplateCommandImpl {
    private static Logger logger;

    /**
     * vMIB̎EĎݒԂ܂B
     *
     * @param com R}h
     * @param ois ̓Xg[
     * @param oos o̓Xg[
     */
    public void doInvoke(
        CommandInfo com, ObjectInputStream ois, ObjectOutputStream oos) {
        logger = Logger.getLogger(this.getClass().getName());

        /* ̎wOIDAf[^vOIDCX^Xyэ̎JnAŏI */
        StatisticsMibControl statisticsMibControl =
            com.getStatisticsMibControl();

        /* OIDCX^X̃f[^A̎ԁAPʂȂ */
        StatisticsMibProperty mibProperty = null;

        try {
            DBTableStatisticsMIBControl mibDBTable =
                DBTableStatisticsMIBControl.getInstance();

            if (
                statisticsMibControl.getSubCommand().equals(
                        StatisticsMibControl.STATISTICS_DATA_GET)) {
                /* vMIB̎̎wCX^X̃f[^擾R}hR[h */
                /* vMIB̎OID̒PʕZbg */
                StatisticsMibFileLoad statisticsMibFile =
                    StatisticsMibFileLoad.getInstance();
                HashMap statisticsMibMapList =
                    statisticsMibFile.getFileParse().getStatisticsMibMapList();
                String statisticsMibUnit = "";
                statisticsMibUnit =
                    (String) statisticsMibMapList.get(
                        statisticsMibControl.getOid().replace('_', '.'));

                /* OIDCX^X̍̎ԂZbg */
                ArrayList list = null;
                list =
                    mibDBTable.findInstance(
                        statisticsMibControl.getIpaddress(),
                        statisticsMibControl.getOid(),
                        statisticsMibControl.getOidInstance(),
                        statisticsMibControl.getPeriodStartDate(),
                        statisticsMibControl.getPeriodEndDate());

                mibProperty =
                    mibDBTable.getDataCount(
                        statisticsMibControl.getIpaddress(),
                        statisticsMibControl.getOid(),
                        statisticsMibControl.getOidInstance());
                mibProperty.setMibInstanceUnit(statisticsMibUnit);
                mibProperty.setMibInfoList(list);
            } else if (
                statisticsMibControl.getSubCommand().equals(
                        StatisticsMibControl.IF_DESCRIPTOR_GET)) {
                /* vMIB̎̃CX^X擾R}hR[h */
                /* vMIB̎łOIDCX^XifDescȂǂ */
                /* mibProperty = new StatisticsMibProperty();

                ArrayList ifDescriptorList = null;
                ifDescriptorList =
                    mibDBTable.findIfDescriptor(
                        statisticsMibControl.getIpaddress());
                mibProperty.setMibIfDescriptorList(ifDescriptorList); */
                mibProperty =
                    mibDBTable.findStatisticsInstanceMap(
                        statisticsMibControl.getIpaddress());
            } else if (
                statisticsMibControl.getSubCommand().equals(
                        StatisticsMibControl.STATISTICS_SET_STATUS_GET)) {
                /* vMIB̎ݒR}hR[h */
                /* vMIB̎ł̍̎f[^A̎ԁAőlAŏlZbg */
                mibProperty = new StatisticsMibProperty();

                ArrayList statisticsMibSetStatusList = null;
                statisticsMibSetStatusList =
                    mibDBTable.getList(statisticsMibControl.getIpaddress());
                mibProperty.setStatisticsMibSetList(statisticsMibSetStatusList);
            }
        } catch (SQLException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        } catch (DatabaseConnectionException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }

        sendResponse(mibProperty, ois, oos);
    }
}
