/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.socketclient;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import netjfwatcher.engine.model.action.ActionBuilderAlarmList;
import netjfwatcher.engine.model.action.ActionBuilderNetworkCamera;
import netjfwatcher.engine.model.action.ActionBuilderNodeOperation;
import netjfwatcher.engine.model.action.ActionBuilderSnmp;
import netjfwatcher.engine.nodemaneger.list.NodeListTableView;
import netjfwatcher.engine.nodemaneger.list.NodeListTableViewContentProvider;
import netjfwatcher.engine.nodemaneger.list.NodeListTableViewLabelProvider;
import netjfwatcher.engine.resourceconfig.ClientEngineInfo;
import netjfwatcher.engine.socket.ConnectionNodeInformation;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.common.TableColumnControlTableListener;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;

public class NetworkClientNodeListTableView
extends NodeListTableView {
    private static Logger logger = null;
    private SubStatusLineManager statusLineManager;

    public NetworkClientNodeListTableView() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.textBackColor = Display.getCurrent().getSystemColor(1);
    }

    public void createPartControl(Composite parent) {
        this.createTable(parent);
        this.viewer = new TableViewer(this.table);
        this.viewer.setUseHashlookup(true);
        this.viewer.setContentProvider((IContentProvider)new NodeListTableViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new NodeListTableViewLabelProvider());
        this.createImage();
        this.createContextMenu();
        this.setToolBarActions();
        this.setNodeListView(false);
        this.table.addSelectionListener((SelectionListener)new TableColumnControlTableListener(this.table, 6));
    }

    private void createContextMenu() {
        MenuManager mm = new MenuManager();
        mm.setRemoveAllWhenShown(true);
        mm.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                NetworkClientNodeListTableView.this.fillContextMenu(manager);
            }
        });
        Menu menu = mm.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(mm, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add(this.nodeListAction.getActionShowNodeListTable());
        manager.add(this.nodeListAction.getActionImportNodeListFileSocket());
        manager.add(this.nodeListAction.getActionExportNodeListFileSocket());
        manager.add(this.actionBuilderNodeOperation.getActionNodeOperationSocket());
        if (this.table.getSelectionIndex() >= 0 && this.table.getSelection() != null) {
            TableItem[] item = this.table.getSelection();
            String[] nodeInfo = (String[])item[0].getData();
            this.selectIPAddress = nodeInfo[3];
            NodeInformation targetNodeInfo = (NodeInformation)this.nodeInfoIPAddressMap.get(this.selectIPAddress);
            ((ActionBuilderNodeOperation.ActionNodeOperation)this.actionBuilderNodeOperation.getActionNodeOperation()).setNodeInfo(targetNodeInfo);
            ((ActionBuilderNodeOperation.ActionShowNodeViewSocket)this.actionBuilderNodeOperation.getActionShowNodeViewSocket()).setNodeInfo(targetNodeInfo);
            manager.add(this.actionBuilderNodeOperation.getActionShowNodeViewSocket());
            ((ActionBuilderSnmp.ActionShowNodeSnmpViewSocket)this.snmpAction.getActionSnmpInfoSocket()).setNodeInfo(targetNodeInfo);
            manager.add(this.snmpAction.getActionSnmpInfoSocket());
            ((ActionBuilderAlarmList.ActionOpenEditorPartPersonalNodeAlarmSocket)this.alarmAction.getActionOpenEditorPartPersonalNodeAlarmSocket()).setNodeInfo(targetNodeInfo);
            manager.add(this.alarmAction.getActionOpenEditorPartPersonalNodeAlarmSocket());
            ((ActionBuilderAlarmList.ActionExportAlarmInfoSocket)this.alarmAction.getActionExportAlarmSocket()).setIpAddress(this.selectIPAddress);
            manager.add(this.alarmAction.getActionExportAlarmSocket());
            this.nodePingMenu.createPingMenu(manager, targetNodeInfo, true);
            this.nodeSnmpStatisticsMenu.createSnmpStatisticsMenu(manager, targetNodeInfo, true);
            ((ActionBuilderSnmp.ActionSnmpStatisticsSetSocket)this.snmpAction.getActionSnmpStatisticsSetSocket()).setNodeInfo(targetNodeInfo);
            manager.add(this.snmpAction.getActionSnmpStatisticsSetSocket());
            if (targetNodeInfo.getNodeKind().equals("Printer")) {
                ((ActionBuilderSnmp.ActionSnmpPrint)this.snmpAction.getActionPrintSnmp()).setNodeInfo(targetNodeInfo);
                manager.add(this.snmpAction.getActionPrintSnmp());
            }
            if (targetNodeInfo.getNodeKind().equals("Camera")) {
                ((ActionBuilderNetworkCamera.ActionNetworkCamera)this.networkCameraAction.getActionNetworkCamera()).setNodeInfo(targetNodeInfo);
                manager.add(this.networkCameraAction.getActionNetworkCamera());
            }
        }
        manager.add(this.alarmAction.getActionShowAllNodeAlarmListTableSocket());
        manager.add(this.snmpAction.getActionSnmpStatisticsSocket());
    }

    private void setToolBarActions() {
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add(this.nodeListAction.getActionShowNodeListTable());
        toolBarManager.add(this.nodeListAction.getActionImportNodeListFileSocket());
        toolBarManager.add(this.nodeListAction.getActionExportNodeListFileSocket());
        toolBarManager.add(this.alarmAction.getActionShowAllNodeAlarmListTableSocket());
        ((ActionBuilderAlarmList.ActionExportAlarmInfoSocket)this.alarmAction.getActionExportAlarmSocket()).setIpAddress("all");
        toolBarManager.add(this.alarmAction.getActionExportAlarmSocket());
        toolBarManager.add(this.actionBuilderEditorPart.actionCloseAllEditors());
    }

    public ArrayList getNodeList() {
        ArrayList nodeList = null;
        String engineAddress = ClientEngineInfo.getClientEngineInfoInstance().getEngineAddress();
        try {
            ConnectionNodeInformation connectNodeInfo = new ConnectionNodeInformation(engineAddress);
            nodeList = connectNodeInfo.getNodeInformationList(null, null);
        }
        catch (EngineConnectException e) {
            Shell shell = new Shell();
            MessageDialog.openError((Shell)shell, (String)"Node List import error", (String)(String.valueOf(e.getMessage()) + " Engine = " + engineAddress));
            logger.warning("Node List import error" + e.getMessage());
            shell.dispose();
            e.printStackTrace();
        }
        catch (IOException e) {
            Shell shell = new Shell();
            MessageDialog.openError((Shell)shell, (String)"Node List import error", (String)(String.valueOf(e.getMessage()) + " Engine = " + engineAddress));
            logger.warning("Node List import error" + e.getMessage());
            shell.dispose();
            e.printStackTrace();
        }
        return nodeList;
    }
}

