/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmp.messageformat;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.messageformat.SnmpVarBindList;
import netjfwatcher.snmp.snmpobject.integer.SnmpInteger;
import netjfwatcher.snmp.snmpobject.integer.SnmpTimeTicks;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;
import netjfwatcher.snmp.snmpobject.message.SnmpObjectIdentifier;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;
import netjfwatcher.snmp.snmpobject.octetstring.SnmpIPAddress;

public class SnmpTrapPDU
extends SnmpSequence {
    private static final int ENTERPRISE_OID_POS = 0;
    private static final int AGNET_ADDRESS_POS = 1;
    private static final int GENERIC_TRAP_CODE_POS = 2;
    private static final int SPECIFIC_TRAP_CODE_POS = 3;
    private static final int TIMESTAMP_POS = 4;
    private static final int VA_BIND_LIST_POS = 5;

    public SnmpTrapPDU(SnmpObjectIdentifier enterpriseOID, SnmpIPAddress agentAddress, int genericTrap, int specificTrap, SnmpTimeTicks timestamp, SnmpSequence varList) throws SnmpBadValueException {
        this.tag = (byte)-92;
        List<AbstractSnmpObject> contents = Collections.synchronizedList(new ArrayList());
        contents.add(enterpriseOID);
        contents.add(agentAddress);
        contents.add(new SnmpInteger(genericTrap));
        contents.add(new SnmpInteger(specificTrap));
        contents.add(timestamp);
        contents.add(varList);
        this.setValue(contents);
    }

    public SnmpTrapPDU(SnmpObjectIdentifier enterpriseOID, SnmpIPAddress agentAddress, int genericTrap, int specificTrap, SnmpTimeTicks timestamp) throws SnmpBadValueException {
        this.tag = (byte)-92;
        List<AbstractSnmpObject> contents = Collections.synchronizedList(new ArrayList());
        contents.add(enterpriseOID);
        contents.add(agentAddress);
        contents.add(new SnmpInteger(genericTrap));
        contents.add(new SnmpInteger(specificTrap));
        contents.add(timestamp);
        contents.add(new SnmpVarBindList());
        this.setValue(contents);
    }

    public SnmpTrapPDU(byte[] enc) throws SnmpBadValueException {
        this.tag = (byte)-92;
        this.extractFromBEREncoding(enc);
    }

    public byte getPDUType() {
        return this.tag;
    }

    public SnmpSequence getVarBindList() {
        List contents = (List)this.getValue();
        if (contents.get(5) instanceof SnmpSequence) {
            return (SnmpSequence)contents.get(5);
        }
        return null;
    }

    public SnmpObjectIdentifier getEnterpriseOID() {
        List contents = (List)this.getValue();
        if (contents.get(0) instanceof SnmpObjectIdentifier) {
            return (SnmpObjectIdentifier)contents.get(0);
        }
        return null;
    }

    public SnmpIPAddress getAgentAddress() {
        List contents = (List)this.getValue();
        if (contents.get(1) instanceof SnmpIPAddress) {
            return (SnmpIPAddress)contents.get(1);
        }
        return null;
    }

    public int getGenericTrap() {
        List contents = (List)this.getValue();
        return ((BigInteger)((SnmpInteger)contents.get(2)).getValue()).intValue();
    }

    public int getSpecificTrap() {
        List contents = (List)this.getValue();
        return ((BigInteger)((SnmpInteger)contents.get(3)).getValue()).intValue();
    }

    public long getTimestampData() {
        List contents = (List)this.getValue();
        if (contents.get(4) instanceof SnmpTimeTicks) {
            return ((BigInteger)((SnmpTimeTicks)contents.get(4)).getValue()).longValue();
        }
        return 0L;
    }

    public AbstractSnmpObject getTimestamp() {
        List contents = (List)this.getValue();
        if (contents.get(4) instanceof AbstractSnmpObject) {
            return (AbstractSnmpObject)contents.get(4);
        }
        return null;
    }
}

