/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.server.protocol.control;

import java.util.logging.Logger;
import netjfwatcher.engine.nodewatchinfo.BaseNodeWatchInfoList;
import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;
import netjfwatcher.engine.server.protocol.control.BusyCheckForPop3;
import netjfwatcher.engine.server.protocol.control.QueueForPop3;
import netjfwatcher.engine.server.protocol.pop.ExecutePopCheck;

public class ThreadQueueCheckPop3
implements Runnable {
    private static final int WAIT_SLEEP_TIME = 1000;
    private static Logger logger = null;

    public ThreadQueueCheckPop3() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public void run() {
        ExecutePopCheck checkPop3 = new ExecutePopCheck();
        while (!Thread.interrupted()) {
            NodeWatchInfo info = QueueForPop3.getInstance().popQueue();
            NodeWatchInfo checkIPAddress = null;
            if (info != null) {
                checkIPAddress = BaseNodeWatchInfoList.getInstance().getNodeWatchInfo(info.getIpaddress());
            }
            if (info != null && checkIPAddress != null) {
                if (BusyCheckForPop3.getInstance().getArbitrationExec(info.getIpaddress())) {
                    checkPop3.checkPop(info);
                    BusyCheckForPop3.getInstance().release(info.getIpaddress());
                } else {
                    logger.warning("Busy Pop3 IP = " + info.getIpaddress());
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

