/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.preferance;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import netjfwatcher.authentication.AuthenticationConfig;
import netjfwatcher.engine.preferance.AbstractEnginePreferancePage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jdom.Document;

public class AuthenticationPreferencePage
extends AbstractEnginePreferancePage
implements IWorkbenchPreferencePage {
    private static Logger logger;
    private static final int TEXT_WIDTH = 120;
    private static final int LIST_WIDTHHINT = 200;
    private static final int LIST_VERTIALSPAN = 7;
    private static final int LIST_ITEMHEIGHT = 8;
    private static Color whiteColor;
    private List userNameSelectList;
    private Button addButton;
    private Button editButton;
    private Button deleteButton;
    private Text userNameWorkText;
    private Text passwordWorkText;
    private Map userNameMap;
    private Map userNamePreferenceMap;

    static {
        whiteColor = new Color(null, 255, 255, 255);
    }

    public void init(IWorkbench workbench) {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.userNamePreferenceMap = AuthenticationConfig.getInstance().getAuthInfo().getUserMap();
        this.userNameMap = Collections.synchronizedMap(new HashMap());
    }

    protected Control createContents(Composite parent) {
        Color textBackColor = whiteColor;
        GridLayout layout = new GridLayout(1, false);
        parent.setLayout((Layout)layout);
        GridData gridData = null;
        GridLayout gridLayout = new GridLayout(2, false);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(256));
        gridData = new GridData();
        Label label = new Label(composite, 16384);
        label.setText("User Name List");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText(" ");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.userNameSelectList = new List(composite, 2564);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        data.verticalSpan = 7;
        data.widthHint = 200;
        data.heightHint = this.userNameSelectList.getItemHeight() * 8;
        this.userNameSelectList.setLayoutData((Object)data);
        this.addButton = new Button(composite, 0);
        this.addButton.setText("Add");
        this.addButton.setLayoutData((Object)new GridData());
        label = new Label(composite, 0);
        label.setText("");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.editButton = new Button(composite, 0);
        this.editButton.setText("Edit");
        this.editButton.setLayoutData((Object)new GridData());
        label = new Label(composite, 0);
        label.setText("");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.deleteButton = new Button(composite, 0);
        this.deleteButton.setText("Delete");
        this.deleteButton.setLayoutData((Object)new GridData());
        label = new Label(composite, 0);
        label.setText("");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("User Name");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.userNameWorkText = new Text(composite, 2048);
        this.userNameWorkText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.userNameWorkText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Password");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.passwordWorkText = new Text(composite, 0x400800);
        this.passwordWorkText.setBackground(textBackColor);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 120;
        this.passwordWorkText.setLayoutData((Object)gridData);
        this.initShowXMLSocketProp();
        this.setListener();
        return composite;
    }

    private void setListener() {
        this.userNameSelectList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int index = AuthenticationPreferencePage.this.userNameSelectList.getSelectionIndex();
                if (index < 0) {
                    return;
                }
                AuthenticationPreferencePage.this.userNameWorkText.setText(AuthenticationPreferencePage.this.userNameSelectList.getItem(index));
                String password = (String)AuthenticationPreferencePage.this.userNameMap.get(AuthenticationPreferencePage.this.userNameWorkText.getText());
                if (password != null) {
                    AuthenticationPreferencePage.this.passwordWorkText.setText(password);
                }
            }
        });
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                if (!AuthenticationPreferencePage.this.userNameWorkText.getText().equals("") && !AuthenticationPreferencePage.this.passwordWorkText.getText().equals("")) {
                    if (!AuthenticationPreferencePage.this.userNameMap.containsKey(AuthenticationPreferencePage.this.userNameWorkText.getText())) {
                        AuthenticationPreferencePage.this.userNameMap.put(AuthenticationPreferencePage.this.userNameWorkText.getText(), AuthenticationPreferencePage.this.passwordWorkText.getText());
                        AuthenticationPreferencePage.this.showXMLSocketProp();
                    } else {
                        MessageDialog.openError((Shell)AuthenticationPreferencePage.this.getShell(), (String)"Error", (String)("Already User Name = " + AuthenticationPreferencePage.this.userNameWorkText.getText()));
                        return;
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.editButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                if (!AuthenticationPreferencePage.this.userNameWorkText.getText().equals("") && !AuthenticationPreferencePage.this.passwordWorkText.getText().equals("")) {
                    if (AuthenticationPreferencePage.this.userNameMap.containsKey(AuthenticationPreferencePage.this.userNameWorkText.getText())) {
                        for (Map.Entry ent : AuthenticationPreferencePage.this.userNameMap.entrySet()) {
                            String username = (String)ent.getKey();
                            if (!AuthenticationPreferencePage.this.userNameWorkText.getText().equals(username)) continue;
                            AuthenticationPreferencePage.this.userNameMap.put(username, AuthenticationPreferencePage.this.passwordWorkText.getText());
                            break;
                        }
                        AuthenticationPreferencePage.this.showXMLSocketProp();
                    } else {
                        MessageDialog.openError((Shell)AuthenticationPreferencePage.this.getShell(), (String)"Error", (String)("No Exit User Name = " + AuthenticationPreferencePage.this.userNameWorkText.getText()));
                        return;
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                if (!AuthenticationPreferencePage.this.userNameWorkText.getText().equals("") && !AuthenticationPreferencePage.this.passwordWorkText.getText().equals("")) {
                    if (AuthenticationPreferencePage.this.userNameMap.containsKey(AuthenticationPreferencePage.this.userNameWorkText.getText())) {
                        AuthenticationPreferencePage.this.userNameMap.remove(AuthenticationPreferencePage.this.userNameWorkText.getText());
                        for (Map.Entry ent : AuthenticationPreferencePage.this.userNameMap.entrySet()) {
                            String userName = (String)ent.getKey();
                            if (!AuthenticationPreferencePage.this.userNameWorkText.getText().equals(userName)) continue;
                            AuthenticationPreferencePage.this.userNameMap.remove(userName);
                            break;
                        }
                        AuthenticationPreferencePage.this.showXMLSocketProp();
                    } else {
                        MessageDialog.openError((Shell)AuthenticationPreferencePage.this.getShell(), (String)"Error", (String)("No Exit Engine Address = " + AuthenticationPreferencePage.this.userNameWorkText.getText()));
                        return;
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
    }

    private void initShowXMLSocketProp() {
        this.userNameSelectList.removeAll();
        String userName = "";
        String password = "";
        this.userNameMap.clear();
        for (Map.Entry ent : this.userNamePreferenceMap.entrySet()) {
            userName = (String)ent.getKey();
            password = (String)this.userNamePreferenceMap.get(userName);
            this.userNameSelectList.add(userName);
            this.userNameMap.put(userName, password);
        }
        this.userNameWorkText.setText(userName);
        this.passwordWorkText.setText(password);
    }

    private void showXMLSocketProp() {
        this.userNameSelectList.removeAll();
        String userName = "";
        String password = "";
        for (Map.Entry ent : this.userNameMap.entrySet()) {
            userName = (String)ent.getKey();
            password = (String)this.userNameMap.get(userName);
            this.userNameSelectList.add(userName);
        }
        this.userNameWorkText.setText(userName);
        this.passwordWorkText.setText(password);
    }

    protected void performDefaults() {
        this.initShowXMLSocketProp();
    }

    public boolean performOk() {
        this.saveAuthXMLInfo();
        return super.performOk();
    }

    private void saveAuthXMLInfo() {
        Document dom = AuthenticationConfig.getInstance().getAuthInfo().updateDocument(this.userNameMap);
        BufferedWriter bufWriter = AuthenticationConfig.getInstance().getAuthInfo().getResourceFileWriter();
        this.outputXMLFile(bufWriter, dom);
        if (bufWriter != null) {
            try {
                bufWriter.close();
            }
            catch (IOException e) {
                logger.warning("Abort close BufferedWriter : " + e.getMessage());
                e.printStackTrace();
            }
        }
        AuthenticationConfig.getInstance().updateAuthInfo();
    }
}

