/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.model.action;

import java.net.URL;
import java.util.logging.Logger;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class ActionBuilderNetworkCamera
extends Action {
    private static Logger logger;
    private IEditorPart editorNodeConfigView;
    private IAction networkCameraAction = new ActionNetworkCamera();
    private IAction networkCameraActionSocket = new ActionNetworkCameraSocket();
    private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();

    public ActionBuilderNetworkCamera() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    }

    public IAction getActionNetworkCamera() {
        return this.networkCameraAction;
    }

    public IAction getActionNetworkCameraSocket() {
        return this.networkCameraActionSocket;
    }

    private abstract class AbstractNetworkCameraAction
    extends Action {
        private AbstractNetworkCameraAction() {
        }

        public final void run() {
            this.doTask();
        }

        protected abstract void doTask();
    }

    public class ActionNetworkCamera
    extends AbstractNetworkCameraAction {
        protected NodeInformation nodeInfo;

        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL((URL)ActionBuilderNetworkCamera.this.bundle.getEntry("icons/file_obj.gif"));
        }

        public String getText() {
            return "Network Camera Node";
        }

        public String getToolTipText() {
            return "Network Camera Node";
        }

        protected void doTask() {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (ActionBuilderNetworkCamera.this.editorNodeConfigView != null) {
                activePage.closeEditor(ActionBuilderNetworkCamera.this.editorNodeConfigView, false);
                ActionBuilderNetworkCamera.this.editorNodeConfigView = null;
            }
            String nodeName = String.valueOf(this.nodeInfo.getNodename()) + "(" + this.nodeInfo.getIpaddress() + ")";
            try {
                activePage.openEditor((IEditorInput)new EditorInputNodeView(String.valueOf(nodeName) + " Camera Config", this.nodeInfo, false), "netwatcher.networkcamera.gui.editor.EditorNetworkCameraConfigView");
                activePage.openEditor((IEditorInput)new EditorInputNodeView(String.valueOf(nodeName) + " Camera View", this.nodeInfo, false), "netwatcher.networkcamera.gui.editor.EditorNetworkCameraView");
            }
            catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }

        public void setNodeInfo(NodeInformation nodeInfo) {
            this.nodeInfo = nodeInfo;
        }
    }

    public class ActionNetworkCameraSocket
    extends ActionNetworkCamera {
        protected void doTask() {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (ActionBuilderNetworkCamera.this.editorNodeConfigView != null) {
                activePage.closeEditor(ActionBuilderNetworkCamera.this.editorNodeConfigView, false);
                ActionBuilderNetworkCamera.this.editorNodeConfigView = null;
            }
            String nodeName = String.valueOf(this.nodeInfo.getNodename()) + "(" + this.nodeInfo.getIpaddress() + ")";
            try {
                activePage.openEditor((IEditorInput)new EditorInputNodeView(String.valueOf(nodeName) + " Camera Config", this.nodeInfo, true), "netwatcher.networkcamera.gui.editor.EditorNetworkCameraConfigView");
                activePage.openEditor((IEditorInput)new EditorInputNodeView(String.valueOf(nodeName) + " Camera View", this.nodeInfo, true), "netwatcher.networkcamera.gui.editor.EditorNetworkCameraView");
            }
            catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

