/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.command.model;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.engine.command.control.TemplateCommandImpl;
import netjfwatcher.engine.nodecontrol.NodeEdit;
import netjfwatcher.engine.resource.SnmpV3ManagerConfig;
import netjfwatcher.engine.socket.CommandInfo;
import netjfwatcher.engine.socket.info.NodeInformation;

public class CommandNodeEdit
extends TemplateCommandImpl {
    private static Logger logger;

    public void doInvoke(CommandInfo com, ObjectInputStream ois, ObjectOutputStream oos) {
        logger = Logger.getLogger(this.getClass().getName());
        String responseCode = "ACK";
        NodeEdit nodeedit = NodeEdit.getInstance();
        if (com.getNodeInformationList() != null) {
            ArrayList nodeInfoList = com.getNodeInformationList();
            int i = 0;
            while (i < nodeInfoList.size()) {
                NodeInformation nodeInfo = (NodeInformation)nodeInfoList.get(i);
                if (nodeInfo.getSnmpVersion().equals("SNMPV3") && SnmpV3ManagerConfig.getInstance().getResourceFileParse().getSnmpV3AgentInfo(nodeInfo.getIpaddress()) == null) {
                    responseCode = "Not found SNMP V3 Agent Address = " + nodeInfo.getIpaddress();
                    logger.warning(responseCode);
                    this.sendResponse(responseCode, ois, oos);
                } else {
                    try {
                        nodeedit.editNodeInfo(nodeInfo);
                    }
                    catch (DatabaseConnectionException e) {
                        logger.warning("DatabaseConnectionException : " + e.getMessage());
                        responseCode = "DatabaseConnectionException : " + e.getMessage();
                    }
                    catch (SQLException e) {
                        logger.warning("SQLException : " + e.getMessage());
                        responseCode = "SQLException : " + e.getMessage();
                    }
                }
                ++i;
            }
        } else {
            logger.info("Edit Node IP=" + com.getIpaddress());
            NodeInformation nodeInfo = com.getNodeInformation();
            if (nodeInfo.getSnmpVersion().equals("SNMPV3") && SnmpV3ManagerConfig.getInstance().getResourceFileParse().getSnmpV3AgentInfo(com.getIpaddress()) == null) {
                responseCode = "Not found SNMP V3 Agent Address = " + com.getIpaddress();
                logger.warning(responseCode);
                this.sendResponse(responseCode, ois, oos);
                return;
            }
            nodeedit.editNodeInfo(com);
        }
        this.sendResponse(responseCode, ois, oos);
    }
}

