/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.database.access.control;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import netjfwatcher.database.access.control.DatabaseAccess;

public final class DatabaseAccessPool {
    private static final int LIST_SIZE = 10;
    private static Logger logger;
    private final List<DatabaseAccess> databaseAccessQueueList = Collections.synchronizedList(new LinkedList());

    private DatabaseAccessPool() {
        logger = Logger.getLogger(this.getClass().getName());
        this.setDatabaseAccessQueueList();
    }

    public void setDatabaseAccessQueueList() {
        this.databaseAccessQueueList.clear();
        int i = 0;
        while (i < 10) {
            DatabaseAccess dataAccess = null;
            dataAccess = new DatabaseAccess();
            this.databaseAccessQueueList.add(this.databaseAccessQueueList.size(), dataAccess);
            ++i;
        }
    }

    public synchronized void releaseQueueDatabaseAccess(DatabaseAccess dataAccess) {
        this.databaseAccessQueueList.add(this.databaseAccessQueueList.size(), dataAccess);
    }

    public synchronized DatabaseAccess popQueueDatabaseAccess() {
        DatabaseAccess dataAccess = null;
        if (this.databaseAccessQueueList.size() > 0) {
            dataAccess = this.databaseAccessQueueList.get(0);
            this.databaseAccessQueueList.remove(0);
        } else {
            logger.warning("Empty DatabaseAccess");
        }
        return dataAccess;
    }

    public static DatabaseAccessPool getInstance() {
        return SingletonAboutMessage.DBPOOL;
    }

    /* synthetic */ DatabaseAccessPool(DatabaseAccessPool databaseAccessPool) {
        this();
    }

    private static class SingletonAboutMessage {
        static final DatabaseAccessPool DBPOOL = new DatabaseAccessPool(null);

        private SingletonAboutMessage() {
        }
    }
}

