/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpmanager;

import java.util.List;

import netjfwatcher.common.view.AbstractTableView;
import netjfwatcher.snmpmanager.trap.TrapReceiveMessageQueue;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;



/**
 * TrapMf[^i[L[IɊĎAe[u\NX
 * łB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class TrapTableTimerProcessor extends AbstractTableView
    implements Runnable {
    /** TrapML[Ď(ms) */
    public static final int TIMER = 1000;

    /* Display */
    private Display display;

    /* TrapMf[^\e[u */
    private Table trapTable;

    /**
     * TrapMf[^i[L[IɊĎAe[u\
     * NXCX^X𐶐܂B
     */
    public TrapTableTimerProcessor() {
        // nothing
    }

    /**
     * TrapML[IɊĎAL[Ƀf[^ꍇɂ
     * f[^PopTrapMe[uɕ\܂B
     *
     */
    public void run() {
    	if (trapTable != null && !trapTable.isDisposed() && trapTable.getVisible()) {
        /*
         * TrapML[Ď
         */
        List tarpInfoArrayList =
            (List) TrapReceiveMessageQueue.getInstance().popTrapData();

        while (tarpInfoArrayList != null) {
            String[] trapInfo = (String[]) tarpInfoArrayList.get(0);

            /*
             * TrapMe[usɃf[^ǉE\
             */
            TableItem tableItem = new TableItem(trapTable, SWT.NULL);
            tableItem.setData(trapInfo);
            tableItem.setText(trapInfo);

            /* TrapMe[uJ0Ń\[g\ */
            sortIntegerTable(trapTable, 0, true);
            tarpInfoArrayList =
                (List) TrapReceiveMessageQueue.getInstance().popTrapData();
        }
    	}
        // ^C}[p
        display.timerExec(TIMER, this);
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static TrapTableTimerProcessor getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * TimersDisplayZbg܂B
     *
     * @param display TimersDisplay
     */
    public void setDisplay(Display display) {
        this.display = display;
    }

    /**
     * XVe[uZbg܂B
     *
     * @param table XVe[u
     */
    public void setTable(Table table) {
        this.trapTable = table;
    }

	protected void setResizedTableColumnWidth() {
	}
    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final TrapTableTimerProcessor RESOURCE =
            new TrapTableTimerProcessor();
    }
}
