/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpagent;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.mibtree.AgentMibTree;
import netjfwatcher.snmp.mibtree.ManagerMibTree;
import netjfwatcher.snmp.mibtree.MibInfo;
import netjfwatcher.snmp.snmpobject.integer.SnmpCounter32;
import netjfwatcher.snmp.snmpobject.integer.SnmpCounter64;
import netjfwatcher.snmp.snmpobject.integer.SnmpGauge32;
import netjfwatcher.snmp.snmpobject.integer.SnmpInteger;
import netjfwatcher.snmp.snmpobject.integer.SnmpTimeTicks;
import netjfwatcher.snmp.snmpobject.integer.SnmpUInteger32;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;
import netjfwatcher.snmp.snmpobject.message.SnmpObjectIdentifier;
import netjfwatcher.snmp.snmpobject.octetstring.SnmpOctetString;
import netjfwatcher.snmpagent.model.AgentDataImport;
import netjfwatcher.snmpagent.model.AgentInstanceDataMap;
import netjfwatcher.snmpagent.model.AgentInstanceDataRefreshQueue;
import netjfwatcher.snmpagent.process.ThreadAgent;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;



/**
 * SNMP AgentɂAgentf[^̕ҏWsViewNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class AgentDataEditorView extends AbstractAgentView {
    /* eLXg */
    private static final int TEXT_WIDTH = 300;

    /* MO */
    private static Logger logger;

    /* Scroll CompositeTCY */
    private static final int[] SCROLL_COMPOSITE_SIZE = { 600, 300 };

	
    /* Table No. */
    private Text noText;

    /* OID Description */
    private Text oidDescriptionText;

    /* OID */
    private Text oidText;

    /* OID Value */
    private Text valueText;

    /* OID Type */
    private Text typeText;

    /* OID Access */
    private Text accessText;

    /* Agent MIBCX^XXV{^ */
    private Button agentDataUpdateButton;

    /* eLXg\BackGroundFi[ */
    private Color textBackColor;

    /**
     * PartControl𐶐܂B
     *
     * @param parent Composite
     */
    public void createPartControl(final Composite parent) {
        logger = Logger.getLogger(this.getClass().getName());

        textBackColor = whiteColor;

        /*
         * eCompositezueLayout
         * ieCompositec1ɔzuj
         */
        ScrolledComposite scrollComposite =
            new ScrolledComposite(parent, SWT.H_SCROLL | SWT.V_SCROLL);

        GridLayout layout = new GridLayout(1, false);
        scrollComposite.setLayout(layout);

        GridData gridData = null;

        /*
         * Snmp V3 AgentAhXAOIDȂǂzuComposite
         */
        GridLayout gridLayout = new GridLayout(3, false);
        Composite composite = new Composite(scrollComposite, SWT.NULL);

        composite.setLayout(gridLayout);
        composite.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
        gridData = new GridData();

        Label label = new Label(composite, SWT.NONE);
        label.setText("No.");
        label.setLayoutData(new GridData());
        noText = new Text(composite, SWT.BORDER | SWT.READ_ONLY);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        noText.setEnabled(false);
        noText.setBackground(textBackColor);
        noText.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite, SWT.NONE);
        label.setText("OID Description");
        label.setLayoutData(new GridData());
        oidDescriptionText = new Text(composite, SWT.BORDER | SWT.READ_ONLY);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        oidDescriptionText.setEnabled(false);
        oidDescriptionText.setBackground(textBackColor);
        oidDescriptionText.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        /* OID\ */
        label = new Label(composite, SWT.NONE);
        label.setText("OID");
        label.setLayoutData(new GridData());
        oidText = new Text(composite, SWT.BORDER | SWT.READ_ONLY);

        oidText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        oidText.setEnabled(false);
        oidText.setBackground(textBackColor);
        oidText.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite, SWT.NONE);
        label.setText("Value");
        label.setLayoutData(new GridData());
        valueText = new Text(composite, SWT.BORDER);

        valueText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;

        valueText.setBackground(textBackColor);
        valueText.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        /* MIB Type\ */
        label = new Label(composite, SWT.NONE);
        label.setText("Type");
        label.setLayoutData(new GridData());
        typeText = new Text(composite, SWT.BORDER | SWT.READ_ONLY);

        typeText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        typeText.setEnabled(false);
        typeText.setBackground(textBackColor);
        typeText.setLayoutData(gridData);

        /* Dummy column */
        label = new Label(composite, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        /* MIBANZX\ */
        label = new Label(composite, SWT.NONE);
        label.setText("Access");
        label.setLayoutData(new GridData());
        accessText = new Text(composite, SWT.BORDER | SWT.READ_ONLY);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        accessText.setEnabled(false);
        accessText.setBackground(textBackColor);
        accessText.setLayoutData(gridData);

        agentDataUpdateButton = new Button(composite, SWT.NONE);
        agentDataUpdateButton.setText("Edit");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;

        scrollComposite.setContent(composite);
        scrollComposite.setMinSize(
            SCROLL_COMPOSITE_SIZE[0], SCROLL_COMPOSITE_SIZE[1]);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);

        /*
         * Agentf[^XV{^Xi[
         */
        agentDataUpdateButton.addSelectionListener(
            new SelectionListener() {
                public void widgetSelected(SelectionEvent event) {
                    String oid = oidText.getText();
                    String value = valueText.getText();

                    String oidType = typeText.getText();

                    if (
                        oid.equals("") || value.equals("")
                            || oidType.equals("")) {
                        MessageBox alertMessageBox =
                            new MessageBox(
                                getSite().getShell(), SWT.YES
                                | SWT.ICON_WARNING);

                        alertMessageBox.setMessage("Illegal Agent data");
                        alertMessageBox.open();

                        return;
                    }

                    MibInfo miboid = null;

                    /* Agent̃CX^Xf[^XV */
                    miboid = editAgentInstanceData(oid, value, oidType);

                    if (miboid != null) {
                        /* Agente[u\XV */
                        AgentInstanceDataRefreshQueue.getInstance().pushQueue(
                            miboid);
                    }
                }

                /*
                 *  (non-Javadoc)
                 * @see org.eclipse.swt.events.
                 * SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.
                 * SelectionEvent)
                 */
                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });
    }

    /*
     * f[^Update{^ŌĂ΂AwOIDAValuey
     * OID TypeSNMP Object𐶐AAgent̃CX^X
     * XV܂B
     *
     * @param oid OID
     * @param value XVf[^
     * @param oidType MIB Type
     */
    private MibInfo editAgentInstanceData(
        final String oid, final String value, final String oidType) {
        /* Agnet MIB`ǂݍ */
        AgentMibTree mibtable = AgentMibTree.getInstance();
        HashMap agentOidHashMap = mibtable.getOidHashMap();
        MibInfo agentInstanceDataOidInfo = null;

        if (agentOidHashMap.containsKey(oid)) {
            /* wOID擾 */
            agentInstanceDataOidInfo = (MibInfo) agentOidHashMap.get(oid);

            if (agentInstanceDataOidInfo != null) {
                AbstractSnmpObject newSnmpObject =
                    createSnmpObject(oid, value, oidType);

                /* G[WFgf[^ێĂHashMap擾 */
                Map tableAgentMap =
                    AgentInstanceDataMap.getInstance().getAgentInstanceMap();
                MibInfo agentTableOidInfo = (MibInfo) tableAgentMap.get(oid);
                agentTableOidInfo.setValue(newSnmpObject.toString());
                AgentInstanceDataMap.getInstance().setAgentInstanceDataMap(
                    oid, agentTableOidInfo);

                /*
                 * AgentCX^Xf[^XV
                 */
                agentInstanceDataOidInfo.setAgentMibValue(newSnmpObject);
                agentOidHashMap.put(oid, agentInstanceDataOidInfo);
                mibtable.setOidHashMap(agentOidHashMap);
                mibtable = AgentMibTree.getInstance();
                agentOidHashMap = mibtable.getOidHashMap();
                agentInstanceDataOidInfo = (MibInfo) agentOidHashMap.get(oid);
            }
        }

        return agentInstanceDataOidInfo;
    }

    /*
     * wSNMP Object TypeSNMP Object𐶐ĕԂ܂B
     *
     * @param oid OID
     * @param value SNMP Objectl
     * @param oidType SNMP Object Type
     * @return newSnmpObject SNMP Object
     */
    private AbstractSnmpObject createSnmpObject(
        final String oid, final String value, final String oidType) {
        /*
             * SNMP ObjectwTypeŐ
             */
        AbstractSnmpObject newSnmpObject = null;

        if (oidType.equals(ManagerMibTree.INTEGER)) {
            newSnmpObject = new SnmpInteger();

            try {
                newSnmpObject.setValue(value);
            } catch (SnmpBadValueException e) {
                MessageBox alertMessageBox =
                    new MessageBox(
                        getSite().getShell(), SWT.YES | SWT.ICON_WARNING);

                alertMessageBox.setMessage("Illegal Value");
                alertMessageBox.open();
                valueText.setFocus();

                return null;
            }
        } else if (oidType.equals(ManagerMibTree.COUNTER32)) {
            newSnmpObject = new SnmpCounter32();

            try {
                newSnmpObject.setValue(value);
            } catch (SnmpBadValueException e) {
                MessageBox alertMessageBox =
                    new MessageBox(
                        getSite().getShell(), SWT.YES | SWT.ICON_WARNING);

                alertMessageBox.setMessage("Illegal Value");
                alertMessageBox.open();
                valueText.setFocus();

                return null;
            }
        } else if (oidType.equals(ManagerMibTree.COUNTER64)) {
            newSnmpObject = new SnmpCounter64();

            try {
                newSnmpObject.setValue(value);
            } catch (SnmpBadValueException e) {
                MessageBox alertMessageBox =
                    new MessageBox(
                        getSite().getShell(), SWT.YES | SWT.ICON_WARNING);

                alertMessageBox.setMessage("Illegal Value");
                alertMessageBox.open();
                valueText.setFocus();

                return null;
            }
        } else if (oidType.equals(ManagerMibTree.GAUGE32)) {
            newSnmpObject = new SnmpGauge32();

            try {
                newSnmpObject.setValue(value);
            } catch (SnmpBadValueException e) {
                MessageBox alertMessageBox =
                    new MessageBox(
                        getSite().getShell(), SWT.YES | SWT.ICON_WARNING);

                alertMessageBox.setMessage("Illegal Value");
                alertMessageBox.open();
                valueText.setFocus();

                return null;
            }
        } else if (oidType.equals(ManagerMibTree.UINTEGER32)) {
            newSnmpObject = new SnmpUInteger32();

            try {
                newSnmpObject.setValue(value);
            } catch (SnmpBadValueException e) {
                MessageBox alertMessageBox =
                    new MessageBox(
                        getSite().getShell(), SWT.YES | SWT.ICON_WARNING);

                alertMessageBox.setMessage("Illegal Value");
                alertMessageBox.open();
                valueText.setFocus();

                return null;
            }
        } else if (oidType.equals(ManagerMibTree.OBJECTID)) {
            newSnmpObject = new SnmpObjectIdentifier();

            try {
                newSnmpObject.setValue(value);
            } catch (SnmpBadValueException e) {
                MessageBox alertMessageBox =
                    new MessageBox(
                        getSite().getShell(), SWT.YES | SWT.ICON_WARNING);

                alertMessageBox.setMessage("Illegal Value");
                alertMessageBox.open();
                valueText.setFocus();

                return null;
            }
        } else if (oidType.equals(ManagerMibTree.TIMETICKS)) {
            newSnmpObject = new SnmpTimeTicks();

            try {
                newSnmpObject.setValue(value);

                if (oid.equals(AgentDataImport.SYSUPTIME_OID)) {
                    long sysupTimeMills =
                        System.currentTimeMillis()
                        - (Long.parseLong(value) * 1000);
                    ThreadAgent.getInstance().setStartEngineTime(
                        sysupTimeMills);
                }
            } catch (SnmpBadValueException e) {
                MessageBox alertMessageBox =
                    new MessageBox(
                        getSite().getShell(), SWT.YES | SWT.ICON_WARNING);

                alertMessageBox.setMessage("Illegal Value");
                alertMessageBox.open();
                valueText.setFocus();

                return null;
            }
        } else if (oidType.equals(ManagerMibTree.OCTETSTRING)) {
            newSnmpObject = new SnmpOctetString();

            try {
                newSnmpObject.setValue(value);
            } catch (SnmpBadValueException e) {
                MessageBox alertMessageBox =
                    new MessageBox(
                        getSite().getShell(), SWT.YES | SWT.ICON_WARNING);

                alertMessageBox.setMessage("Illegal Value");
                alertMessageBox.open();
                valueText.setFocus();

                return null;
            }
        }

        return newSnmpObject;
    }

    /**
     * OIDAccess\EҏWeLXgԂ܂B
     * Agent MIBCX^Xe[uViewł̑IXi[ɂA
     * Zbg邽߂ɌĂ΂܂B
     *
     * @return accessText Access Text
     */
    public Text getAccessText() {
        return accessText;
    }

    /**
     * OIDNo.\EҏWeLXgԂ܂B
     * Agent MIBCX^Xe[uViewł̑IXi[ɂA
     * Zbg邽߂ɌĂ΂܂B
     *
     * @return noText SNMP Instance No. text
     */
    public Text getNoText() {
        return noText;
    }

    /**
     * OIDDescription\EҏWeLXgԂ܂B
     * Agent MIBCX^Xe[uViewł̑IXi[ɂA
     * Zbg邽߂ɌĂ΂܂B
     *
     * @return oidDescriptionText OID Description Text
     */
    public Text getOidDescriptionText() {
        return oidDescriptionText;
    }

    /**
     * OID\EҏWeLXgԂ܂B
     * Agent MIBCX^Xe[uViewł̑IXi[ɂA
     * Zbg邽߂ɌĂ΂܂B
     *
     * @return oidText OID Text
     */
    public Text getOidText() {
        return oidText;
    }

    /**
     * OIDType\EҏWeLXgԂ܂B
     * Agent MIBCX^Xe[uViewł̑IXi[ɂA
     * Zbg邽߂ɌĂ΂܂B
     *
     * @return typeText SNMP Object Type Text
     */
    public Text getTypeText() {
        return typeText;
    }

    /**
     * OIDValue\EҏWeLXgԂ܂B
     * Agent MIBCX^Xe[uViewł̑IXi[ɂA
     * Zbg邽߂ɌĂ΂܂B
     *
     * @return valueText SNMP Object Value Text
     */
    public Text getValueText() {
        return valueText;
    }


}
