/*
 * Created on 2003/06/25
 *
 *
 * Copyright(c) 2003 Yoshimasa Matsumoto
 */
package netjfwatcher.snmp.mibtree;

import java.util.ArrayList;
import java.util.regex.Pattern;

import javax.swing.tree.DefaultMutableTreeNode;

import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;
import netjfwatcher.snmp.snmpobject.message.SnmpNull;



/**
 * MIB`t@Cǂݍŉ͂MIBOIDPʂɕێNXŁB
 * MIB Tree\pėpm[hɂĂێ܂B
 *
 * ܂A^G[WFg쎞̏ꍇ́AG[WFgf[^ƂāAOIDɑΉ
 * SNMPIuWFNglێ܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class MibInfo {
    /* c[f[^\̔ėpm[h */
    private DefaultMutableTreeNode treeNode;

    /* SNMP AgentCX^Xe[u\No. */
    private int instanceNo;

    /* OID */
    private String descrip;

    /* OID */
    private String oid;

    /* Parent Oid */
    private String parentOid;

    /* OID */
    private String nextMibOid;

    /* Syntax(SNMPIuWFNg^Cv) */
    private String syntax;

    /* Access(Read/Write) */
    private String access;

    /* OID̐[iC[j*/
    private int layer;

    /* OIDAgnetCX^Xł邩ۂ̃tO */
    private boolean isAgentInstance = false;

    /* ^G[WFgƂē삷ꍇOIDlŁAlNULL */
    private AbstractSnmpObject agentMibValue = new SnmpNull();

    /*
     * ^G[WFgƂē삷ꍇɁAGUIe[u܂
     * _CAOł̕ҏWOIDlSNMPObjectłȂString^
     * ƂĈ
     */
    private String value;

    /*
     * ^SNMPG[WFgƂē삷ꍇɁAOIDɑΉ
     * lێ郊Xg
     */
    private ArrayList agaentMibInfoList = new ArrayList();

    /**
     * OID̏ێCX^X𐶐܂B
     * Agent쎞ɐ܂B
     */
    public MibInfo() {
    }

    /**
     * OID̏ێCX^X𐶐܂B
     * MIB`͎OIDPʂɐ܂B
     *
     * @param item MIBItem
     * [0] OID
     * [1] OID
     * [2] SNMP Tag^
     * [3] ANZX(Read/write)^Cv
     */
    public MibInfo(String[] item) {
        descrip = item[0];
        oid = item[1];
        syntax = item[2];
        access = item[3];

        /* c[f[^\̔ėpm[hB
         * OIDm[hƂāAm[h̐eƎq̌ƕύXs߂̃Iy[VƁÃm[hɂ
         * \c[Iy[V񋟂܂B
         */
        treeNode = new DefaultMutableTreeNode(descrip + "(" + oid + ")");

        // oidɂĂ.isIhj؂ŕāAƂĎgp
        Pattern pattern;
        String[] oiditem;

        // OIDhbgŕ[iC[jƂĈ
        pattern = Pattern.compile("[.]");
        oiditem = pattern.split(item[1]);
        layer = oiditem.length;
    }

    /**
     * OID̐eOIDԂ܂B
     *
     * @return parentOid  OID̐eOID
     */
    public String getParentOid() {
        return parentOid;
    }

    /**
     * OID̐eOIDZbg܂B
     *
     * @param parentOid  OID̐eOID
     */
    public void setParentOid(String parentOid) {
        this.parentOid = parentOid;
    }

    /**
     * Access(Read/Write)Zbg܂B
     *
     * @return Access
     */
    public String getAccess() {
        return access;
    }

    /**
     * OID DescriptionԂ܂B
     *
     * @return descrip OID Description
     */
    public String getDescrip() {
        return descrip;
    }

    /**
     * OIDԂ܂B
     *
     * @return oid OID
     */
    public String getOid() {
        return oid;
    }

    /**
     * Syntax(SNMPIuWFNg^Cv)Ԃ܂B
     *
     * @return syntax Syntax(SNMPIuWFNg^Cv)
     */
    public String getSyntax() {
        return syntax;
    }

    /**
     * TreeNodeԂ܂B
     *
     * @return treeNode TreeNode
     */
    public DefaultMutableTreeNode getTreeNode() {
        return treeNode;
    }

    /**
     * OID̐[(C[)Ԃ܂B
     *
     * @return layer OID̐[(C[)
     */
    public int getLayer() {
        return layer;
    }

    /**
     * OID̎OIDԂ܂B
     *
     * @return nextMibOid OID̎OID
     */
    public String getNextMibOid() {
        return nextMibOid;
    }

    /**
     * OID̎OIDZbg܂B
     *
     * @param string OID̎OID
     */
    public void setNextMibOid(String string) {
        nextMibOid = string;
    }

    /**
     * Access(Read/Write)Zbg܂B
     *
     * @param string Access(Read/Write)
     */
    public void setAccess(String string) {
        access = string;
    }

    /**
     * OID DescriptionZbg܂B
     *
     * @param string OID Description
     */
    public void setDescrip(String string) {
        descrip = string;
    }

    /**
     * OIDZbg܂B
     *
     * @param string OID
     */
    public void setOid(String string) {
        oid = string;
    }

    /**
     * Syntax(SNMPIuWFNg^Cv)Zbg܂B
     *
     * @param string Syntax(SNMPIuWFNg^Cv)
     */
    public void setSyntax(String string) {
        syntax = string;
    }

    /**
     * CX^XNo.Ԃ܂B
     *
     * @return instanceNo CX^XNo.
     */
    public int getInstanceNo() {
        return instanceNo;
    }

    /**
     * CX^XNo.Zbg܂B
     *
     * @param i CX^XNo.
     */
    public void setInstanceNo(int i) {
        instanceNo = i;
    }

    /**
    * SNMP Agnet OIDCX^XZbg܂B
    *
    * @param object SNMP Agnet OIDCX^X
    */
    public void setAgentMibValue(AbstractSnmpObject object) {
        agentMibValue = object;
    }

    /**
    * SNMP Agnet OIDCX^XListԂ܂B
    *
    * @return agaentMibInfoList SNMP Agnet OIDCX^XList
    */
    public ArrayList getAgaentMibInfoList() {
        return agaentMibInfoList;
    }

    /**
     * SNMP Agent OIDCX^XԂ܂B
     *
     * @return agentMibValue  SNMP Agent OIDCX^X
     */
    public AbstractSnmpObject getAgentMibValue() {
        return agentMibValue;
    }

    /**
     * ^AgentƂē삷ꍇGUIɕ\lԂ܂B
     *
     * @return value * ^AgentƂē삷ꍇGUIɕ\l
     */
    public String getValue() {
        return value;
    }

    /**
     * ^AgentƂē삷ꍇGUIɕ\lZbg܂B
     *
     * @param value value ^AgentƂē삷ꍇGUIɕ\l
     */
    public void setValue(String value) {
        this.value = value;
    }

    /**
     * OIDAgnetCX^Xł邩ۂ̃tOԂ܂B
     *
     * @return isAgentInstance OIDAgnetCX^Xł邩ۂ̃tO
     */
    public boolean isAgentInstance() {
        return isAgentInstance;
    }

    /**
     * OIDAgnetCX^Xł邩ۂ̃tOZbg܂B
     *
     * @param isAgentInstance OIDAgnetCX^Xł邩ۂ̃tO
     */
    public void setAgentInstance(boolean isAgentInstance) {
        this.isAgentInstance = isAgentInstance;
    }
}
