/*
 * Created on 2006/10/22
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.preferance;

import java.util.logging.Logger;

import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.socket.info.ResourceInfo;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

/**
 * o^m[hɊւݒvtFXy[WNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class UnregistrationNodePreference extends AbstractEnginePreferancePage
		implements IWorkbenchPreferencePage {

	public static final String VALID = "valid";

	public static final String IGNORE = "ignore";

	/* MO */
	private static Logger logger;

	/* \[X */
	private ResourceInfo resourceInfo;

	/* Mail bZ[WFilter `FbNBox */
	private Button unregistrationNodeAlarmCheckButton;

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.preference.PreferencePage#init(IWorkbench)
	 */
	public void init(IWorkbench workbench) {
		logger = Logger.getLogger(this.getClass().getName());

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.preference.PreferencePage#createContents(Composite)
	 */
	protected Control createContents(Composite parent) {

		resourceInfo = SystemResourceConfig.getInstance()
				.getResourceFileParse().getResourceInfo();

		/*
		 * eCompositezueLayout ieCompositec1ɔzuj
		 */
		GridLayout layout = new GridLayout(1, false);
		parent.setLayout(layout);

		GridData gridData = null;


		GridLayout gridLayout = new GridLayout(2, false);
		Composite composite = new Composite(parent, SWT.NULL);

		composite.setLayout(gridLayout);
		composite.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
		gridData = new GridData();

		unregistrationNodeAlarmCheckButton = new Button(composite, SWT.CHECK);
		unregistrationNodeAlarmCheckButton
				.setText("Effective Unregistration Node Alarm.");

		unregistrationNodeAlarmCheckButton
				.addSelectionListener(new SelectionListener() {
					public void widgetDefaultSelected(SelectionEvent event) {
					}

					public void widgetSelected(SelectionEvent event) {
						Button bChk = (Button) event.widget;

						if (bChk.getSelection()) {
							resourceInfo.setUnregistrationNodeAlarm(VALID);
						} else {

							resourceInfo.setUnregistrationNodeAlarm(IGNORE);
						}
					}
				});

		setUnregistrationNodeAlarmCheckButton();
		return composite;
	}

	private void setUnregistrationNodeAlarmCheckButton() {

		if (resourceInfo.getUnregistrationNodeAlarm().equals(IGNORE)) {
			unregistrationNodeAlarmCheckButton.setSelection(false);
		} else {
			unregistrationNodeAlarmCheckButton.setSelection(true);
		}

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.preference.PreferencePage#performDefaults()
	 */
	protected void performDefaults() {
		resourceInfo = SystemResourceConfig.getInstance()
				.getResourceFileParse().getResourceInfo();

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.preference.PreferencePage#performOk()
	 */
	public boolean performOk() {

		/* \`XMLt@CXV */
		saveResourceXMLInfo(resourceInfo);

		return super.performOk();
	}
}
