/*
 * Created on 2005/04/14
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.model.action;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.filepreference.FilePreference;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.osgi.framework.Bundle;



/**
 * m[hIcon摜t@CAxTEht@C`\[XXMLt@C
 * ǂݍŕێNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class MediaResource {
    /* Logging */
    private static Logger logger = null;

    /* 摜肷邽߂PluginResource bundle */
    private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();

    /* m[hIconXg */
    private HashMap<String, String> iconDataList = new HashMap<String, String>();

    /* TEht@CXg */
    private ArrayList<String> soundFileList = new ArrayList<String>();

    /**
     * m[hIcon摜t@CAxTEht@C`\[XXMLt@C
     * ǂݍŕێNXCX^X𐶐܂B
     *
     */
    private MediaResource() {
        logger = Logger.getLogger(this.getClass().getName());

        Document doc = this.getDocument();

        try {
            // rootvfo
            Element root = doc.getRootElement();

            List soundList = root.getChildren("Sound");
            List iconList = root.getChildren("Icon");

            Iterator iterator = soundList.iterator();

            while (iterator.hasNext()) {
                Element soundFileEl = (Element) iterator.next();
                soundFileList.add(
                    soundFileEl.getChild("sound_file").getAttributeValue(
                        "value"));
            }

            iterator = iconList.iterator();

            while (iterator.hasNext()) {
                Element iconLabelEl = (Element) iterator.next();

                /* iconLabelList.add(
                    iconLabelEl.getChild("Icon_Label").getAttributeValue(
                        "value"));
                iconDataList.add(
                    iconLabelEl.getChild("Icon_Data").getAttributeValue(
                        "value")); */
                iconDataList.put(
                    iconLabelEl.getChild("Icon_Label").getAttributeValue(
                        "value"),
                    iconLabelEl.getChild("Icon_Data").getAttributeValue(
                        "value"));
            }
        } catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    /**
     * m[hIconyуTEh`XMLt@CDocumentƂĕԂ܂B
     *
     * @return doc Document
     */
    private Document getDocument() {
        Document doc = null;

        try {
            URL url =
                 bundle.getEntry(FilePreference.MEDIA_RESOURCE_XML_FILE);

            if (url == null) {
                /* bZ[W\[Xt@CȂꍇMO̎ */
                logger.severe(
                    "Alert/Confirm Dialog Window Message XML file url : " + url);

                return doc;
            }

            // File file = new File("test_resource.xml");
            // System.out.println("file.getPath()" + file.getPath());
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build(url.openStream());
        } catch (JDOMException e) {
            e.printStackTrace();
        } catch (NullPointerException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }

        return doc;
    }

    /**
     * m[hIocnf[^Xg
     *
     * @return iconDataList m[hIconf[^Xg
     */
    public HashMap getIconDataList() {
        return iconDataList;
    }

    /**
     * m[hʂɑΉm[hIcon imagep̃t@CԂ܂B
     *
     * @param nodeKind m[h
     * @return m[hIcon Imaget@CpX
     */
    public String getNodeIconFullFileName(String nodeKind) {
        return (String) iconDataList.get(nodeKind);
    }

    /**
     * m[hʂɑΉ16 * 16pic̃m[hIcon imagep
     * t@CԂ܂B
     *
     * @param nodeKind m[h
     * @return m[hIcon 16 * 16pic Imaget@CpX
     */
    public String getNodeIcon16FileName(String nodeKind) {
        String nodeIconFullKindFile = (String) iconDataList.get(nodeKind);
        int nodeNamePosition = nodeIconFullKindFile.indexOf("/");
        String nodeKindName = nodeIconFullKindFile.substring(nodeNamePosition);
        String node16IconFileName =
            FilePreference.NODE16ICON_DIRECTRY + nodeKindName;

        return node16IconFileName;
    }

    /**
     * TEht@CXgԂ܂B
     *
     * @return soundFileList TEht@CXg
     */
    public ArrayList getSoundFileList() {
        return soundFileList;
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static MediaResource getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final MediaResource RESOURCE = new MediaResource();
    }
}
