/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.model.action;

import java.sql.SQLException;
import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.common.view.MenuPreference;
import netjfwatcher.database.access.model.hsqldb.HsqldbControl;
import netjfwatcher.database.access.model.hsqldb.HsqldbDatabaseManager;
import netjfwatcher.database.access.model.hsqldb.HsqldbException;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;


/**
 * f[^x[XɊւANVNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ActionBuilderDatabase {
    /* MO */
    private static Logger logger;

    /* f[^x[XDriverNANV */
    private IAction startDatabase = new ActionStartDatabase();

    /* HSQLDB ThreadNANV */
    private IAction startHSQLDB = new ActionStartHSQLDBThread();

    /* HSQLDB Thread~ANV */
    private IAction stopHSQLDB = new ActionStopHSQLDBThread();

    /* HSQLDB ManagerNANV */
    private IAction startHSQLDBManager = new ActionStartHSQLDBManager();

    /* HSQLDB Manager~ANV */
    private IAction stopHSQLDBManager = new ActionStopHSQLDBManager();

    /* 摜肷邽߂PluginResource bundle */
    private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();

    /**
     * f[^x[XɊւANVNXCX^X
     * 𐶐܂B
     */
    public ActionBuilderDatabase() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * f[^x[XDriverNANVԂ܂B
     *
     * @return startDatabase f[^x[XDriverNANV
     */
    public IAction getActionStartDatabase() {
        return startDatabase;
    }

    /**
     * HSQLDBNANVNXCX^XԂ܂B
     *
     * @return startHSQLDB  HSQLDBNANVNXCX^X
     */
    public IAction getActionStartHSQLDB() {
        return startHSQLDB;
    }

    /**
     * HSQLDB~ANVNXCX^XԂ܂B
     *
     * @return stopTrap HSQLDB~ANVNXCX^X
     */
    public IAction getActionStopHSQLDB() {
        return stopHSQLDB;
    }

    /**
     * HSQLDB}l[WNANVԂ܂B
     *
     * @return startHSQLDBManager HSQLDB}l[WNANV
     */
    public IAction getActionStartHSQLDBManager() {
        return startHSQLDBManager;
    }

    /**
     * HSQLDB}l[W~ANVԂ܂B
     *
     * @return stopHSQLDBManager HSQLDB}l[W~ANV
     */
    public IAction getActionStopHSQLDBManager() {
        return stopHSQLDBManager;
    }

    /**
     * f[^x[XɊւANV`钊ۃNXłB
     *
     *
     */
    private abstract class AbstractDatabaseAction extends Action {
        /**
         * ANV܂B
         */
        public final void run() {
            doTask();
        }

        /**
         * ANV^XNłB
         *
         */
        protected abstract void doTask();
    }

    /**
     * f[^x[X̏yDriverNsANVB
     */
    private final class ActionStartDatabase extends AbstractDatabaseAction {
        /**
         *f[^x[XDriverNANṼACRImageDescriptorԂ܂B
         *
         * @return f[^x[XDriverNANṼACRImageDescriptor
         */
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL(
                bundle.getEntry(MenuPreference.DATABASE_START_IMAGE_FILE));
        }

        /**
         * f[^x[XDriverNANṼeLXgԂ܂B
         *
         * @return Text
         */
        public String getText() {
            return MenuPreference.DATABASE_START;
        }

        /**
         * f[^x[XDriverNANVToolTipTextԂ܂B
         *
         * @return ToolTipText
         *
         */
        public String getToolTipText() {
            return MenuPreference.DATABASE_START_TOOL_TIP;
        }

        /**
         * f[^x[XDriver̋Ns܂B
         *
         */
        protected void doTask() {
            Shell shell = new Shell();

            if (
                MessageDialog.openQuestion(
                        shell, "Confirm", "Initialize Database")) {
                DatabaseControl.getInstance().startDatabase(true);
            } else {
                DatabaseControl.getInstance().startDatabase(false);
            }

            shell.dispose();
        }
    }

    /**
     * HSQLDBT[őNsANVB
     */
    private final class ActionStartHSQLDBThread extends AbstractDatabaseAction {
        /**
         * HSQLDBT[oNANṼACRImageDescriptorԂ܂B
         *
         * @return HSQLDBT[őNANṼACRImageDescriptor
         */
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL(
                bundle.getEntry(MenuPreference.HSQLDB_START_IMAGE_FILE));
        }

        /**
         * HSQLDBT[oNANṼeLXgԂ܂B
         *
         * @return Text
         */
        public String getText() {
            return MenuPreference.HSQLDB_START;
        }

        /**
         * HSQLDBT[oNANVToolTipTextԂ܂B
         *
         * @return ToolTipText
         */
        public String getToolTipText() {
            return MenuPreference.HSQLDB_START_TOOL_TIP;
        }

        /**
         * HSQLDBT[őNs܂B
         *
         */
        protected void doTask() {
            try {
                HsqldbControl.getInstance().startHsqlDB();
            } catch (HsqldbException e) {
                Shell shell = new Shell();
                MessageDialog.openInformation(
                    shell, "Hsqldb Status", e.getMessage());
                shell.dispose();
            }
        }
    }

    /**
     * HSQLDBT[o~ANVłBB
     */
    private final class ActionStopHSQLDBThread extends AbstractDatabaseAction {
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL(
                bundle.getEntry(MenuPreference.HSQLDB_STOP_IMAGE_FILE));
        }

        /**
         * HSQLDBT[o~ANṼj[LqԂ܂B
         *
         * @return Text
         */
        public String getText() {
            return MenuPreference.HSQLDB_STOP;
        }

        /**
         * TrapM~ANVToolTipText̕Ԃ܂B
         *
         * @return ToolTipText
         */
        public String getToolTipText() {
            return MenuPreference.HSQLDB_STOP_TOOL_TIP;
        }

        /**
         * HSQLDBT[o~܂B
         *
         */
        protected void doTask() {
            try {
                HsqldbControl.getInstance().stopHsqlDB();
            } catch (ClassNotFoundException e) {
                e.printStackTrace();

                Shell shell = new Shell();
                MessageDialog.openError(shell, "Error", e.getMessage());
                shell.dispose();
            } catch (SQLException e) {
                e.printStackTrace();

                Shell shell = new Shell();
                MessageDialog.openError(shell, "Error", e.getMessage());
                shell.dispose();
            }
        }
    }

    /**
     * HSQLDB}l[WNANVNXłB
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    private final class ActionStartHSQLDBManager extends AbstractDatabaseAction {
        /**
         * HSQLDB}l[WNANVpImageDescriptorԂ܂B
         *
         * @return HSQLDB}l[WNANVpImageDescriptor
         */
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL(
                bundle.getEntry(MenuPreference.HSQLDB_MANAGER_START_IMAGE_FILE));
        }

        /**
         * TextԂ܂B
         *
         * @return Text
         */
        public String getText() {
            return MenuPreference.HSQLDB_MANAGER_START;
        }

        /**
         * ToolTipTextԂ܂B
         *
         * @return ToolTipText
         */
        public String getToolTipText() {
            return MenuPreference.HSQLDB_MANAGER_START_TOOL_TIP;
        }

        /**
         * HSQLDB}l[WN܂B
         */
        protected void doTask() {
            HsqldbDatabaseManager manager = new HsqldbDatabaseManager();
            manager.run(this);
        }
    }

    /**
     * HSQLDB}l[W~ANVNXłB
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    private final class ActionStopHSQLDBManager extends AbstractDatabaseAction {
        /**
         * HSQLDB Manager~ANVImageDescriptor
         *
         *
         * @return  HSQLDB Manager~ANVImageDescriptor
         */
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL(
                bundle.getEntry(MenuPreference.HSQLDB_MANAGER_STOP_IMAGE_FILE));
        }

        /**
         * HSQLDB}l[W~ANṼeLXgԂ܂B
         *
         * @return HSQLDB}l[W~ANṼeLXg
         */
        public String getText() {
            return MenuPreference.HSQLDB_MANAGER_STOP;
        }

        /**
         * HSQLDB}l[W~ANVToolTipԂ܂B
         *
         * @return HSQLDB}l[W~ANVToolTip
         */
        public String getToolTipText() {
            return MenuPreference.HSQLDB_MANAGER_STOP_TOOL_TIP;
        }

        /**
         * HSQLDB}l[W~܂B
         */
        protected void doTask() {
            try {
                HsqldbDatabaseManager.createEmptyHsqlDatabase();
            } catch (ClassNotFoundException e) {
                e.printStackTrace();

                Shell shell = new Shell();
                MessageDialog.openError(shell, "Error", e.getMessage());
                shell.dispose();
            } catch (SQLException e) {
                e.printStackTrace();

                Shell shell = new Shell();
                MessageDialog.openError(shell, "Error", e.getMessage());
                shell.dispose();
            }
        }
    }
}
