/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmpagent.process;

import java.security.GeneralSecurityException;
import java.util.logging.Logger;
import netjfwatcher.engine.resource.SnmpV3AgentConfig;
import netjfwatcher.engine.resource.SnmpV3AgentConfigInfo;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.messageformat.SnmpVariablePair;
import netjfwatcher.snmp.snmpobject.integer.SnmpCounter32;
import netjfwatcher.snmp.snmpobject.integer.SnmpInteger;
import netjfwatcher.snmp.snmpobject.message.SnmpObjectIdentifier;
import netjfwatcher.snmp.snmpobject.message.SnmpPDU;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;
import netjfwatcher.snmp.snmpobject.octetstring.SnmpOctetString;
import netjfwatcher.snmp.snmpv3.SnmpEngineID;
import netjfwatcher.snmp.snmpv3.UsmSecuritySubsystem;
import netjfwatcher.snmp.snmpv3.UsmUserAgentManager;
import netjfwatcher.snmp.snmpv3.UsmUserEntry;
import netjfwatcher.snmpagent.process.ThreadAgent;

public class AgentV3DiscoverySequence {
    private static Logger logger;

    public AgentV3DiscoverySequence() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public SnmpSequence createDiscoverySnmpEngineIDMessage(int requestID, String msgIDString) throws SnmpBadValueException {
        int snmpVersion = 3;
        int securityModel = 3;
        int msgID = Integer.parseInt(msgIDString);
        SnmpV3AgentConfigInfo snmpV3AgentConfigInfo = SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo().getSnmpV3AgentResourceInfo();
        String snmpV3AgentSnmpEngineID = snmpV3AgentConfigInfo.getSnmpEngineID();
        SnmpEngineID snmpEngineID = new SnmpEngineID(snmpV3AgentSnmpEngineID);
        int snmpEngineBoots = 0;
        String contextName = "";
        SnmpSequence resSendSNMPSequence = new SnmpSequence();
        SnmpSequence msgSecurityParameters = null;
        try {
            resSendSNMPSequence.addSNMPObject(new SnmpInteger(snmpVersion));
            SnmpSequence msgGlobalData = new SnmpSequence();
            msgGlobalData.addSNMPObject(new SnmpInteger(msgID));
            msgGlobalData.addSNMPObject(new SnmpInteger(8192L));
            byte msgFlag = 4;
            msgGlobalData.addSNMPObject(new SnmpOctetString(new byte[]{msgFlag}));
            msgGlobalData.addSNMPObject(new SnmpInteger(securityModel));
            resSendSNMPSequence.addSNMPObject(msgGlobalData);
            msgSecurityParameters = new SnmpSequence();
            msgSecurityParameters.addSNMPObject(new SnmpOctetString(snmpEngineID.getId()));
            msgSecurityParameters.addSNMPObject(new SnmpInteger(snmpEngineBoots));
            int snmpEngineTime = 0;
            msgSecurityParameters.addSNMPObject(new SnmpInteger(snmpEngineTime));
            msgSecurityParameters.addSNMPObject(new SnmpOctetString());
            msgSecurityParameters.addSNMPObject(new SnmpOctetString(new byte[0]));
            msgSecurityParameters.addSNMPObject(new SnmpOctetString(new byte[0]));
            resSendSNMPSequence.addSNMPObject(new SnmpOctetString(msgSecurityParameters.getBEREncoding()));
            SnmpSequence msgData = new SnmpSequence();
            msgData.addSNMPObject(new SnmpOctetString(snmpEngineID.getId()));
            msgData.addSNMPObject(new SnmpOctetString(contextName));
            SnmpPDU sendPDU = null;
            try {
                sendPDU = this.createDiscoverySnmpEngineIDReportPDU(requestID);
            }
            catch (SnmpBadValueException e) {
                logger.warning("Abort create response PDU for discovery EngineID");
                e.printStackTrace();
                throw e;
            }
            msgData.addSNMPObject(sendPDU);
            resSendSNMPSequence.addSNMPObject(msgData);
        }
        catch (SnmpBadValueException e1) {
            logger.warning("Abort create response message for discovery EngineID");
            e1.printStackTrace();
            throw e1;
        }
        return resSendSNMPSequence;
    }

    public SnmpSequence createDiscoveryBootsAndTimeMessage(int requestID, String engineID, String msgIDString) throws GeneralSecurityException, SnmpBadValueException {
        SnmpSequence resSendSNMPSequence;
        block15: {
            logger.info("Discovery snmpEngineBoots and snmpEngineTime");
            int snmpVersion = 3;
            int securityModel = 3;
            int msgID = Integer.parseInt(msgIDString);
            SnmpEngineID snmpEngineID = new SnmpEngineID(engineID);
            SnmpV3AgentConfigInfo snmpV3AgentConfigInfo = SnmpV3AgentConfig.getInstance().getSNMPV3AgentConfigFileInfo().getSnmpV3AgentResourceInfo();
            String userName = snmpV3AgentConfigInfo.getUserName();
            int snmpEngineBoots = 0;
            snmpEngineBoots = Integer.parseInt(snmpV3AgentConfigInfo.getSnmpEngineBoots());
            long agentStartTime = (System.currentTimeMillis() - ThreadAgent.getInstance().getStartEngineTime()) / 1000L;
            logger.info("Discovry snmpEngineID : " + engineID);
            logger.info("Discovry snmpEngineBoots : " + snmpEngineBoots);
            logger.info("Discovry agentStartTime : " + agentStartTime);
            resSendSNMPSequence = new SnmpSequence();
            SnmpSequence msgSecurityParameters = null;
            UsmUserEntry usmUserEntry = null;
            logger.info("usmUserEntry snmpEngineID : " + snmpEngineID);
            logger.info("usmUserEntry userName : " + userName);
            usmUserEntry = UsmUserAgentManager.getInstance().getUsmUserEntry(snmpEngineID, userName);
            if (usmUserEntry == null) {
                logger.warning("Not user entry");
                logger.warning("snmpEngineID : " + snmpEngineID);
                logger.warning("userName : " + userName);
            }
            try {
                resSendSNMPSequence.addSNMPObject(new SnmpInteger(snmpVersion));
                SnmpSequence msgGlobalData = new SnmpSequence();
                msgGlobalData.addSNMPObject(new SnmpInteger(msgID));
                msgGlobalData.addSNMPObject(new SnmpInteger(8192L));
                boolean authFlag = false;
                String authPriv = snmpV3AgentConfigInfo.getAuthPriv();
                logger.info("authPriv : " + authPriv);
                if (authPriv.equals("AUTH")) {
                    authFlag = true;
                } else if (authPriv.equals("PRIV")) {
                    authFlag = true;
                } else if (authPriv.equals("NOAUTH")) {
                    authFlag = false;
                }
                byte msgFlag = 4;
                if (authFlag) {
                    msgFlag = 1;
                }
                msgGlobalData.addSNMPObject(new SnmpOctetString(new byte[]{msgFlag}));
                msgGlobalData.addSNMPObject(new SnmpInteger(securityModel));
                resSendSNMPSequence.addSNMPObject(msgGlobalData);
                msgSecurityParameters = new SnmpSequence();
                msgSecurityParameters.addSNMPObject(new SnmpOctetString(snmpEngineID.getId()));
                msgSecurityParameters.addSNMPObject(new SnmpInteger(snmpEngineBoots));
                int snmpEngineTime = (int)((System.currentTimeMillis() - ThreadAgent.getInstance().getStartEngineTime()) / 1000L);
                msgSecurityParameters.addSNMPObject(new SnmpInteger(snmpEngineTime));
                msgSecurityParameters.addSNMPObject(new SnmpOctetString(userName));
                if (authFlag) {
                    msgSecurityParameters.addSNMPObject(new SnmpOctetString(new byte[12]));
                } else {
                    msgSecurityParameters.addSNMPObject(new SnmpOctetString(new byte[0]));
                }
                msgSecurityParameters.addSNMPObject(new SnmpOctetString(new byte[0]));
                resSendSNMPSequence.addSNMPObject(new SnmpOctetString(msgSecurityParameters.getBEREncoding()));
                SnmpSequence msgData = new SnmpSequence();
                msgData.addSNMPObject(new SnmpOctetString());
                msgData.addSNMPObject(new SnmpOctetString());
                SnmpPDU reportPDUDiscoveryEngineBootsAndTime = null;
                try {
                    reportPDUDiscoveryEngineBootsAndTime = this.creasteDiscoveryEngineBootsAndTimeReportPDU(requestID);
                }
                catch (SnmpBadValueException e) {
                    logger.warning("Abort create response PDU for discovery EngineBoots/EngineTime");
                    e.printStackTrace();
                    throw e;
                }
                msgData.addSNMPObject(reportPDUDiscoveryEngineBootsAndTime);
                resSendSNMPSequence.addSNMPObject(msgData);
                if (!authFlag) break block15;
                try {
                    SnmpOctetString msgAuthenticationParametersOctet = null;
                    msgAuthenticationParametersOctet = UsmSecuritySubsystem.getInstance().setAuth(resSendSNMPSequence, msgSecurityParameters, usmUserEntry.getUsmUserAuthKey());
                    msgSecurityParameters.addSNMPObject(msgAuthenticationParametersOctet, 4);
                }
                catch (GeneralSecurityException e2) {
                    logger.warning("GeneralSecurityException at create response PDU for discovery EngineBoots/EngineTime");
                    e2.printStackTrace();
                    throw e2;
                }
                resSendSNMPSequence.addSNMPObject(new SnmpOctetString(msgSecurityParameters.getBEREncoding()), 2);
            }
            catch (SnmpBadValueException e1) {
                logger.warning("Abort create response message for discovery EngineBoots/EngineTime");
                e1.printStackTrace();
                throw e1;
            }
        }
        return resSendSNMPSequence;
    }

    private SnmpPDU createDiscoverySnmpEngineIDReportPDU(int requestID) throws SnmpBadValueException {
        int errorStatus = 0;
        int errorIndex = 0;
        byte pduType = -88;
        SnmpPDU pdu = null;
        try {
            SnmpObjectIdentifier requestedObjectIdentifier = new SnmpObjectIdentifier("1.3.6.1.6.3.15.1.1.4.0");
            SnmpCounter32 newVar = new SnmpCounter32(3L);
            SnmpVariablePair nextPair = new SnmpVariablePair(requestedObjectIdentifier, newVar);
            SnmpSequence varList = new SnmpSequence();
            varList.addSNMPObject(nextPair);
            pdu = new SnmpPDU(pduType, requestID, errorStatus, errorIndex, varList);
        }
        catch (SnmpBadValueException e) {
            logger.warning("Abort create Discovery SnmpEngineID reportPDU : " + e.getMessage());
            e.printStackTrace();
            throw new SnmpBadValueException("Abort create Discovery SnmpEngineID reportPDU : " + e.getMessage());
        }
        return pdu;
    }

    private SnmpPDU creasteDiscoveryEngineBootsAndTimeReportPDU(int requestID) throws SnmpBadValueException {
        int errorStatus = 0;
        int errorIndex = 0;
        byte pduType = -88;
        SnmpPDU reportPdu = null;
        try {
            SnmpObjectIdentifier requestedObjectIdentifier = new SnmpObjectIdentifier("1.3.6.1.6.3.15.1.1.2.0");
            SnmpCounter32 newVar = new SnmpCounter32(1L);
            SnmpVariablePair nextPair = new SnmpVariablePair(requestedObjectIdentifier, newVar);
            SnmpSequence varList = new SnmpSequence();
            varList.addSNMPObject(nextPair);
            reportPdu = new SnmpPDU(pduType, requestID, errorStatus, errorIndex, varList);
        }
        catch (SnmpBadValueException e) {
            logger.warning("Abort create Discovery SnmpEngineBoots/Time reportPDU : " + e.getMessage());
            e.printStackTrace();
            throw new SnmpBadValueException("Abort create Discovery SnmpEngineBoots/Time reportPDU : " + e.getMessage());
        }
        return reportPdu;
    }
}

