/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.view.editorpart.alarm;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableAlarm;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

public class AlarmTableTimerProcessor
implements Runnable {
    public static final int TIMER = 5000;
    private static Logger logger = null;
    private static Color whiteColor = new Color(null, 255, 255, 255);
    private static Color alarmBackColor = new Color(null, 255, 153, 255);
    private Display display;
    private Text alarmCountText;

    public AlarmTableTimerProcessor() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public void setAlarmCountText(Text alarmCountText) {
        this.alarmCountText = alarmCountText;
    }

    public void run() {
        ArrayList alarmInfoList = this.getAlarmList();
        if (this.alarmCountText.isDisposed()) {
            return;
        }
        if (alarmInfoList != null && alarmInfoList.size() > 0) {
            long showCount = Long.parseLong(this.alarmCountText.getText());
            if ((long)alarmInfoList.size() > showCount) {
                this.alarmCountText.setBackground(alarmBackColor);
            } else {
                this.alarmCountText.setBackground(whiteColor);
            }
        } else {
            this.alarmCountText.setBackground(whiteColor);
        }
        this.display.timerExec(5000, (Runnable)this);
    }

    private ArrayList getAlarmList() {
        ArrayList alarmInfoList = null;
        DBTableAlarm alarmDBTable = DBTableAlarm.getInstance();
        try {
            alarmInfoList = alarmDBTable.findAllAlarm(0, "all", null, null);
        }
        catch (SQLException e) {
            logger.warning("Alarm List import error " + e.getMessage());
        }
        catch (DatabaseConnectionException e) {
            logger.warning("Alarm List import error " + e.getMessage());
        }
        return alarmInfoList;
    }

    public static AlarmTableTimerProcessor getInstance() {
        return SingletonResource.RESOURCE;
    }

    public void setDisplay(Display display) {
        this.display = display;
    }

    private static class SingletonResource {
        static final AlarmTableTimerProcessor RESOURCE = new AlarmTableTimerProcessor();

        private SingletonResource() {
        }
    }
}

