/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.view;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import netjfwatcher.common.view.CalendarComposite;
import netjfwatcher.engine.model.action.ActionBuilderDatabase;
import netjfwatcher.engine.model.action.ActionBuilderEditorsPartClose;
import netjfwatcher.engine.model.action.ActionBuilderEngine;
import netjfwatcher.engine.server.taskschedule.TaskScheduleControl;
import netjfwatcher.engine.socket.info.TaskScheduleInfo;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

public class EngineScheduleView
extends ViewPart {
    private static final int[] SCROLL_COMPOSITE_SIZE = new int[]{700, 400};
    private static final int BUTTON_WIDTH = 150;
    private static final int BUTTON_HEIGHT = 20;
    private static final int LIST_WIDTHHINT = 300;
    private static Logger logger;
    private static List taskScheduleSortList;
    private SubStatusLineManager statusLineManager;
    private Button refreshButton;
    private Button sortButton;
    private Button cancelButton;
    private Button setButton;
    private org.eclipse.swt.widgets.List scheduleList;
    private Text alarmStartYearText;
    private Text alarmStartMonthText;
    private Text alarmStartDateText;
    private Text alarmEndYearText;
    private Text alarmEndMonthText;
    private Text alarmEndDateText;
    private Combo startHourCombo;
    private Combo startMinuteCombo;
    private Combo endHourCombo;
    private Combo endMinuteCombo;
    private Date setStartDate;
    private Date setEndDate;
    private DateFormat dateformat;
    private boolean isSortDirection = true;
    private ActionBuilderEngine actionBuilderEngine = new ActionBuilderEngine();
    private ActionBuilderEditorsPartClose actionBuilderEditorPart = new ActionBuilderEditorsPartClose();
    private ActionBuilderDatabase actionBuilderDatabase = new ActionBuilderDatabase();

    static {
        taskScheduleSortList = Collections.synchronizedList(new LinkedList());
    }

    public EngineScheduleView() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    }

    public void createPartControl(Composite parent) {
        this.dateformat = new SimpleDateFormat("yyyy-MM-dd (EEE) HH:mm:ss");
        this.fillActionBars();
        this.setStatusLine();
        ScrolledComposite scrollComposite = new ScrolledComposite(parent, 768);
        GridLayout layout = new GridLayout(1, false);
        scrollComposite.setLayout((Layout)layout);
        GridData gridData = null;
        GridLayout gridLayout0 = new GridLayout(2, true);
        Composite baseComposite = new Composite((Composite)scrollComposite, 0);
        baseComposite.setLayout((Layout)gridLayout0);
        baseComposite.setLayoutData((Object)new GridData());
        GridLayout gridLayoutListComp = new GridLayout(1, false);
        Composite compositeList = new Composite(baseComposite, 0);
        compositeList.setLayout((Layout)gridLayoutListComp);
        compositeList.setLayoutData((Object)new GridData(34));
        GridLayout gridLayoutOperation = new GridLayout(1, false);
        Composite compositeOperation = new Composite(baseComposite, 0);
        compositeOperation.setLayout((Layout)gridLayoutOperation);
        compositeOperation.setLayoutData((Object)new GridData());
        GridLayout gridLayoutButtonComp = new GridLayout(1, false);
        Composite compositeButton = new Composite(compositeOperation, 0);
        compositeButton.setLayout((Layout)gridLayoutButtonComp);
        compositeButton.setLayoutData((Object)new GridData());
        GridLayout gridLayoutDateTextComp = new GridLayout(9, false);
        Composite compositeDateText = new Composite(compositeOperation, 0);
        compositeDateText.setLayout((Layout)gridLayoutDateTextComp);
        compositeDateText.setLayoutData((Object)new GridData());
        GridLayout gridLayoutCalendar = new GridLayout(1, false);
        Composite compositeCalendar = new Composite(compositeOperation, 0);
        compositeCalendar.setLayoutData((Object)new GridData(256));
        compositeCalendar.setLayout((Layout)gridLayoutCalendar);
        this.scheduleList = new org.eclipse.swt.widgets.List(compositeList, 2820);
        GridData data = new GridData(34);
        data.horizontalSpan = 1;
        data.verticalSpan = 10;
        data.widthHint = 300;
        data.heightHint = this.scheduleList.getItemHeight() * 20;
        this.scheduleList.setLayoutData((Object)data);
        this.refreshButton = new Button(compositeButton, 0);
        this.refreshButton.setText(" Refresh");
        this.refreshButton.setSize(150, 20);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.refreshButton.setLayoutData((Object)gridData);
        this.sortButton = new Button(compositeButton, 0);
        this.sortButton.setText(" Sort    ");
        this.sortButton.setSize(150, 20);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.sortButton.setLayoutData((Object)gridData);
        this.cancelButton = new Button(compositeButton, 0);
        this.cancelButton.setSize(150, 20);
        this.cancelButton.setText(" Cancel ");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.cancelButton.setLayoutData((Object)gridData);
        this.setButton = new Button(compositeButton, 0);
        this.setButton.setSize(150, 20);
        this.setButton.setText(" Set     ");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        this.setButton.setLayoutData((Object)gridData);
        this.alarmStartYearText = new Text(compositeDateText, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 40;
        this.alarmStartYearText.setLayoutData((Object)gridData);
        Label label = new Label(compositeDateText, 0);
        label.setText(" ");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.alarmStartMonthText = new Text(compositeDateText, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 20;
        this.alarmStartMonthText.setLayoutData((Object)gridData);
        label = new Label(compositeDateText, 0);
        label.setText("/");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.alarmStartDateText = new Text(compositeDateText, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 20;
        this.alarmStartDateText.setLayoutData((Object)gridData);
        label = new Label(compositeDateText, 0);
        label.setText(" ");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.startHourCombo = new Combo(compositeDateText, 8);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 20;
        this.startHourCombo.setLayoutData((Object)gridData);
        this.setHourCombo(this.startHourCombo);
        this.startHourCombo.select(0);
        label = new Label(compositeDateText, 0);
        label.setText(":");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.startMinuteCombo = new Combo(compositeDateText, 8);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 20;
        this.startMinuteCombo.setLayoutData((Object)gridData);
        this.setMinuteCombo(this.startMinuteCombo);
        this.startMinuteCombo.select(0);
        this.alarmEndYearText = new Text(compositeDateText, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 40;
        this.alarmEndYearText.setLayoutData((Object)gridData);
        label = new Label(compositeDateText, 0);
        label.setText(" ");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.alarmEndMonthText = new Text(compositeDateText, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 20;
        this.alarmEndMonthText.setLayoutData((Object)gridData);
        label = new Label(compositeDateText, 0);
        label.setText("/");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.alarmEndDateText = new Text(compositeDateText, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 20;
        this.alarmEndDateText.setLayoutData((Object)gridData);
        label = new Label(compositeDateText, 0);
        label.setText(" ");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.endHourCombo = new Combo(compositeDateText, 8);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 20;
        this.endHourCombo.setLayoutData((Object)gridData);
        this.setHourCombo(this.endHourCombo);
        this.endHourCombo.select(23);
        label = new Label(compositeDateText, 0);
        label.setText(":");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.endMinuteCombo = new Combo(compositeDateText, 8);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 20;
        this.endMinuteCombo.setLayoutData((Object)gridData);
        this.setMinuteCombo(this.endMinuteCombo);
        this.endMinuteCombo.select(59);
        CalendarComposite calendarComposite = new CalendarComposite();
        calendarComposite.setYearText(this.alarmStartYearText);
        calendarComposite.setMonthText(this.alarmStartMonthText);
        calendarComposite.setDateText(this.alarmStartDateText);
        calendarComposite.setEndYearText(this.alarmEndYearText);
        calendarComposite.setEndMonthText(this.alarmEndMonthText);
        calendarComposite.setEndDateText(this.alarmEndDateText);
        calendarComposite.createCalendarView(compositeCalendar);
        this.alarmStartYearText.setText(calendarComposite.getCalendarTable().getTodaysYY());
        this.alarmStartMonthText.setText(calendarComposite.getCalendarTable().getTodaysMM());
        this.alarmStartDateText.setText(calendarComposite.getCalendarTable().getTodaysDD());
        this.alarmEndYearText.setText(calendarComposite.getCalendarTable().getTodaysYY());
        this.alarmEndMonthText.setText(calendarComposite.getCalendarTable().getTodaysMM());
        this.alarmEndDateText.setText(calendarComposite.getCalendarTable().getTodaysDD());
        scrollComposite.setContent((Control)baseComposite);
        scrollComposite.setMinSize(SCROLL_COMPOSITE_SIZE[0], SCROLL_COMPOSITE_SIZE[1]);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);
        this.refreshButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                EngineScheduleView.logger = Logger.getLogger(this.getClass().getName());
                EngineScheduleView.this.refreshButton.setEnabled(false);
                EngineScheduleView.this.getTaskSchedule();
                EngineScheduleView.this.refreshButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.setButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                EngineScheduleView.this.setButton.setEnabled(false);
                EngineScheduleView.this.getSelectDate();
                if (!MessageDialog.openQuestion((Shell)EngineScheduleView.this.getSite().getShell(), (String)"Task Set Confirm", (String)("Set  " + EngineScheduleView.this.dateformat.format(EngineScheduleView.this.setStartDate) + " - " + EngineScheduleView.this.dateformat.format(EngineScheduleView.this.setEndDate) + " ?"))) {
                    EngineScheduleView.this.setButton.setEnabled(true);
                    return;
                }
                EngineScheduleView.this.setTaskSchedule();
                EngineScheduleView.this.getTaskSchedule();
                EngineScheduleView.this.setButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.cancelButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                TaskScheduleInfo taskInfo;
                EngineScheduleView.this.cancelButton.setEnabled(false);
                int selectListIndex = EngineScheduleView.this.scheduleList.getSelectionIndex();
                if (selectListIndex >= 0 && (taskInfo = (TaskScheduleInfo)taskScheduleSortList.get(selectListIndex)) != null) {
                    if (!MessageDialog.openQuestion((Shell)EngineScheduleView.this.getSite().getShell(), (String)"Task Cancel Confirm", (String)("Cancel  " + EngineScheduleView.this.dateformat.format(taskInfo.getTaskStartDate()) + " - " + EngineScheduleView.this.dateformat.format(taskInfo.getTaskEndDate()) + " ?"))) {
                        EngineScheduleView.this.cancelButton.setEnabled(true);
                        return;
                    }
                    taskInfo.setTaskID(Integer.toString(selectListIndex));
                    EngineScheduleView.this.cancelTaskSchedule(taskInfo);
                    EngineScheduleView.this.getTaskSchedule();
                }
                EngineScheduleView.this.cancelButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.sortButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                EngineScheduleView.this.sortButton.setEnabled(false);
                if (EngineScheduleView.this.isSortDirection) {
                    EngineScheduleView.this.isSortDirection = false;
                } else {
                    EngineScheduleView.this.isSortDirection = true;
                }
                EngineScheduleView.this.getTaskSchedule();
                EngineScheduleView.this.sortButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.getTaskSchedule();
    }

    private void setHourCombo(Combo combo) {
        int i = 0;
        while (i < 24) {
            String work = Integer.toString(i);
            if (work.length() == 1) {
                work = "0" + work;
            }
            combo.add(work);
            ++i;
        }
    }

    private void setMinuteCombo(Combo combo) {
        int i = 0;
        while (i < 60) {
            String work = Integer.toString(i);
            if (work.length() == 1) {
                work = "0" + work;
            }
            combo.add(work);
            ++i;
        }
    }

    private void getTaskSchedule() {
        this.scheduleList.removeAll();
        taskScheduleSortList.clear();
        Map taskSchduleList = TaskScheduleControl.getInstance().getTaskSchedule();
        int count = 0;
        for (String keyId : taskSchduleList.keySet()) {
            TaskScheduleInfo info = (TaskScheduleInfo)taskSchduleList.get(keyId);
            taskScheduleSortList.add(count, info);
            ++count;
        }
        Collections.sort(taskScheduleSortList, new Comparator(){

            public int compare(Object o1, Object o2) {
                Date startData = ((TaskScheduleInfo)o1).getTaskStartDate();
                Date startDate2 = ((TaskScheduleInfo)o2).getTaskStartDate();
                if (EngineScheduleView.this.isSortDirection) {
                    return startDate2.compareTo(startData);
                }
                return startData.compareTo(startDate2);
            }
        });
        int i = 0;
        while (i < taskScheduleSortList.size()) {
            TaskScheduleInfo info = (TaskScheduleInfo)taskScheduleSortList.get(i);
            this.scheduleList.add(String.valueOf(this.dateformat.format(info.getTaskStartDate())) + " - " + this.dateformat.format(info.getTaskEndDate()));
            ++i;
        }
    }

    private void setTaskSchedule() {
        this.getSelectDate();
        Map taskSchduleList = TaskScheduleControl.getInstance().getTaskSchedule();
        for (String keyId : taskSchduleList.keySet()) {
            TaskScheduleInfo info = (TaskScheduleInfo)taskSchduleList.get(keyId);
            if (!this.dateformat.format(this.setStartDate).equals(this.dateformat.format(info.getTaskStartDate()))) continue;
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)("Already Start Date " + this.dateformat.format(this.setStartDate) + "  !"));
            return;
        }
        if (this.setStartDate.getTime() >= this.setEndDate.getTime()) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)("Start " + this.dateformat.format(this.setStartDate) + " >= " + "End " + this.dateformat.format(this.setEndDate) + "  !"));
            return;
        }
        if (this.setStartDate.getTime() <= Calendar.getInstance().getTime().getTime()) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)("Start " + this.dateformat.format(this.setStartDate) + " <= " + "Now " + this.dateformat.format(this.setEndDate) + "  !"));
            return;
        }
        TaskScheduleControl.getInstance().setTaskSchedule(this.setStartDate, this.setEndDate);
    }

    private void getSelectDate() {
        int indexStartHH = this.startHourCombo.getSelectionIndex();
        int indexStartMin = this.startMinuteCombo.getSelectionIndex();
        int indexEndHH = this.endHourCombo.getSelectionIndex();
        int indexEndMin = this.endMinuteCombo.getSelectionIndex();
        int startYY = 0;
        try {
            startYY = Integer.parseInt(this.alarmStartYearText.getText());
        }
        catch (NumberFormatException numberFormatException) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)"Illegal Date  !");
            this.alarmStartYearText.setFocus();
            return;
        }
        int startMM = 0;
        try {
            startMM = Integer.parseInt(this.alarmStartMonthText.getText());
        }
        catch (NumberFormatException numberFormatException) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)"Illegal Date  !");
            this.alarmStartMonthText.setFocus();
            return;
        }
        int startDD = 0;
        try {
            startDD = Integer.parseInt(this.alarmStartDateText.getText());
        }
        catch (NumberFormatException numberFormatException) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)"Illegal Date  !");
            this.alarmStartDateText.setFocus();
            return;
        }
        int startHH = 0;
        try {
            startHH = Integer.parseInt(this.startHourCombo.getItem(indexStartHH));
        }
        catch (NumberFormatException numberFormatException) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)"Illegal Date  !");
            this.startHourCombo.setFocus();
            return;
        }
        int startMIN = 0;
        try {
            startMIN = Integer.parseInt(this.startMinuteCombo.getItem(indexStartMin));
        }
        catch (NumberFormatException numberFormatException) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)"Illegal Date  !");
            this.startMinuteCombo.setFocus();
            return;
        }
        int endYY = 0;
        try {
            endYY = Integer.parseInt(this.alarmEndYearText.getText());
        }
        catch (NumberFormatException numberFormatException) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)"Illegal Date  !");
            this.alarmEndYearText.setFocus();
            return;
        }
        int endMM = 0;
        try {
            endMM = Integer.parseInt(this.alarmEndMonthText.getText());
        }
        catch (NumberFormatException numberFormatException) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)"Illegal Date  !");
            this.alarmEndMonthText.setFocus();
            return;
        }
        int endDD = 0;
        try {
            endDD = Integer.parseInt(this.alarmEndDateText.getText());
        }
        catch (NumberFormatException numberFormatException) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)"Illegal Date  !");
            this.alarmEndDateText.setFocus();
            return;
        }
        int endHH = 0;
        try {
            endHH = Integer.parseInt(this.endHourCombo.getItem(indexEndHH));
        }
        catch (NumberFormatException numberFormatException) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)"Illegal Date  !");
            this.endHourCombo.setFocus();
            return;
        }
        int endMIN = 0;
        try {
            endMIN = Integer.parseInt(this.endMinuteCombo.getItem(indexEndMin));
        }
        catch (NumberFormatException numberFormatException) {
            MessageDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)"Illegal Date  !");
            this.endMinuteCombo.setFocus();
            return;
        }
        Calendar cal = Calendar.getInstance();
        cal.set(startYY, startMM - 1, startDD, startHH, startMIN, 0);
        this.setStartDate = cal.getTime();
        cal.set(endYY, endMM - 1, endDD, endHH, endMIN, 0);
        this.setEndDate = cal.getTime();
    }

    private void cancelTaskSchedule(TaskScheduleInfo taskInfo) {
        String taskId = Integer.toString(taskInfo.getId());
        logger.info("Cancel Task Id : " + taskId);
        if (taskInfo != null && taskInfo.getTaskTimer() != null) {
            taskInfo.setTaskID(taskId);
            TaskScheduleControl.getInstance().cancelTaskSchedule(taskInfo);
            taskScheduleSortList.remove(taskId);
        }
    }

    public void setFocus() {
    }

    protected void setStatusLine() {
        this.statusLineManager = (SubStatusLineManager)this.getViewSite().getActionBars().getStatusLineManager();
        this.statusLineManager.setVisible(false);
    }

    private ActionBuilderEngine getEngineActionBuilder() {
        return this.actionBuilderEngine;
    }

    private ActionBuilderDatabase getDatabaseActionBuilder() {
        return this.actionBuilderDatabase;
    }

    private void fillActionBars() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBar = actionBars.getToolBarManager();
        toolBar.add(this.getEngineActionBuilder().getActionStartEngine());
        toolBar.add(this.getEngineActionBuilder().getActionStopEngine());
        toolBar.add(this.actionBuilderEditorPart.actionCloseAllEditors());
        IMenuManager menu = actionBars.getMenuManager();
        menu.add(this.getDatabaseActionBuilder().getActionStartHSQLDB());
        menu.add(this.getDatabaseActionBuilder().getActionStopHSQLDB());
        menu.add((IContributionItem)new Separator());
        MenuManager databaseSubMenu = new MenuManager("HSQLDB Manager");
        menu.add((IContributionItem)databaseSubMenu);
        databaseSubMenu.add(this.getDatabaseActionBuilder().getActionStartHSQLDBManager());
        databaseSubMenu.add(this.getDatabaseActionBuilder().getActionStopHSQLDBManager());
        menu.add((IContributionItem)new Separator());
        menu.add(this.getDatabaseActionBuilder().getActionStartDatabase());
    }
}

