/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.snmpmanager.process;

import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import netjfwatcher.engine.alarm.AlarmMessageMake;
import netjfwatcher.engine.snmpmanager.process.ManagerDispatcher;
import netjfwatcher.engine.snmpmanager.process.MibValue;
import netjfwatcher.engine.snmpmanager.process.MibValueQueue;
import netjfwatcher.engine.snmpmanager.process.SnmpV3UsmStatisticsManager;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.messageformat.SnmpConfigurationException;
import netjfwatcher.snmp.messageformat.SnmpErrorStatusException;
import netjfwatcher.snmp.messageformat.SnmpMIBGetException;
import netjfwatcher.snmp.messageformat.SnmpSetException;
import netjfwatcher.snmp.messageformat.SnmpUnmuchRequestIDException;
import netjfwatcher.snmp.messageformat.SnmpUnmuchRequestMsgIDException;
import netjfwatcher.snmp.messageformat.SnmpVarBindList;
import netjfwatcher.snmp.mibtree.ManagerMibTree;
import netjfwatcher.snmp.mibtree.MibInfo;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;
import netjfwatcher.snmp.snmpobject.message.SnmpObjectIdentifier;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;
import netjfwatcher.snmp.snmpv3.SnmpV3AuthAbortException;
import netjfwatcher.snmp.snmpv3.SnmpV3ConfigurationException;
import netjfwatcher.snmp.snmpv3.SnmpV3DecryptAbortException;

public class MibGetNextInfo {
    private static Logger logger = null;
    public static final int MIB_ARRAY = 5;
    public static final int MIB_DESCRIPTION_POS = 0;
    public static final int MIB_OID_POS = 1;
    public static final int MIB_VALUE_POS = 2;
    public static final int MIB_TYPE_POS = 3;
    public static final int MIB_ACCESS_POS = 4;
    private String targetIP;
    private ManagerDispatcher dispacher;
    private int version;
    private HashMap oidTreeMap = ManagerMibTree.getInstance().getOidHashMap();

    protected MibGetNextInfo() throws SocketException {
        logger = Logger.getLogger(this.getClass().getName());
        this.dispacher = new ManagerDispatcher();
    }

    public void setMibGetNext(String targetIPAddress, int version, String community) throws UnknownHostException {
        this.targetIP = targetIPAddress;
        this.version = version;
        this.dispacher.setManagerDispatcher(targetIPAddress, community, version);
    }

    public String getMibValueString(String requestOid) throws SnmpUnmuchRequestIDException, SnmpUnmuchRequestMsgIDException, GeneralSecurityException, SnmpV3DecryptAbortException, SnmpV3AuthAbortException, SnmpErrorStatusException, SnmpMIBGetException, SnmpSetException, SnmpConfigurationException, SnmpV3ConfigurationException, SnmpBadValueException, IOException {
        String responseSnmpValueString = "Abort mib get";
        SnmpVarBindList newVars = this.dispacher.dispathGetMessage(this.version, (byte)-95, requestOid);
        if (newVars != null) {
            String reportOID;
            SnmpSequence pair = (SnmpSequence)newVars.getSNMPObjectAt(0);
            SnmpObjectIdentifier snmpOID = (SnmpObjectIdentifier)pair.getSNMPObjectAt(0);
            AbstractSnmpObject snmpValue = pair.getSNMPObjectAt(1);
            responseSnmpValueString = snmpValue.toString();
            if (this.version == 3 && !(reportOID = this.checkReportOID(snmpOID.toString(), responseSnmpValueString)).equals("")) {
                AlarmMessageMake message = AlarmMessageMake.getInstance();
                message.setErrorSNMPV3ReportOID(this.targetIP, snmpOID.toString(), reportOID, responseSnmpValueString);
                logger.warning(String.valueOf(reportOID) + "=" + responseSnmpValueString);
                throw new SnmpMIBGetException("Response is report OID " + reportOID + "=" + responseSnmpValueString);
            }
            int nullLocation = responseSnmpValueString.indexOf(0);
            if (nullLocation >= 0) {
                responseSnmpValueString = responseSnmpValueString.substring(0, nullLocation);
            }
        }
        return responseSnmpValueString;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList getNextMibValueList(String oid) throws SnmpMIBGetException {
        ArrayList<MibValue> getNextMibValuesList = new ArrayList<MibValue>();
        String firstOid = oid;
        String retrievedOID = oid;
        SnmpVarBindList newVars = null;
        try {
            while (true) {
                String reportOID;
                newVars = this.dispacher.dispathGetMessage(this.version, (byte)-95, retrievedOID);
                SnmpSequence pair = (SnmpSequence)newVars.getSNMPObjectAt(0);
                SnmpObjectIdentifier getNextOID = (SnmpObjectIdentifier)pair.getSNMPObjectAt(0);
                AbstractSnmpObject snmpObject = pair.getSNMPObjectAt(1);
                String typeString = snmpObject.getTagCode();
                if (this.version == 3 && !(reportOID = this.checkReportOID(getNextOID.toString(), snmpObject.toString())).equals("")) {
                    AlarmMessageMake message = AlarmMessageMake.getInstance();
                    message.setErrorSNMPV3ReportOID(this.targetIP, getNextOID.toString(), reportOID, snmpObject.toString());
                    logger.warning(String.valueOf(reportOID) + "=" + snmpObject.toString());
                    return null;
                }
                if (getNextOID.toString().indexOf(firstOid) < 0) {
                    return getNextMibValuesList;
                }
                MibValue mibvalue = this.valueConvert(retrievedOID, typeString, snmpObject, getNextOID.toString());
                getNextMibValuesList.add(mibvalue);
                retrievedOID = getNextOID.toString();
            }
        }
        catch (SnmpV3AuthAbortException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
            throw new SnmpMIBGetException(e.getMessage());
        }
        catch (SnmpV3DecryptAbortException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
            throw new SnmpMIBGetException(e.getMessage());
        }
        catch (SnmpV3ConfigurationException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
            throw new SnmpMIBGetException(e.getMessage());
        }
        catch (SnmpMIBGetException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
            throw new SnmpMIBGetException(e.getMessage());
        }
        catch (SnmpSetException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
            throw new SnmpMIBGetException(e.getMessage());
        }
        catch (Exception e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
            throw new SnmpMIBGetException(e.getMessage());
        }
    }

    public String checkReportOID(String checkOID, String value) {
        String reportOidDescription = "";
        try {
            if (checkOID.equals("1.3.6.1.6.3.15.1.1.1.0")) {
                reportOidDescription = "Unsupported security level";
                SnmpV3UsmStatisticsManager.getInstance().setUsmStatsUnsupportedSecLevels(this.targetIP, Integer.parseInt(value));
            } else if (checkOID.equals("1.3.6.1.6.3.15.1.1.2.0")) {
                reportOidDescription = "Not in time packet";
                SnmpV3UsmStatisticsManager.getInstance().setUsmStatsNotInTimeWindows(this.targetIP, Integer.parseInt(value));
            } else if (checkOID.equals("1.3.6.1.6.3.15.1.1.3.0")) {
                reportOidDescription = "Unknown user name";
                SnmpV3UsmStatisticsManager.getInstance().setUsmStatsUnknownUserNames(this.targetIP, Integer.parseInt(value));
            } else if (checkOID.equals("1.3.6.1.6.3.15.1.1.4.0")) {
                reportOidDescription = "Unknown engine ID";
                SnmpV3UsmStatisticsManager.getInstance().setUsmStatsUnknownEngineIDs(this.targetIP, Integer.parseInt(value));
            } else if (checkOID.equals("1.3.6.1.6.3.15.1.1.5.0")) {
                reportOidDescription = "Wrong digest";
                SnmpV3UsmStatisticsManager.getInstance().setUsmStatsWrongDigests(this.targetIP, Integer.parseInt(value));
            } else if (checkOID.equals("1.3.6.1.6.3.15.1.1.6.0")) {
                reportOidDescription = "Descryption error";
                SnmpV3UsmStatisticsManager.getInstance().setUsmStatsDecryptionErrors(this.targetIP, Integer.parseInt(value));
            }
        }
        catch (NumberFormatException numberFormatException) {
            logger.warning(String.valueOf(checkOID) + value);
        }
        return reportOidDescription;
    }

    public void closedMibGetNext() {
        this.dispacher.closeConnection();
    }

    public MibValue valueConvert(String oid, String type, AbstractSnmpObject snmpValue, String oidNext) {
        String[] mib = new String[5];
        if (type.indexOf("OCTETSTRING") >= 0) {
            String snmpString = snmpValue.toString();
            int nullLocation = snmpString.indexOf(0);
            if (nullLocation >= 0) {
                snmpString = snmpString.substring(0, nullLocation);
            }
            mib[1] = oidNext;
            mib[2] = snmpString;
            mib[3] = type;
            String searchOid = oidNext;
            mib[0] = "unknown";
            mib[4] = "n";
            int i = 0;
            while (i < oid.length()) {
                if (this.oidTreeMap.containsKey(searchOid)) {
                    MibInfo miboid = (MibInfo)this.oidTreeMap.get(searchOid);
                    mib[0] = String.valueOf(miboid.getDescrip()) + mib[1].substring(miboid.getOid().length(), mib[1].length());
                    mib[4] = miboid.getAccess();
                } else {
                    int checkOidPos = searchOid.lastIndexOf(".");
                    if (checkOidPos >= 0) {
                        searchOid = searchOid.substring(0, checkOidPos);
                        ++i;
                        continue;
                    }
                }
                break;
            }
        } else {
            mib[1] = oidNext;
            mib[2] = snmpValue.toString();
            mib[3] = type;
            String searchOid = oidNext;
            mib[0] = "unknown";
            mib[4] = "n";
            int i = 0;
            while (i < oid.length()) {
                if (this.oidTreeMap.containsKey(searchOid)) {
                    MibInfo miboid = (MibInfo)this.oidTreeMap.get(searchOid);
                    mib[0] = String.valueOf(miboid.getDescrip()) + mib[1].substring(miboid.getOid().length(), mib[1].length());
                    mib[4] = miboid.getAccess();
                } else {
                    int checkOidPos = searchOid.lastIndexOf(".");
                    if (checkOidPos >= 0) {
                        searchOid = searchOid.substring(0, checkOidPos);
                        ++i;
                        continue;
                    }
                }
                break;
            }
        }
        MibValue mibvalue = MibValueQueue.getInstance().popMibValueQueue(String.valueOf(this.targetIP) + oid);
        mibvalue.setMibValue(mib[0], oidNext, mib[3], mib[2], oidNext, mib[4]);
        return mibvalue;
    }
}

