/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.alarm;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.logging.Logger;
import netjfwatcher.database.access.control.DatabaseAccess;
import netjfwatcher.database.access.control.DatabaseAccessPool;
import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.engine.model.action.DatabaseControl;
import netjfwatcher.engine.nodewatchinfo.NodeWatchInfo;

public class SearchNoderegisterInfo {
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public ArrayList searchInfo(String columName, String whrereName) {
        if (!DatabaseControl.getInstance().isDatabaseStart()) {
            return null;
        }
        String sql = "SELECT * FROM noderegister where " + columName + " = '" + whrereName + "'";
        ArrayList<NodeWatchInfo> nodeWatchInfoList = new ArrayList<NodeWatchInfo>();
        DatabaseAccess databaseAccess = DatabaseAccessPool.getInstance().popQueueDatabaseAccess();
        Connection connection = null;
        Statement statement = null;
        ResultSet rs = null;
        try {
            try {
                connection = databaseAccess.getConnection();
                statement = connection.createStatement();
                rs = statement.executeQuery(sql);
                while (rs.next()) {
                    NodeWatchInfo nodewatchinfo = new NodeWatchInfo();
                    nodewatchinfo.setNodename(rs.getString("nodename"));
                    nodewatchinfo.setGroup(rs.getString("nodegroup"));
                    nodewatchinfo.setIpaddress(rs.getString("ipaddress"));
                    nodewatchinfo.setNodeKind(rs.getString("nodeKind"));
                    nodewatchinfo.setPingPeriod(rs.getString("ping_period"));
                    nodewatchinfo.setPingThreshold(rs.getString("ping_threshold"));
                    nodewatchinfo.setSnmpPeriod(rs.getString("snmp_period"));
                    nodewatchinfo.setSnmpLevel(rs.getString("snmp_level"));
                    nodewatchinfo.setSnmpROCommunity(rs.getString("community"));
                    nodeWatchInfoList.add(nodewatchinfo);
                }
            }
            catch (DatabaseConnectionException e) {
                this.logger.warning(e.getMessage());
                e.printStackTrace();
            }
            catch (SQLException ex) {
                this.logger.warning(ex.getMessage());
                ex.printStackTrace();
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    this.logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                rs = null;
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    this.logger.warning(e.getMessage());
                    e.printStackTrace();
                }
                statement = null;
            }
            if (connection != null && databaseAccess != null) {
                databaseAccess.releaseConnection(connection);
                connection = null;
                DatabaseAccessPool.getInstance().releaseQueueDatabaseAccess(databaseAccess);
            }
        }
        return nodeWatchInfoList;
    }
}

