/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.alarm;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.alarm.AlarmCodeInformation;
import netjfwatcher.engine.alarm.DialogMessageResource;
import netjfwatcher.engine.alarm.DocumentParseErrorHandler;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AlarmMessageResource {
    public static final String PING_TIMEOUT = "1";
    public static final String PING_HOST_UNREACHABLE = "2";
    public static final String PING_OVER_AT_THRESHHOLD = "3";
    public static final String SNMP_GET_TIMEOUT = "4";
    public static final String SNMP_NO_ROUTE_TOHOST = "5";
    public static final String SNMP_IOEXCEPTION = "6";
    public static final String RECOVERY_PING_TIMEOUT = "7";
    public static final String RECOVERY_PING_OVER_AT_THRESHHOLD = "8";
    public static final String RECOVERY_SNMP_GET_TIMEOUT = "9";
    public static final String RECOVERY_SNMP_NO_ROUTE_TOHOST = "10";
    public static final String RECOVERY_SNMP_IOEXCEPTION = "11";
    public static final String SNMP_TRAP_RECEIVE = "12";
    public static final String SEND_MAIL_ERROR = "13";
    public static final String SEND_MAIL_QUEUE_OVERFLOW = "14";
    public static final String STATISTICS_MIB_OVER_AT_THRESHHOLD = "15";
    public static final String RECOVERY_STATISTICS_MIB_OVER_AT_THRESHHOLD = "16";
    public static final String HTTP_GET_ERROR = "17";
    public static final String RECOVERY_HTTP_GET_ERROR = "18";
    public static final String POP3_CHECK_ERROR = "19";
    public static final String RECOVERY_POP3_CHECK_ERROR = "20";
    public static final String SMTP_CHECK_ERROR = "21";
    public static final String RECOVERY_SMTP_CHECK_ERROR = "22";
    public static final String CHANGE_INTERFACE_STATUS_WARNING = "23";
    public static final String CHANGE_INTERFACE_WARNING = "24";
    public static final String CHANGE_NODE_WARNING = "25";
    public static final String CHANGE_NODE_SYSTEM_INFO_WARNING = "26";
    public static final String SNMP_RECEIVE_ERROR_STATUS_WARNING = "27";
    public static final String ABORT_GET_SNMP_MIB_ERROR = "28";
    public static final String SNMP_V3_RECEIVE_REPORT_OID_WARNING = "29";
    public static final String SNMP_UNMUCH_REQUEST_ID_WARNING = "30";
    public static final String SNMP_V3_UNMUCH_REQUEST_MSG_ID_WARNING = "31";
    public static final String UNKNOWN_HOST_ID_ERROR = "32";
    public static final String SNMPV3_CONFIG_ERROR = "33";
    public static final String SYSLOG_NG = "34";
    public static final String HONEY_PORT_SCAN = "35";
    public static final String PORT_SCAN_NG = "36";
    public static final String RECOVERY_PORT_SCAN_NG = "37";
    public static final String CHANGE_PRINT_STATUS_WARNING = "38";
    public static final String CHANGE_PRINTER_INTERFACE_WARNING = "39";
    public static final String DATABASE_CONNECTION_ERROR = "40";
    public static final String RECOVERY_DATABASE_CONNECTION_ERROR = "41";
    public static final String DATABASE_SQL_EXCEPTION_ERROR = "42";
    public static final String RECOVERY_DATABASE_SQL_EXCEPTION_ERROR = "43";
    private static final String MESSAGE_TAG_ATTRIBUTE = "ID";
    private static final String MESSAGE_ID_NOTFOUND = "Application Error";
    private static HashMap alertMessageMap = new HashMap();
    private static HashMap confirmMessageMap = new HashMap();
    private static Logger logger = null;

    private AlarmMessageResource() {
        logger = Logger.getLogger(DialogMessageResource.class.getName());
    }

    public static String getConfirmMessage(String keyId) {
        if (confirmMessageMap.containsKey(keyId)) {
            return (String)confirmMessageMap.get(keyId);
        }
        AlarmMessageResource.parseURLAlarmMessageXMLFile();
        if (confirmMessageMap.containsKey(keyId)) {
            return (String)confirmMessageMap.get(keyId);
        }
        return MESSAGE_ID_NOTFOUND;
    }

    public static AlarmCodeInformation getAlertMessage(String keyId) {
        if (alertMessageMap.containsKey(keyId)) {
            return (AlarmCodeInformation)alertMessageMap.get(keyId);
        }
        AlarmMessageResource.parseURLAlarmMessageXMLFile();
        if (alertMessageMap.containsKey(keyId)) {
            return (AlarmCodeInformation)alertMessageMap.get(keyId);
        }
        AlarmCodeInformation returnAlarm = new AlarmCodeInformation();
        returnAlarm.setMessage(MESSAGE_ID_NOTFOUND);
        returnAlarm.setCode("unkonown");
        return returnAlarm;
    }

    public static void parseDirectryAlarmMessageXMLFile() {
        Document dom = null;
        DocumentBuilderFactory dbfactory = null;
        DocumentBuilder builder = null;
        File f = new File("resources/alarm_message.xml");
        try {
            dbfactory = DocumentBuilderFactory.newInstance();
            dbfactory.setValidating(true);
            builder = dbfactory.newDocumentBuilder();
            builder.setErrorHandler(new DocumentParseErrorHandler());
            dom = builder.parse(f);
        }
        catch (Exception e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
        Element root = dom.getDocumentElement();
        Node firstNode = root.getFirstChild();
        AlarmMessageResource.setMessageMap(alertMessageMap, firstNode, "info", MESSAGE_TAG_ATTRIBUTE);
    }

    public static void parseURLAlarmMessageXMLFile() {
        Document dom = null;
        DocumentBuilderFactory dbfactory = null;
        DocumentBuilder builder = null;
        logger = Logger.getLogger(DialogMessageResource.class.getName());
        URL url = null;
        Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();
        url = bundle.getEntry("resources/alarm_message.xml");
        if (url == null) {
            logger.severe(url + " : Not Found");
            logger.severe("Alert/Confirm Dialog Window Message XML file url : " + url);
        }
        try {
            dbfactory = DocumentBuilderFactory.newInstance();
            dbfactory.setValidating(true);
            builder = dbfactory.newDocumentBuilder();
            builder.setErrorHandler(new DocumentParseErrorHandler());
            dom = builder.parse(url.openStream());
        }
        catch (Exception e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }
        Element root = dom.getDocumentElement();
        Node firstFlightInfoNode = root.getFirstChild();
        AlarmMessageResource.setMessageMap(alertMessageMap, firstFlightInfoNode, "info", MESSAGE_TAG_ATTRIBUTE);
    }

    private static void setMessageMap(HashMap<String, AlarmCodeInformation> messageMap, Node rootNode, String tagName, String tagAttribute) {
        Node targetNode = rootNode;
        while (targetNode != null) {
            if (targetNode.getNodeType() == 1 && targetNode.getNodeName().equals(tagName)) break;
            targetNode = targetNode.getNextSibling();
        }
        if (targetNode != null) {
            Node nodeLeaf = targetNode.getFirstChild();
            while (nodeLeaf != null) {
                if (nodeLeaf.getNodeType() == 1) {
                    String id = "";
                    String level = "";
                    String code = "";
                    String message = "";
                    NodeList testlist = nodeLeaf.getChildNodes();
                    if (nodeLeaf.getNodeName().equals("alarm")) {
                        NamedNodeMap map = nodeLeaf.getAttributes();
                        int j = 0;
                        while (j < map.getLength()) {
                            Node node = map.item(j);
                            if (node.getNodeName().equals(tagAttribute)) {
                                id = node.getNodeValue();
                            }
                            ++j;
                        }
                    }
                    int i = 0;
                    while (i < testlist.getLength()) {
                        Node testnode2 = testlist.item(i);
                        if (testnode2.getNodeName().equals("level")) {
                            level = testnode2.getFirstChild().getNodeValue();
                        }
                        if (testnode2.getNodeName().equals("code")) {
                            code = testnode2.getFirstChild().getNodeValue();
                        }
                        if (testnode2.getNodeName().equals("message")) {
                            message = testnode2.getFirstChild().getNodeValue();
                        }
                        ++i;
                    }
                    if (!id.equals("")) {
                        AlarmCodeInformation alarmInfo = new AlarmCodeInformation();
                        alarmInfo.setId(id);
                        alarmInfo.setLevel(level);
                        alarmInfo.setCode(code);
                        alarmInfo.setMessage(message);
                        messageMap.put(id, alarmInfo);
                    }
                }
                nodeLeaf = nodeLeaf.getNextSibling();
            }
        }
    }

    public static AlarmMessageResource getInstance() {
        return SingletonMessage.MESSAGE;
    }

    /* synthetic */ AlarmMessageResource(AlarmMessageResource alarmMessageResource) {
        this();
    }

    private static class SingletonMessage {
        static final AlarmMessageResource MESSAGE = new AlarmMessageResource(null);

        private SingletonMessage() {
        }
    }
}

