/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.authentication;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import netjfwatcher.authentication.AuthenticationConfig;

public class AuthenticationManager {
    private Map<String, Date> clientIPMap = Collections.synchronizedMap(new HashMap());

    private AuthenticationManager() {
    }

    public boolean checkUserName(String ipAddress, String userName, String password) {
        if (AuthenticationConfig.getInstance().getAuthInfo().checkUser(userName, password)) {
            if (!this.checkIP(ipAddress)) {
                this.setIP(ipAddress);
            }
            return true;
        }
        return false;
    }

    public boolean checkIP(String ipAddress) {
        return this.clientIPMap.containsKey(ipAddress);
    }

    public void setIP(String ipAddress) {
        Date startDate = Calendar.getInstance().getTime();
        this.clientIPMap.put(ipAddress, startDate);
    }

    public static AuthenticationManager getInstance() {
        return SingletonResource.RESOURCE;
    }

    /* synthetic */ AuthenticationManager(AuthenticationManager authenticationManager) {
        this();
    }

    private static class SingletonResource {
        static final AuthenticationManager RESOURCE = new AuthenticationManager(null);

        private SingletonResource() {
        }
    }
}

