/*
 * Created on 2004/12/01
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.socketclient;

import java.util.logging.Logger;

import netjfwatcher.common.view.AbstractNodeTreeView;
import netjfwatcher.common.view.NodeTree;
import netjfwatcher.common.view.NodeTreeGroup;
import netjfwatcher.engine.model.action.ListenerNodeListTree;
import netjfwatcher.engine.model.action.ActionBuilderAlarmList.ActionOpenEditorPartPersonalNodeAlarmSocket;
import netjfwatcher.engine.model.action.ActionBuilderNodeOperation.ActionNodeOperationSocket;
import netjfwatcher.engine.model.action.ActionBuilderNodeOperation.ActionShowNodeViewSocket;
import netjfwatcher.engine.model.action.ActionBuilderSnmp.ActionShowNodeSnmpViewSocket;
import netjfwatcher.engine.model.action.ActionBuilderSnmp.ActionSnmpStatisticsSetSocket;
import netjfwatcher.engine.resourceconfig.ClientEngineInfo;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.ping.NodePingMenu;
import netjfwatcher.engine.view.editorpart.snmp.NodeSnmpStatisticsMenu;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchActionConstants;


/**
 * lbg[NoRm[hTree ViewNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NetworkClientNodeTreeView extends AbstractNodeTreeView {
    /* MO */
    private static Logger logger = null;

    /* m[hSNMPv񃁃j[ */
    private NodeSnmpStatisticsMenu nodeSnmpStatisticsMenu =
        new NodeSnmpStatisticsMenu();

    /* PingĎj[ */
    private NodePingMenu nodePingMenu = new NodePingMenu();

    private static ActionBuilderXMLSocket xmlSocketAction = new ActionBuilderXMLSocket();
    /**
     * lbg[NoRm[hTree ViewNXCX^X
     * ܂B
     *
     */
    public NetworkClientNodeTreeView() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * f[^x[Xm[hĎ񃊃XgǂݍTree\
     * ܂B
     *
     */
    protected void initShow() {
        /*
        ((ActionReloadNodeTreeSocket) actionNodeTree.actionReloadNodeTreeSocket())
        .setNodeTree();
        */
    }

    /**
     * ReLXgj[𐶐܂B
     *
     */
    public void createContextMenu() {
        /* j[}l[W */
        MenuManager mm = new MenuManager();
        mm.setRemoveAllWhenShown(true);

        /* j[Xi[Zbg */
        mm.addMenuListener(
            new IMenuListener() {
                public void menuAboutToShow(IMenuManager manager) {
                    fillContextMenu(manager);
                }
            });

        Menu menu = mm.createContextMenu(nodeListTreeViewer.getControl());
        nodeListTreeViewer.getControl().setMenu(menu);
        getSite().registerContextMenu(mm, nodeListTreeViewer);
    }

    /**
     * ANV̏ƂToolBarݒ肵܂B
     *
     */
    protected void setToolBarActions() {
        /* ToolBarݒ */
        IToolBarManager toolBarManager =
            getViewSite().getActionBars().getToolBarManager();

        // m[hTreeēǍANV
        toolBarManager.add(
            getActionNodeTreeBuilder().actionReloadNodeTreeSocket());
        toolBarManager.add(
            getActionNodeTreeBuilder().actionSortNodeTreeSocket());
        toolBarManager.add(
            actionBuilderNodeOperation.getActionNodeOperationSocket());
        toolBarManager.add(xmlSocketAction.getActionXMLSocketView());
        toolBarManager.add(actionBuilderEditorPart.actionCloseAllEditors());

    }

    /**
     * j[o[ݒ肵܂B
     * preWindowOpenɌĂ΂܂B
     * m[hTreẽm[hIĂꍇƑIĂȂꍇ
     * j[ς܂B
     *
     * @param manager IMenuManager
     */
    protected void fillContextMenu(IMenuManager manager) {
        /* m[hTreeǂݍ݃ANVZbg */
        manager.add(new GroupMarker(IWorkbenchActionConstants.MB_ADDITIONS));

        /* m[hTreeēǂݍ */
        manager.add(getActionNodeTreeBuilder().actionReloadNodeTreeSocket());

        /* m[hTree\[g */
        manager.add(getActionNodeTreeBuilder().actionSortNodeTreeSocket());

        /*
         * Treẽm[hIĂ邩`FbN
         */
        if (nodeListTreeViewer.getTree().getSelection() != null) {
            TreeItem[] treeItem = nodeListTreeViewer.getTree().getSelection();

            if ((treeItem != null) && (treeItem.length > 0)) {
                for (
                    int nodeTreeSelectNo = 0;
                        nodeTreeSelectNo < treeItem.length;
                        nodeTreeSelectNo++) {
                    if (
                        treeItem[nodeTreeSelectNo].getData() instanceof NodeTreeGroup) {
                        /* GroupI */
                        nodeListTreeViewer.getTree().deselectAll();
                    } else if (
                        treeItem[nodeTreeSelectNo].getData() instanceof NodeTree) {
                        /*
                         * Treẽm[hĎ񒊏o
                         */
                        NodeInformation targetNodeInfo =
                            ((NodeTree) treeItem[nodeTreeSelectNo].getData())
                            .getNodeInfo();

                        /* m[h\`j[ǉ */
                        ((ActionShowNodeViewSocket) actionBuilderNodeOperation
                        .getActionShowNodeViewSocket()).setNodeInfo(
                            targetNodeInfo);
                        manager.add(
                            actionBuilderNodeOperation
                            .getActionShowNodeViewSocket());

                        /* m[hAlarmj[ǉ */
                        ((ActionOpenEditorPartPersonalNodeAlarmSocket) actinAlarm
                        .getActionOpenEditorPartPersonalNodeAlarmSocket())
                        .setNodeInfo(targetNodeInfo);
                        manager.add(
                            actinAlarm
                            .getActionOpenEditorPartPersonalNodeAlarmSocket());

                        /* m[hSNMP\j[ǉ */
                        ((ActionShowNodeSnmpViewSocket) snmpAction
                        .getActionSnmpInfoSocket()).setNodeInfo(targetNodeInfo);
                        manager.add(snmpAction.getActionSnmpInfoSocket());

                        /* m[hǉEҏWE폜j[ǉ */
                        ((ActionNodeOperationSocket) actionBuilderNodeOperation
                        .getActionNodeOperationSocket()).setNodeInfo(
                            targetNodeInfo);
                        manager.add(
                            actionBuilderNodeOperation
                            .getActionNodeOperationSocket());

                        /*
                         * m[hPingf[^j[j[}l[W
                         * ǉ
                         */
                        nodePingMenu.createPingMenu(
                            manager, targetNodeInfo, true);

                        /*
                         * m[hSnmpv\j[j[}l[W
                         * ɒǉ
                         */
                        nodeSnmpStatisticsMenu.createSnmpStatisticsMenu(
                            manager, targetNodeInfo, true);

                        /*
                         * m[hSnmpvZbgj[j[}l[W
                         * ɒǉ
                         */
                        ((ActionSnmpStatisticsSetSocket) snmpAction
                        .getActionSnmpStatisticsSetSocket()).setNodeInfo(
                            targetNodeInfo);
                        manager.add(
                            snmpAction.getActionSnmpStatisticsSetSocket());
                    } else {
                        /* Groupłm[hłȂ */
                        nodeListTreeViewer.getTree().deselectAll();
                    }
                }
            } else {
                /* TreeI */
                manager.add(
                    actionBuilderNodeOperation.getActionNodeOperationSocket());
            }
        }

        /* Snmpv\ */
        manager.add(snmpAction.getActionSnmpStatisticsSocket());

        /* Sm[hAlarm\ */
        manager.add(actinAlarm.getActionShowAllNodeAlarmListTableSocket());
        
        manager.add(xmlSocketAction.getActionXMLSocketView());
    }

    /**
     * m[hTree View̑IXi[ݒ肵܂B
     *
     */
    protected void setupNodeTreeViewListener() {
        /*
         * Node Tree ViewɃXi[o^
         * Xi[̏ƂẮA
         * e[uViewɃtB[hꗗőIGg͒lƂĐݒ
         *
         */
        nodeListTreeViewer.addSelectionChangedListener(
            new ListenerNodeListTree(true));
    }

    /**
     * SocketڑGWAhXԂ܂B
     *
     * @return engineAddress SocketڑGWAhX
     */
    public static final String getTitleSuffixEngineAddress() {
        String engineAddress =
            ClientEngineInfo.getClientEngineInfoInstance().getEngineAddress();

        return " (Engine=" + engineAddress + ")";
    }
}
