/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpagent.model;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;


/**
 *
 * SNMP}l[WSetRequestCX^XXVɂAgent
 * CX^X̃e[u\XVf[^L[Ƃĕێ
 * NXłB
 * L[ւPushAgentSetRequestR}hMyуCX^X
 * XVōs܂B
 * L[PopAgentCX^Xe[u\ViewNX̎
 * ɂčs܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 *
 */
public class AgentInstanceDataRefreshQueue {
    /* L[\List */
    private static List agentInstanceQueueList =
        Collections.synchronizedList(new LinkedList());

    /**
     * L[ObjectPop܂B
     *
     * @return agentInstance L[PopObject
     */
    public Object popAgentQueue() {
        Object agentInstance = null;

        if (agentInstanceQueueList.size() > 0) {
            agentInstance = agentInstanceQueueList.get(0);
            agentInstanceQueueList.remove(0);
        }

        return agentInstance;
    }

    /**
     * L[ObjectPush܂B
     *
     * @param object L[Ɋi[f[^
     */
    public void pushQueue(Object object) {
        agentInstanceQueueList.add(object);
    }

    /**
     * VOgNXCX^XԂ܂B
     *
     * @return VOgNXCX^X
     */
    public static AgentInstanceDataRefreshQueue getInstance() {
        return SingletonResource.INSTANCE;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final AgentInstanceDataRefreshQueue INSTANCE =
            new AgentInstanceDataRefreshQueue();
    }
}
