/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpagent;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;

import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.messageformat.SnmpTrapPDU;
import netjfwatcher.snmp.preference.SnmpBERCodec;
import netjfwatcher.snmp.preference.SnmpPreference;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;
import netjfwatcher.snmp.snmpv3.SnmpV3ConfigurationException;
import netjfwatcher.snmpagent.process.AgentDispatcher;
import netjfwatcher.snmpagent.process.AgentTrapPDU;
import netjfwatcher.snmpmanager.trap.EnterpriseOIDConfig;
import netjfwatcher.snmpmanager.trap.EnterpriseOIDInfo;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/**
 * Snmp AgentłTrapMView\NXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class AgentTrapSendView extends AbstractAgentView {
	/* Text */
	private static final int TEXT_WIDTH = 200;

	private static final int COUNT_TEXT_WIDTH = 100;

	private static final int COMBO_VISIBLE_ITEM_COUNT = 15;
	
	/* ColdStart Generic Trap Code */
	private static final int COLDSTART_NUMBER = 0;

	/* WarmStart Generic Trap Code */
	private static final int WARMSTART_NUMBER = 1;

	/* LinkDown Generic Trap Code */
	private static final int LINKDOWN_NUMBER = 2;

	/* LinkUp Generic Trap Code */
	private static final int LINKUP_NUMBER = 3;

	/* AuthenticationFailure Generic Trap Code */
	private static final int AUTHENTICATIONFAILURE_NUMBER = 4;

	/* EgpneiborLoss Generic Trap Code */
	private static final int EGPNEIBORLOSS_NUMBER = 5;

	/* EnterpriseSpecific Generic Trap Code */
	private static final int ENTERPRISESPECIFIC_NUMBER = 6;

	/** ColdStart Generic Trap Code Description */
	protected static final String COLDSTART = "coldStart (" + COLDSTART_NUMBER
			+ ")";

	/** WarmStart Generic Trap Code Description */
	protected static final String WARMSTART = "warmStart (" + WARMSTART_NUMBER
			+ ")";

	/** LinkDown Generic Trap Code Description */
	protected static final String LINKDOWN = "linkDown (" + LINKDOWN_NUMBER
			+ ")";

	/** LinkUp Generic Trap Code Description */
	protected static final String LINKUP = "linkUp (" + LINKUP_NUMBER + ")";

	/** AuthenticationFailure Generic Trap Code Description */
	protected static final String AUTHENTICATIONFAILURE = "authenticationFailure ("
			+ AUTHENTICATIONFAILURE_NUMBER + ")";

	/** EgpneiborLoss Generic Trap Code Description */
	protected static final String EGPNEIBORLOSS = "egpNeiborLoss ("
			+ EGPNEIBORLOSS_NUMBER + ")";

	/** EnterpriseSpecific Generic Trap Code Description */
	protected static final String ENTERPRISE_SPECIFIC = "enterpriseSpecific ("
			+ ENTERPRISESPECIFIC_NUMBER + ")";

	/* Destination Address */
	private static Text targetIPText;

	/* Community */
	private static Text communityText;

	/* Enterprise OID */
	private Combo enterpriseOidCombo;

	/* Trap OID */
	private static Text snmpTrapOIDText;

	/* Trap OID Value */
	private static Combo snmpTrapOIDValueComboBox;

	/* AgentAhX */
	private static Text agentIPAddressText;

	/* OID */
	private static Text additionalVariableOIDText;

	/* OID Description */
	private static Text additionalVariableOIDDescriprionText;

	/* Variable */
	private static Text valueAdditionalVariableText;

	/* TrapM񐔕\Text */
	private static Text sendTrapCounterText;

	/* TrapMs[g񐔕\Text */
	private static Text sendTrapRepeatCounterText;

	/* SNMP Version ComboBox */
	private static Combo snmpVersionComboBox;

	/* SNMP Object Type ComboBox */
	private static Combo snmpValueTypeCombo;

	/* Generic Trap Combo Box */
	private static Combo genericTrapCombo;

	/* Specific Trap Combo Box */
	private static Combo specificTrapCombo;

	/* TrapM{^ */
	private static Button trapSendButton;

	/* ftHgAgentAhX */
	private static final String DEFAULT_AGENT_ADDRESS = "0.0.0.0";

	/* ftHg̃R~jeB */
	private static final String DEFAULT_COMMUNITY = "public";

	/* ftHgEnterprise OID */
	private static final String ENTERPRISE_OID = "1.3.6.1.4.1";

	/*
	 * ftHgvarBindOIDƂ interfaces.ifTable.ifEntry.ifIndex.1w
	 */
	private static final String DEFAULT_VAR_BIND_OID = "1.3.6.1.2.1.2.2.1.1.1";

	/* ftHgvarBind OIDDescription */
	private static final String DEFAULT_VAR_BIND_OID_DESC = "ifIndex.1";

	/* varBind valueftHgl */
	private static final String DEFAULT_VAR_BIND_VALUE = "1";

	/* Scroll CompositeTCY */
	private static final int[] SCROLL_COMPOSITE_SIZE = { 800, 300 };

	/* MO */
	private static Logger logger;

	/* TrapM */
	private static int sendCount = 0;

	/* TrapMs[g */
	private static int sendRepeatCount = 1;

	private static final int HORIZONTAL_SPAN3 = 3;

	/* TrapMSNMPo[W */
	private int version;

	private Map enterpriseOidInfoMap;

	/*
	 * snmpTrapOIDpair(Value)ƂȂOIDli[List OIDIComboBox̑IԍɑΉOIDi[
	 * 
	 */
	private List<String> snmpTrapOidValueList;

	public AgentTrapSendView() {
		snmpTrapOidValueList = Collections.synchronizedList(new LinkedList<String>());
		enterpriseOidInfoMap = EnterpriseOIDConfig.getInstance()
				.getEnterpriseOidHashMap();
	}

	/**
	 * PartControl𐶐܂B
	 * 
	 * @param parent
	 *            Composite
	 */
	public void createPartControl(Composite parent) {
		logger = Logger.getLogger(this.getClass().getName());

		/*
		 * eCompositezueLayout ieCompositec1ɔzuj
		 */
		ScrolledComposite scrollComposite = new ScrolledComposite(parent,
				SWT.H_SCROLL | SWT.V_SCROLL);

		GridLayout layout = new GridLayout(1, false);
		scrollComposite.setLayout(layout);

		GridData gridData = null;

		GridLayout gridLayout = new GridLayout(5, false);
		Composite composite = new Composite(scrollComposite, SWT.NULL);

		composite.setLayout(gridLayout);
		composite.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
		gridData = new GridData();

		Label label = new Label(composite, SWT.NONE);
		label.setText("Destination Address");
		label.setLayoutData(new GridData());
		targetIPText = new Text(composite, SWT.BORDER);
		targetIPText.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		targetIPText.setLayoutData(gridData);

		/*
		 * SNMPo[WIComboBoxZbg
		 */
		snmpVersionComboBox = new Combo(composite, SWT.DROP_DOWN
				| SWT.READ_ONLY);
		snmpVersionComboBox.add("SNMP Ver.1");
		snmpVersionComboBox.add("SNMP Ver.2");
		snmpVersionComboBox.add("SNMP Ver.3");
		snmpVersionComboBox.select(0);
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN3;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		snmpVersionComboBox.setLayoutData(gridData);

		/*
		 * R~jeBZbg
		 */
		label = new Label(composite, SWT.NONE);
		label.setText("Community");
		label.setLayoutData(new GridData());

		communityText = new Text(composite, SWT.BORDER);
		communityText.setText(DEFAULT_COMMUNITY);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		communityText.setLayoutData(gridData);

		/* Dummy column */
		Label label2 = new Label(composite, SWT.NONE);
		label2.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN3;
		gridData.verticalSpan = 1;
		label2.setLayoutData(gridData);

		/*
		 * Enterprise OIDZbg
		 */
		label = new Label(composite, SWT.NONE);
		label.setText("Enterprise OID");
		label.setLayoutData(new GridData());

		enterpriseOidCombo = new Combo(composite, SWT.DROP_DOWN);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		enterpriseOidCombo.setLayoutData(gridData);
		enterpriseOidCombo.add(ENTERPRISE_OID);
		Iterator it;
		for (it = enterpriseOidInfoMap.keySet().iterator(); it.hasNext();) {
			String keyOid = (String) it.next();
			EnterpriseOIDInfo info = (EnterpriseOIDInfo) enterpriseOidInfoMap
					.get(keyOid);
			enterpriseOidCombo.add(ENTERPRISE_OID + "." + keyOid + " " + "("
					+ info.getCompany() + ")");

		}
		enterpriseOidCombo.setVisibleItemCount(COMBO_VISIBLE_ITEM_COUNT);
		
		/* Dummy column */
		label2 = new Label(composite, SWT.NONE);
		label2.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN3;
		gridData.verticalSpan = 1;
		label2.setLayoutData(gridData);

		label = new Label(composite, SWT.NONE);
		label.setText("SnmpTrapOID");
		label.setLayoutData(new GridData());

		snmpTrapOIDText = new Text(composite, SWT.BORDER);
		snmpTrapOIDText.setText(SnmpPreference.SNMP_TRAP_OID);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		snmpTrapOIDText.setLayoutData(gridData);
		snmpTrapOIDText.setEditable(false);

		/* SNMP Trap OIDIComboBoxZbg */
		setSnmpTrapOIDValueComboBox(composite);

		label = new Label(composite, SWT.NONE);
		label.setText("Agent IP Address");
		label.setLayoutData(new GridData());

		agentIPAddressText = new Text(composite, SWT.BORDER);
		agentIPAddressText.setText(getLocalAddress());
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		agentIPAddressText.setLayoutData(gridData);

		getLocalAddress();

		/* Dummy column */
		label2 = new Label(composite, SWT.NONE);
		label2.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN3;
		gridData.verticalSpan = 1;
		label2.setLayoutData(gridData);

		label = new Label(composite, SWT.NONE);
		label.setText("Additional variable OID");
		label.setLayoutData(new GridData());

		additionalVariableOIDText = new Text(composite, SWT.BORDER);
		additionalVariableOIDText.setText(DEFAULT_VAR_BIND_OID);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		additionalVariableOIDText.setLayoutData(gridData);

		additionalVariableOIDDescriprionText = new Text(composite, SWT.BORDER);
		additionalVariableOIDDescriprionText.setText(DEFAULT_VAR_BIND_OID_DESC);
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN3;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		additionalVariableOIDDescriprionText.setLayoutData(gridData);
		additionalVariableOIDDescriprionText.setEditable(false);

		label = new Label(composite, SWT.NONE);
		label.setText("Value for additional variable");
		label.setLayoutData(new GridData());

		valueAdditionalVariableText = new Text(composite, SWT.BORDER);
		valueAdditionalVariableText.setText(DEFAULT_VAR_BIND_VALUE);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		valueAdditionalVariableText.setLayoutData(gridData);

		/*
		 * SNMPIuWFNg^CvIComboBoxZbg
		 */
		setSnmpValueTypeCombo(composite);

		/*
		 * GenericTrapIComboBoxZbg
		 */
		setGenericTrapCombo(composite);

		/* Dummy column */
		label2 = new Label(composite, SWT.NONE);
		label2.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN3;
		gridData.verticalSpan = 1;
		label2.setLayoutData(gridData);

		/*
		 * SpecificTrapIComboBoxZbg
		 */
		setSpecificTrapCombo(composite);

		/*
		 * TrapMButton
		 */
		trapSendButton = new Button(composite, SWT.NONE);
		trapSendButton.setText("Trap send");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		trapSendButton.setLayoutData(gridData);

		label = new Label(composite, SWT.NONE);
		label.setText("Send Trap Count");
		label.setLayoutData(new GridData());

		sendTrapCounterText = new Text(composite, SWT.BORDER | SWT.READ_ONLY
				| SWT.RIGHT);
		sendTrapCounterText.setText(Integer.toString(sendCount));
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = COUNT_TEXT_WIDTH;
		sendTrapCounterText.setLayoutData(gridData);

		/* Dummy column */
		label2 = new Label(composite, SWT.NONE);
		label2.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN3;
		gridData.verticalSpan = 1;
		label2.setLayoutData(gridData);

		label = new Label(composite, SWT.NONE);
		label.setText("Send Trap Repeat Count");
		label.setLayoutData(new GridData());

		sendTrapRepeatCounterText = new Text(composite, SWT.BORDER | SWT.RIGHT);
		sendTrapRepeatCounterText.setText(Integer.toString(sendRepeatCount));
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = COUNT_TEXT_WIDTH;
		sendTrapRepeatCounterText.setLayoutData(gridData);

		scrollComposite.setContent(composite);
		scrollComposite.setMinSize(SCROLL_COMPOSITE_SIZE[0],
				SCROLL_COMPOSITE_SIZE[1]);
		scrollComposite.setExpandHorizontal(true);
		scrollComposite.setExpandVertical(true);

		/*
		 * SNMP VersionIXi[
		 */
		snmpVersionComboBox.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				/* SNMPo[WI */
				selectSnmpVersionComboBox();
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		/*
		 * TrapM{^Xi[
		 */
		trapSendButton.addSelectionListener(new SelectionListener() {
			/**
			 * Trap𑗐M܂B
			 * 
			 * @param event
			 *            SelectionEvent
			 */
			public void widgetSelected(SelectionEvent event) {
				/* TrapM */
				trapSendButton.setEnabled(false);
				sendTrap();
				trapSendButton.setEnabled(true);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});
	}

	/*
	 * Trap𑗐M܂B
	 * 
	 */
	private void sendTrap() {
		if (targetIPText.getText().equals("")) {
			Shell shell = new Shell();
			MessageBox alertMessageBox = new MessageBox(shell, SWT.YES
					| SWT.ICON_WARNING);

			alertMessageBox.setMessage("Illegal destination Address");
			alertMessageBox.open();
			targetIPText.setFocus();
			shell.dispose();

			return;
		}

		String ipAddress = targetIPText.getText();
		String hostAddress = "";
		String community = communityText.getText();

		try {
			InetAddress host = InetAddress.getByName(ipAddress);
			hostAddress = host.getHostAddress();
		} catch (UnknownHostException e2) {
			Shell shell = new Shell();
			MessageDialog.openError(shell, "Error", "UnknownHostException"
					+ " IP Address = " + targetIPText.getText());
			shell.dispose();
			targetIPText.setFocus();

			return;
		}

		try {
			SnmpSequence trapPDUSequence = createTrapPDU(hostAddress, community);

			if (trapPDUSequence != null) {
				// TrapM
				AgentDispatcher dispacher = new AgentDispatcher();

				try {
					sendRepeatCount = Integer
							.parseInt(sendTrapRepeatCounterText.getText());
				} catch (NumberFormatException e) {
					sendRepeatCount = 1;
				}

				while (sendRepeatCount >= 1) {
					/* TrapM */
					dispacher.dispacherTrapSend(hostAddress, version,
							community, trapPDUSequence);
					sendRepeatCount--;
					sendCount++;
					sendTrapCounterText.setText(Integer.toString(sendCount));
					sendTrapRepeatCounterText.setText(Integer
							.toString(sendRepeatCount));
				}
			}
		} catch (SocketException e1) {
			logger.warning(e1.getMessage());
			e1.printStackTrace();

			MessageBox alertMessageBox = new MessageBox(getViewSite()
					.getShell(), SWT.YES | SWT.ICON_WARNING);
			alertMessageBox.setMessage("SocketException Trap send "
					+ e1.getMessage());
			alertMessageBox.open();
		} catch (UnknownHostException e1) {
			logger.warning(e1.getMessage());
			e1.printStackTrace();

			MessageBox alertMessageBox = new MessageBox(getViewSite()
					.getShell(), SWT.YES | SWT.ICON_WARNING);
			alertMessageBox.setMessage("UnknownHostException Trap send "
					+ e1.getMessage());
			alertMessageBox.open();
		} catch (SnmpV3ConfigurationException e1) {
			logger.warning(e1.getMessage());
			e1.printStackTrace();

			MessageBox alertMessageBox = new MessageBox(getViewSite()
					.getShell(), SWT.YES | SWT.ICON_WARNING);
			alertMessageBox
					.setMessage("SnmpV3ConfigurationException Trap send "
							+ e1.getMessage());
			alertMessageBox.open();
		} catch (GeneralSecurityException e1) {
			logger.warning(e1.getMessage());
			e1.printStackTrace();

			MessageBox alertMessageBox = new MessageBox(getViewSite()
					.getShell(), SWT.YES | SWT.ICON_WARNING);
			alertMessageBox.setMessage("GeneralSecurityException Trap send "
					+ e1.getMessage());
			alertMessageBox.open();
		} catch (SnmpBadValueException e1) {
			logger.warning(e1.getMessage());
			e1.printStackTrace();

			MessageBox alertMessageBox = new MessageBox(getViewSite()
					.getShell(), SWT.YES | SWT.ICON_WARNING);
			alertMessageBox.setMessage("Abort Trap send " + e1.getMessage());
			alertMessageBox.open();
		} catch (IOException e1) {
			logger.warning(e1.getMessage());
			e1.printStackTrace();

			MessageBox alertMessageBox = new MessageBox(getViewSite()
					.getShell(), SWT.YES | SWT.ICON_WARNING);
			alertMessageBox.setMessage("Abort Trap send " + e1.getMessage());
			alertMessageBox.open();
		} finally {
			sendTrapRepeatCounterText.setText("1");
		}
	}

	/*
	 * TrapMPDU𐶐ĕԂ܂B
	 * 
	 * @param hostAddress MAhX @param community R~jeB @return SnmpSequence
	 * TrapMPDU
	 */
	private SnmpSequence createTrapPDU(String hostAddress, String community) {
		SnmpSequence trapPDUSequence = null;
		int selectVersion = snmpVersionComboBox.getSelectionIndex();
		logger.info("selectVersion : " + selectVersion);

		AgentTrapPDU trapPdu = AgentTrapPDU.getInstance();
		String additionalVariableOID = additionalVariableOIDText.getText();

		String valueString = valueAdditionalVariableText.getText();
		String valueTypeString = snmpValueTypeCombo.getText();

		/*
		 * Trap V2psnmpTrapOIDIComboBoxIԍ OID擾
		 */
		int indexSeletcSnmpTrapOID = snmpTrapOIDValueComboBox
				.getSelectionIndex();
		String snmpTrapOIDValueOid = (String) snmpTrapOidValueList
				.get(indexSeletcSnmpTrapOID);

		/*
		 * SNMP VersionɑΉTrap PDU
		 */
		try {
			switch (selectVersion) {
			case 0: // SNMP Ver.1

				/*
				 * Specific Trap code`FbN
				 */
				int specificTrap = 0;

				try {
					specificTrap = Integer
							.parseInt(specificTrapCombo.getText());
				} catch (NumberFormatException e2) {
					Shell shell = new Shell();
					MessageBox alertMessageBox = new MessageBox(shell, SWT.YES
							| SWT.ICON_WARNING);

					alertMessageBox.setMessage("Illegal Specific Trap code");
					alertMessageBox.open();
					specificTrapCombo.setFocus();
					shell.dispose();

					return null;
				}

				version = SnmpPreference.SNMP_VERSION_1;

				/*
				 * Agent Address`FbN
				 */
				String agentIPAddressString = agentIPAddressText.getText();
				String agentIPAddress = "";

				try {
					InetAddress host = InetAddress
							.getByName(agentIPAddressString);
					agentIPAddress = host.getHostAddress();
				} catch (UnknownHostException e2) {
					Shell shell = new Shell();
					MessageDialog.openError(shell, "Error",
							"UnknownHostException" + " Agent IP Address = "
									+ agentIPAddressText.getText());
					shell.dispose();
					agentIPAddressText.setFocus();

					return null;
				}

				String enterpriseOidString = enterpriseOidCombo.getText();

				String enterpriseOID = ENTERPRISE_OID;
				Pattern pattern;
				String[] item;
				pattern = Pattern.compile("[ \t]"); // 󔒂܂̓^u

				item = pattern.split(enterpriseOidString, 2);
				if (item == null || item.length < 1 || item[0] == null || item[0].equals("")) {
					Shell shell = new Shell();
					MessageDialog.openError(shell, "Error", "Illegal"
							+ " Enterprise Oid = "
							+ enterpriseOidCombo.getText());
					shell.dispose();
					enterpriseOidCombo.setFocus();

					return null;
				}
				if (item.length >= 1) {
					enterpriseOID = item[0];
					System.out.println("item[0] " + item[0]);
				}

				int genericTrap = genericTrapCombo.getSelectionIndex();

				trapPDUSequence = trapPdu.createV1TrapPDU(agentIPAddress,
						enterpriseOID, genericTrap, specificTrap,
						additionalVariableOID, valueString, valueTypeString);

				logger.info("Sent trap to " + targetIPText.getText());

				logger.info("  enterprise OID:     "
						+ ((SnmpTrapPDU) trapPDUSequence).getEnterpriseOID()
								.toString());
				logger.info("  agent address:      "
						+ ((SnmpTrapPDU) trapPDUSequence).getAgentAddress()
								.toString());
				logger.info("  generic trap:       "
						+ ((SnmpTrapPDU) trapPDUSequence).getGenericTrap());
				logger.info("  specific trap:      "
						+ ((SnmpTrapPDU) trapPDUSequence).getSpecificTrap());
				logger.info("  timestamp:          "
						+ ((SnmpTrapPDU) trapPDUSequence).getTimestampData());
				logger.info("  supplementary vars: "
						+ ((SnmpTrapPDU) trapPDUSequence).getVarBindList()
								.toString());

				break;

			case 1: // SNMP Ver.2
				version = SnmpPreference.SNMPV2C;
				trapPDUSequence = trapPdu.createV2Trap2PDU(snmpTrapOIDValueOid,
						additionalVariableOID, valueString, valueTypeString);

				break;

			case 2: // SNMP Ver.3
				version = SnmpPreference.SNMPV3;
				trapPDUSequence = trapPdu.createV3Trap2PDU(snmpTrapOIDValueOid,
						additionalVariableOID, valueString, valueTypeString);

				break;

			default:
				logger
						.warning("Snmp Version : "
								+ snmpValueTypeCombo.getText());
				version = SnmpPreference.SNMP_VERSION_1;
			}

			logger.info("Trap send execute Version : "
					+ snmpValueTypeCombo.getText());
		} catch (SnmpBadValueException e1) {
			logger.warning(e1.getMessage());
			e1.printStackTrace();

			MessageBox alertMessageBox = new MessageBox(getViewSite()
					.getShell(), SWT.YES | SWT.ICON_WARNING);
			alertMessageBox.setMessage("Abort Trap send " + e1.getMessage());
			alertMessageBox.open();
		}

		return trapPDUSequence;
	}

	/*
	 * SNMP Trap OIDIComboBoxZbg܂B
	 * 
	 * @param composite Composite
	 */
	private void setSnmpTrapOIDValueComboBox(Composite composite) {
		/*
		 * snmpTrapOIDpairƂȂOIDIComboBox
		 */
		snmpTrapOIDValueComboBox = new Combo(composite, SWT.DROP_DOWN
				| SWT.READ_ONLY);
		snmpTrapOIDValueComboBox.add(DEFAULT_VAR_BIND_OID_DESC + "("
				+ DEFAULT_VAR_BIND_OID + ")");
		snmpTrapOIDValueComboBox.add("coldStart("
				+ SnmpPreference.COLDSTART_OID + ")");
		snmpTrapOIDValueComboBox.add("warmStart("
				+ SnmpPreference.WARMSTART_OID + ")");
		snmpTrapOIDValueComboBox.add("linkDown(" + SnmpPreference.LINKDOWN_OID
				+ ")");
		snmpTrapOIDValueComboBox.add("linkUp(" + SnmpPreference.LINKUP_OID
				+ ")");
		snmpTrapOIDValueComboBox.add("authenticationFailure("
				+ SnmpPreference.AUTHENTICATIONFAILURE_OID + ")");
		snmpTrapOIDValueComboBox.add("egpNeiborLoss("
				+ SnmpPreference.EGPNEIGHBORLOS_OID + ")");

		/*
		 * snmpTrapOIDpairƂȂOIDIComboBox IԍɑΉOIDli[ListZbg
		 */
		snmpTrapOidValueList.add(DEFAULT_VAR_BIND_OID);
		snmpTrapOidValueList.add(SnmpPreference.COLDSTART_OID);
		snmpTrapOidValueList.add(SnmpPreference.WARMSTART_OID);
		snmpTrapOidValueList.add(SnmpPreference.LINKDOWN_OID);
		snmpTrapOidValueList.add(SnmpPreference.LINKUP_OID);
		snmpTrapOidValueList.add(SnmpPreference.AUTHENTICATIONFAILURE_OID);
		snmpTrapOidValueList.add(SnmpPreference.EGPNEIGHBORLOS_OID);
		snmpTrapOIDValueComboBox.select(0);

		GridData gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN3;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		snmpTrapOIDValueComboBox.setLayoutData(gridData);

		snmpTrapOIDValueComboBox.setEnabled(false);
	}

	/*
	 * SNMPIuWFNg^CvIComboBoxZbg܂B
	 * 
	 * @param composite Composite
	 */
	private void setSnmpValueTypeCombo(Composite composite) {
		snmpValueTypeCombo = new Combo(composite, SWT.DROP_DOWN | SWT.READ_ONLY);
		snmpValueTypeCombo.add(SnmpBERCodec.SNMPINTEGER);
		snmpValueTypeCombo.add(SnmpBERCodec.SNMPCOUNTER32);
		snmpValueTypeCombo.add(SnmpBERCodec.SNMPCOUNTER64);
		snmpValueTypeCombo.add(SnmpBERCodec.SNMPGAUGE32);
		snmpValueTypeCombo.add(SnmpBERCodec.SNMPOCTETSTRING);
		snmpValueTypeCombo.add(SnmpBERCodec.SNMPIPADDRESS);
		snmpValueTypeCombo.add(SnmpBERCodec.SNMPNSAPADDRESS);
		snmpValueTypeCombo.add(SnmpBERCodec.SNMPOBJECTIDENTIFIER);
		snmpValueTypeCombo.add(SnmpBERCodec.SNMPTIMETICKS);
		snmpValueTypeCombo.add(SnmpBERCodec.SNMPUINTEGER32);
		snmpValueTypeCombo.add(SnmpBERCodec.SNMPBITSTRING);
		snmpValueTypeCombo.add(SnmpBERCodec.SNMPOPAQUE);
		snmpValueTypeCombo.select(0);

		GridData gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN3;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		snmpValueTypeCombo.setLayoutData(gridData);
	}

	/*
	 * GenericTrapIComboBoxZbg܂B
	 * 
	 * @param composite Composite
	 */
	private void setGenericTrapCombo(Composite composite) {
		Label label = new Label(composite, SWT.NONE);
		label.setText("Generic-trap");
		label.setLayoutData(new GridData());

		genericTrapCombo = new Combo(composite, SWT.DROP_DOWN | SWT.READ_ONLY);
		genericTrapCombo.add(COLDSTART);
		genericTrapCombo.add(WARMSTART);
		genericTrapCombo.add(LINKDOWN);
		genericTrapCombo.add(LINKUP);
		genericTrapCombo.add(AUTHENTICATIONFAILURE);
		genericTrapCombo.add(EGPNEIBORLOSS);
		genericTrapCombo.add(ENTERPRISE_SPECIFIC);

		GridData gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		genericTrapCombo.setLayoutData(gridData);

		genericTrapCombo.select(0);
	}

	/*
	 * SpecificTrapComboZbg܂B
	 * 
	 * @param composite Composite
	 */
	private void setSpecificTrapCombo(Composite composite) {
		Label label = new Label(composite, SWT.NONE);
		label.setText("Specific-trap");
		label.setLayoutData(new GridData());

		specificTrapCombo = new Combo(composite, SWT.DROP_DOWN);
		specificTrapCombo.add("0");
		specificTrapCombo.add("1");
		specificTrapCombo.add("2");
		specificTrapCombo.add("3");
		specificTrapCombo.add("4");
		specificTrapCombo.add("5");

		GridData gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = 100;
		specificTrapCombo.setLayoutData(gridData);
		specificTrapCombo.setText("0");
	}

	/*
	 * SNMPo[WIComboBoxIłB
	 * 
	 */
	private void selectSnmpVersionComboBox() {
		int index = snmpVersionComboBox.getSelectionIndex();

		switch (index) {
		case 0:

			/* Snmp Ver.1 */
			snmpTrapOIDText.setEditable(false);
			snmpTrapOIDValueComboBox.setEnabled(false);
			agentIPAddressText.setEnabled(true);
			enterpriseOidCombo.setEnabled(true);
			genericTrapCombo.setEnabled(true);
			specificTrapCombo.setEnabled(true);

			break;

		case 1:

			/* Snmp Ver.2 */
			snmpTrapOIDText.setEditable(true);
			snmpTrapOIDValueComboBox.setEnabled(true);
			agentIPAddressText.setEnabled(false);
			enterpriseOidCombo.setEnabled(false);
			genericTrapCombo.setEnabled(false);
			specificTrapCombo.setEnabled(false);

			break;

		case 2:

			/* Snmp Ver.3 */
			snmpTrapOIDText.setEditable(true);
			snmpTrapOIDValueComboBox.setEnabled(true);
			agentIPAddressText.setEnabled(false);
			enterpriseOidCombo.setEnabled(false);
			genericTrapCombo.setEnabled(false);
			specificTrapCombo.setEnabled(false);

			break;

		default:
			logger.warning("Illegal SNMP Version Index " + index);
		}
	}

	/*
	 * Local AddressԂ܂B
	 * 
	 * @return addr Loacl Address
	 */
	private String getLocalAddress() {
		String addr = DEFAULT_AGENT_ADDRESS;

		try {
			InetAddress localAddress = InetAddress.getLocalHost();
			addr = localAddress.getHostAddress();
		} catch (UnknownHostException e) {
			logger.warning("UnknownHostException " + e.getMessage());
		}

		return addr;
	}

	/**
	 * Trap additionalVariableOID TextԂ܂B
	 * 
	 * @return additionalVariableOIDText Trap additionalVariableOID Text
	 */
	public Text getAdditionalVariableOIDText() {
		return additionalVariableOIDText;
	}

	/**
	 * Trap valueAdditionalVariable TextԂ܂B
	 * 
	 * @return valueAdditionalVariableText Trap valueAdditionalVariable Text
	 */
	public Text getValueAdditionalVariableText() {
		return valueAdditionalVariableText;
	}

	/**
	 * SNMPIuWFNgTypeICombo BoxԂ܂
	 * 
	 * @return snmpValueTypeCombo SNMPIuWFNgTypeICombo Box
	 */
	public Combo getSnmpValueTypeCombo() {
		return snmpValueTypeCombo;
	}

	/**
	 * Trap additional Variable OID Discriprion TextԂ܂B
	 * 
	 * @return additionalVariableOIDDiscriprionText Trap additional Variable OID
	 *         Discriprion Text
	 */
	public Text getAdditionalVariableOIDDiscriprionText() {
		return additionalVariableOIDDescriprionText;
	}

	/**
	 * SNMP Trap OID ComboBoxԂ܂B
	 * 
	 * @return snmpTrapOIDValueComboBox SNMP Trap OID ComboBox
	 */
	public Combo getSnmpTrapOIDValueComboBox() {
		return snmpTrapOIDValueComboBox;
	}

	/**
	 * SNMP Trap Oid ListԂ܂B
	 * 
	 * @return snmpTrapOidValueList SNMP Trap Oid List
	 */
	public List getSnmpTrapOidValueList() {
		return snmpTrapOidValueList;
	}

	/**
	 * SNMP Trap Oid Listݒ肵܂B
	 * 
	 * @param snmpTrapOidValueList
	 *            SNMP Trap Oid List
	 */
	public void setSnmpTrapOidValueList(final List snmpTrapOidValueList) {
		this.snmpTrapOidValueList = snmpTrapOidValueList;
	}
}
