/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpagent;

import java.util.logging.Logger;

import netjfwatcher.snmp.mibtree.ManagerMibTree;
import netjfwatcher.snmp.mibtree.MibInfo;
import netjfwatcher.snmpagent.model.AgentMIBCountUpThread;
import netjfwatcher.snmpagent.model.AgentThreadInfo;
import netjfwatcher.snmpagent.model.AgentThreadInfoMap;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;



/**
 * SNMP AgentɂāACX^Xf[^IɑXbh
 * 𐧌䂷邽߂̑ViewNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class AgentInstanceControlOperationView extends AbstractAgentView {
    /* Text */
    private static final int TEXT_WIDTH = 200;

    /* List */
    private static final int LIST_WIDTH = 200;

    /* List verticalSpan */
    private static final int LIST_VERTICAL_SPAN = 7;

    /* List heightHint */
    private static final int LIST_HEIGHT_HINT = 5;

    /* MO */
    private static Logger logger;

    /* Scroll CompositeTCY */
    private static final int[] SCROLL_COMPOSITE_SIZE = { 800, 300 };

    /* Snmp AgentCX^Xf[^䒆̃XbhXg */
    private List threadList;

    /* CX^XOID\Text */
    private Text oidText;

    /* CX^XOID Description\Text */
    private Text descriptionText;

    /* CX^XOIDl\Text */
    private Text valueText;

    /* CX^XOID^Cv\Text */
    private Text typeText;

    /* CX^XOID Access\Text */
    private Text accessText;

    /* JEg */
    private Text periodText;

    /* l */
    private Text countUpValueText;

    /* Jn{^ */
    private Button startButton;

    /* ~{^ */
    private Button stopButton;

    /* CX^XeLXg\BackGroundFi[ */
    private Color textBackColor;

    /**
     * PartControl𐶐܂B
     *
     * @param parent Composite
     */
    public void createPartControl(Composite parent) {
        logger = Logger.getLogger(this.getClass().getName());

        textBackColor = whiteColor;

        /*
         * eCompositezueLayout
         * ieCompositec1ɔzuj
         */
        ScrolledComposite scrollComposite =
            new ScrolledComposite(parent, SWT.H_SCROLL | SWT.V_SCROLL);

        GridLayout layout = new GridLayout(1, false);
        scrollComposite.setLayout(layout);

        GridData gridData = null;

        GridLayout gridLayout0 = new GridLayout(1, false);
        Composite baseComposite = new Composite(scrollComposite, SWT.NULL);

        baseComposite.setLayout(gridLayout0);
        baseComposite.setLayoutData(
            new GridData(GridData.HORIZONTAL_ALIGN_FILL));

        /*
         * Snmp V3 AgentAhXAOIDȂǂzuComposite
         */
        GridLayout gridLayout = new GridLayout(4, false);
        Composite composite = new Composite(baseComposite, SWT.NULL);

        composite.setLayout(gridLayout);
        composite.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
        gridData = new GridData();

        Label label = new Label(composite, SWT.NONE);
        label.setText("OID");
        label.setLayoutData(new GridData());
        oidText = new Text(composite, SWT.BORDER);
        oidText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        oidText.setEnabled(false);
        oidText.setBackground(textBackColor);
        oidText.setLayoutData(gridData);

        /* dummy */
        label = new Label(composite, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite, SWT.NONE);
        label.setText("Thread List");
        label.setLayoutData(new GridData());

        label = new Label(composite, SWT.NONE);
        label.setText("Description");
        label.setLayoutData(new GridData());

        descriptionText = new Text(composite, SWT.BORDER);
        descriptionText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        descriptionText.setEnabled(false);
        descriptionText.setBackground(textBackColor);
        descriptionText.setLayoutData(gridData);

        /* dummy */
        label = new Label(composite, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        threadList = new List(composite, SWT.SINGLE | SWT.BORDER);

        GridData data = new GridData(GridData.FILL_BOTH);
        data.horizontalSpan = 1;
        data.verticalSpan = LIST_VERTICAL_SPAN;
        data.widthHint = LIST_WIDTH;
        data.heightHint = threadList.getItemHeight() * LIST_HEIGHT_HINT;
        threadList.setLayoutData(data);

        label = new Label(composite, SWT.NONE);
        label.setText("Value");
        label.setLayoutData(new GridData());

        valueText = new Text(composite, SWT.BORDER);
        valueText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        valueText.setEnabled(false);
        valueText.setBackground(textBackColor);
        valueText.setLayoutData(gridData);

        /* dummy */
        label = new Label(composite, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite, SWT.NONE);
        label.setText("Type");
        label.setLayoutData(new GridData());

        typeText = new Text(composite, SWT.BORDER);
        typeText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        typeText.setEnabled(false);
        typeText.setBackground(textBackColor);
        typeText.setLayoutData(gridData);

        /* dummy */
        label = new Label(composite, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite, SWT.NONE);
        label.setText("Access");
        label.setLayoutData(new GridData());

        accessText = new Text(composite, SWT.BORDER);
        accessText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        accessText.setEnabled(false);
        accessText.setBackground(textBackColor);
        accessText.setLayoutData(gridData);

        /* dummy */
        label = new Label(composite, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite, SWT.NONE);
        label.setText("Period(Sec)");
        label.setLayoutData(new GridData());

        periodText = new Text(composite, SWT.BORDER);
        periodText.setText("60");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        periodText.setLayoutData(gridData);

        /* dummy */
        label = new Label(composite, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        label = new Label(composite, SWT.NONE);
        label.setText("Count up value");
        label.setLayoutData(new GridData());

        countUpValueText = new Text(composite, SWT.BORDER);
        countUpValueText.setText("10");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        countUpValueText.setLayoutData(gridData);

        /* dummy */
        label = new Label(composite, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);

        GridLayout gridLayout2 = new GridLayout(2, false);
        Composite compositeBottonAndCommunity =
            new Composite(baseComposite, SWT.NONE);
        compositeBottonAndCommunity.setLayoutData(
            new GridData(GridData.HORIZONTAL_ALIGN_FILL));
        compositeBottonAndCommunity.setLayout(gridLayout2);

        startButton = new Button(compositeBottonAndCommunity, SWT.NONE);
        startButton.setText("Thread Start");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        startButton.setLayoutData(gridData);

        stopButton = new Button(compositeBottonAndCommunity, SWT.NONE);
        stopButton.setText("Thread Stop");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;

        stopButton.setLayoutData(gridData);
        stopButton.setEnabled(false);

        scrollComposite.setContent(baseComposite);
        scrollComposite.setMinSize(
            SCROLL_COMPOSITE_SIZE[0], SCROLL_COMPOSITE_SIZE[1]);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);

        /*
         * ThreadX^[g{^ɂOIDCX^X
         * ThreadN܂B
         *
         */
        startButton.addSelectionListener(
            new SelectionListener() {
                public void widgetSelected(SelectionEvent event) {
                    stopButton.setEnabled(false);

                    /* OIDl`FbN */
                    if (oidText.getText().equals("")) {
                        MessageBox alertMessageBox =
                            new MessageBox(
                                getSite().getShell(), SWT.YES
                                | SWT.ICON_WARNING);

                        alertMessageBox.setMessage("Illegal OID");
                        alertMessageBox.open();
                        oidText.setFocus();

                        return;
                    }

                    if (valueText.getText().equals("")) {
                        MessageBox alertMessageBox =
                            new MessageBox(
                                getSite().getShell(), SWT.YES
                                | SWT.ICON_WARNING);

                        alertMessageBox.setMessage("Illegal OID value");
                        alertMessageBox.open();
                        valueText.setFocus();

                        return;
                    }

                    String oidType = typeText.getText();

                    if (
                        !oidType.equals(ManagerMibTree.INTEGER)
                            && !oidType.equals(ManagerMibTree.COUNTER32)
                            && !oidType.equals(ManagerMibTree.COUNTER64)
                            && !oidType.equals(ManagerMibTree.GAUGE32)
                            && !oidType.equals(ManagerMibTree.UINTEGER32)) {
                        MessageBox alertMessageBox =
                            new MessageBox(
                                getSite().getShell(), SWT.YES
                                | SWT.ICON_WARNING);

                        alertMessageBox.setMessage(
                            "Illegal OID Type : " + oidType);
                        alertMessageBox.open();
                        valueText.setFocus();

                        return;
                    }

                    try {
                        Integer.parseInt(valueText.getText());
                    } catch (NumberFormatException e2) {
                        MessageBox alertMessageBox =
                            new MessageBox(
                                getSite().getShell(), SWT.YES
                                | SWT.ICON_WARNING);

                        alertMessageBox.setMessage("Illegal OID value");
                        alertMessageBox.open();
                        valueText.setFocus();

                        return;
                    }

                    /* ThreadZbg */
                    int period = 0;

                    try {
                        period = Integer.parseInt(periodText.getText());
                    } catch (NumberFormatException e2) {
                        MessageBox alertMessageBox =
                            new MessageBox(
                                getSite().getShell(), SWT.YES
                                | SWT.ICON_WARNING);

                        alertMessageBox.setMessage("Illegal period value");
                        alertMessageBox.open();
                        periodText.setFocus();

                        return;
                    }

                    if (period < 60) {
                        MessageBox alertMessageBox =
                            new MessageBox(
                                getSite().getShell(), SWT.YES
                                | SWT.ICON_WARNING);

                        alertMessageBox.setMessage(
                            "Please set count period >= 60");
                        alertMessageBox.open();
                        periodText.setFocus();

                        return;
                    }

                    /* CX^Xf[^l */
                    int countData = 0;

                    try {
                        countData =
                            Integer.parseInt(countUpValueText.getText());
                    } catch (NumberFormatException e2) {
                        MessageBox alertMessageBox =
                            new MessageBox(
                                getSite().getShell(), SWT.YES
                                | SWT.ICON_WARNING);

                        alertMessageBox.setMessage("Illegal count up value");
                        alertMessageBox.open();
                        countUpValueText.setFocus();

                        return;
                    }

                    /*
                     * MIB Count Up Thread
                     */
                    createAgentMIBCountUpThread(period, countData);

                    stopButton.setEnabled(false);
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });

        /*
         * 쒆̃Xbh~Ej܂B
         */
        stopButton.addSelectionListener(
            new SelectionListener() {
                public void widgetSelected(SelectionEvent event) {
                    int index = threadList.getSelectionIndex();

                    /* ThreadIL`FbN */
                    if (index != -1) {
                        AgentThreadInfo threadInfo =
                            AgentThreadInfoMap.getInstance()
                                              .getAgentInstanceInfo(
                                threadList.getItem(index));

                        /* ThraedɊ荞ThreadI */
                        threadInfo.getAgentThread().interrupt();

                        /* Xg폜 */
                        threadList.remove(index);
                        threadList.redraw();

                        stopButton.setEnabled(false);
                        logger.info(
                            "Thread stop oid="
                            + threadInfo.getAgentThreadControl().getOidInfo()
                                        .getOid() + "("
                            + threadInfo.getAgentThreadControl().getOidInfo()
                                        .getDescrip() + ")");
                    }
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });

        /*
         * Snmp AgentCX^X䒆ThreadXgIXi[ŁA
         * IꂽThread̏eLXgɕ\܂B
         *
         */
        threadList.addSelectionListener(
            new SelectionAdapter() {
                public void widgetSelected(SelectionEvent event) {
                    // IIndex擾
                    int index = threadList.getSelectionIndex();

                    /* IIndexThread擾 */
                    AgentThreadInfo threadInfo =
                        AgentThreadInfoMap.getInstance().getAgentInstanceInfo(
                            threadList.getItem(index));

                    if (threadInfo == null) {
                        return;
                    }

                    // IꂽXbhOIDCX^X擾
                    MibInfo oidInfo =
                        threadInfo.getAgentThreadControl().getOidInfo();

                    // OIDtextɕ\
                    oidText.setText(oidInfo.getOid());

                    // OIDCX^X̐textɕ\
                    descriptionText.setText(oidInfo.getDescrip());

                    // OIDCX^X̃^Cvtextɕ\
                    valueText.setText(oidInfo.getValue());

                    // OIDCX^X̒ltextɕ\
                    typeText.setText(oidInfo.getSyntax());

                    // OIDCX^X̃ANZX^Cvtextɕ\
                    accessText.setText(oidInfo.getAccess());

                    // Text\
                    periodText.setText(
                        Integer.toString(
                            threadInfo.getAgentThreadControl().getPeriod()));

                    // lText\
                    countUpValueText.setText(
                        Integer.toString(
                            threadInfo.getAgentThreadControl().getIncrementData()));
                    stopButton.setEnabled(true);
                }
            });
    }

    /**
     * SNMP AgnetCX^Xf[^őThread
     * EN܂B
     *
     * @param period JEg
     * @param countData l
     */
    private void createAgentMIBCountUpThread(int period, int countData) {
        /* CX^X̃JEgAbvThread */
        AgentMIBCountUpThread agentCountUpThread =
            new AgentMIBCountUpThread(oidText.getText(), period, countData);

        /* CX^X̃JEgAbvThreadNpThread */
        Thread thread = new Thread(agentCountUpThread);

        /*
         * ThreadOIDKeyƂMapɓo^
         */
        AgentThreadInfo threadInfo = new AgentThreadInfo();
        threadInfo.setAgentThreadControl(agentCountUpThread);
        threadInfo.setAgentThread(thread);
        AgentThreadInfoMap.getInstance().setAgentInstanceMap(
            oidText.getText(), threadInfo);

        /* 쒆Thread Listɕ\ */
        threadList.add(oidText.getText());

        /* ThreadX^[g */
        thread.start();
        logger.info(
            "Thread start oid="
            + threadInfo.getAgentThreadControl().getOidInfo().getOid() + "("
            + threadInfo.getAgentThreadControl().getOidInfo().getDescrip()
            + ")");
    }

    /**
     * AgentCX^X Access\TextԂ܂B
     *
     * @return accessText AgentCX^X Access\Text
     */
    public Text getAccessText() {
        return accessText;
    }

    /**
     * AgentCX^XOID Description\TextԂ܂B
     *
     * @return descriptionText AgentCX^XOID Description\Text
     */
    public Text getDescriptionText() {
        return descriptionText;
    }

    /**
     * AgentCX^XOID\TextԂ܂B
     *
     * @return oidText AgentCX^XOID\Text
     */
    public Text getOidText() {
        return oidText;
    }

    /**
     * AgentCX^XType\TextԂ܂B
     *
     * @return typeText AgentCX^XType\Text
     */
    public Text getTypeText() {
        return typeText;
    }

    /**
     * AgentCX^XType\TextԂ܂B
     *
     * @return valueText AgentCX^Xl\Text
     */
    public Text getValueText() {
        return valueText;
    }
}
