/*
 * Created on 2004/12/30
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.snmp.snmpobject.opaque;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.preference.SnmpBERCodec;



/**
 * ASN.1 Type(^O)ɂOPAQUE_INTEGER64(^O 0x7a)ɑΉSNMPIuWFNg
 * 𑀍삷郁\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class SnmpOpaqueInteger64 extends SnmpOpaque {
    /** l(64bits 萮) */
    private long opaqueInteger64Value;

    /**
     * <p>OpaqueInteger64Data ̃CX^X𐶐܂B</p>
     *
     * @param value l
     */
    public SnmpOpaqueInteger64(long value) {
        this.opaqueInteger64Value = value;
    }

    /**
     * <p>OpaqueInteger64Data ̃CX^X𐶐܂B</p>
     *
     * @param data byte 
     * @param offset ǂݏoJnʒu
     * @param length (oCg)
     * @throws SnmpBadValueException f[^sȏꍇɃX[܂B
     */
    public SnmpOpaqueInteger64(byte[] data, int offset, int length)
        throws SnmpBadValueException {
        opaqueInteger64Value = decode(data, offset, length);
    }

    /**
     * <p>̃IuWFNg̒l Basic Encoding Rule ɏ] byte ɕϊ܂B</p>
     *
     * @return ϊ byte 
     */
    public byte[] encode() {
        return encode(opaqueInteger64Value);
    }

    /**
     * <p>w肳ꂽ long l Basic Encoding Rule ɏ] byte ɕϊ܂B<br>
     * long l͕萮Ƃĉ߂܂B</p>
     *
     * @param value l
     * @return ϊ byte 
     */
    public byte[] encode(long value) {
        List valueList = Collections.synchronizedList(new ArrayList());

        valueList.add(new Byte((byte) ((value >> 56) & MASK_0XFF)));
        valueList.add(new Byte((byte) ((value >> 48) & MASK_0XFF)));
        valueList.add(new Byte((byte) ((value >> 40) & MASK_0XFF)));
        valueList.add(new Byte((byte) ((value >> 32) & MASK_0XFF)));
        valueList.add(new Byte((byte) ((value >> 24) & MASK_0XFF)));
        valueList.add(new Byte((byte) ((value >> 16) & MASK_0XFF)));
        valueList.add(new Byte((byte) ((value >> 8) & MASK_0XFF)));
        valueList.add(new Byte((byte) (value & MASK_0XFF)));

        byte b = ((Byte) valueList.get(0)).byteValue();

        if (b == 0) {
            for (int i = 0; i < 7; i++) {
                b = ((Byte) valueList.get(1)).byteValue();

                if (b == 0) {
                    valueList.remove(0);
                } else if (b < 0) {
                    break;
                } else {
                    valueList.remove(0);

                    break;
                }
            }
        } else if (b == (byte) 0xff) {
            for (int i = 0; i < 7; i++) {
                b = ((Byte) valueList.get(1)).byteValue();

                if (b == (byte) MASK_0XFF) {
                    valueList.remove(0);
                } else if (b < 0) {
                    valueList.remove(0);

                    break;
                } else {
                    break;
                }
            }
        }

        int length = valueList.size();
        byte[] array = new byte[5 + length];
        array[0] = (byte) 0x44;
        array[1] = (byte) (length + 3);
        array[2] = (byte) 0x9f;
        array[3] = (byte) SnmpBERCodec.OPAQUE_INTEGER64;
        array[4] = (byte) length;

        for (int i = 0; i < length; i++) {
            array[5 + i] = ((Byte) valueList.get(i)).byteValue();
        }

        valueList.clear();

        return array;
    }

    /**
     * <p>w肳ꂽ byte  Basic Encoding Rule ɏ] long lɕϊ܂B<br>
     * long l͕萮ƂėpĂB</p>
     *
     * @param data byte 
     * @param offset ǂݏoJnʒu
     * @param length (oCg)
     * @return ϊ̒l
     * @throws SnmpBadValueException f[^sȏꍇɃX[܂B
     */
    public long decode(byte[] data, int offset, int length)
        throws SnmpBadValueException {
        if (length < 1) {
            throw new SnmpBadValueException(
                new StringBuffer().append("length too short: ").append(length)
                                  .append(" < 1").toString());
        }

        if (length > 8) {
            throw new SnmpBadValueException(
                new StringBuffer().append("length too long: ").append(length)
                                  .append(" > 8").toString());
        }

        long longValue = data[offset];

        try {
            for (int i = 1; i < length; i++) {
                longValue <<= 8;
                longValue |= (data[offset + i] & MASK_0XFF);
            }
        } catch (ArrayIndexOutOfBoundsException e) {
            throw new SnmpBadValueException(e.getMessage());
        }

        return longValue;
    }

    /**
     * OpaqueIuWFNgԂ܂B
     *
     * @return obj OpaqueIuWFNg
     */
    public Object getValue() {
        Long valued = new Long(opaqueInteger64Value);

        return valued;
    }

    /**
     * OpaqueIuWFNg𕶎ɕϊĕԂ܂B
     *
     * @return 
     */
    public String toString() {
        return Long.toString(opaqueInteger64Value);

        // return sb.toString() ;
    }
}
