/*
 * Created on 2004/12/30
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.snmp.snmpobject.opaque;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.logging.Logger;

import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.preference.SnmpBERCodec;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;


/**
 * ASN.1 Type(^O)ɂOPAQUE(^O 0x44)ɑΉSNMPIuWFNg
 * 𑀍삷郁\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class SnmpOpaque extends AbstractSnmpObject {
    /** byte mask */
    public static final byte MASK_0XFF = (byte) 0xff;

    /** Opaquẽf[^ */
    public static final int LEN = 2;

    /** Opaquẽf[^ItZbgl */
    public static final int DATA = 3;

    /* MO */
    private static Logger logger;

    /* SNMP OpaqueIuWFNg */
    private AbstractSnmpObject snmpObj = null;

    /**
     * SNMP OpaqueIuWFNg𐶐܂B
     *
     */
    public SnmpOpaque() {
        logger = Logger.getLogger(this.getClass().getName());
        tag = SnmpBERCodec.SNMPOPAQUE_TAG;
        tagDescription = SnmpBERCodec.SNMPOPAQUE;
    }

    /**
     * SNMP OpaqueIuWFNgoCgz񂩂琶܂B
     *
     * @param enc oCgzf[^
     * @throws SnmpBadValueException IuWFNgɎsꍇ
     */
    public SnmpOpaque(byte[] enc) throws SnmpBadValueException {
        logger = Logger.getLogger(this.getClass().getName());
        logger.info("SnmpOpaque");
        this.extractValueFromBEREncoding(enc);
        tag = SnmpBERCodec.SNMPOPAQUE_TAG;
        tagDescription = SnmpBERCodec.SNMPOPAQUE;
    }

    /**
     * ێĂOpaqueIuWFNgASN.1 BERGR[fBOɂăoCgz
     * ϊĕԂ܂B
     *
     * @return oCgzf[^
     */
    public byte[] getBEREncoding() {
        ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
        byte[] outBytesArray = null;

        try {
            byte[] data = snmpObj.getBEREncoding();
            byte[] len = this.encodeLength(data.length);

            // encode T,L,V info
            outBytes.write(tag);
            outBytes.write(len, 0, len.length);
            outBytes.write(data, 0, data.length);

            outBytesArray = outBytes.toByteArray();
        } finally {
            try {
                outBytes.close();
            } catch (IOException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }

        return outBytesArray;
    }

    /**
     * oCgzf[^Opaque^Cv𔻕ʂΉSNMP Opaque
     * IuWFNg𐶐܂B
     *
     * @param enc oCgzf[^
     * @throws SnmpBadValueException SNMP OpaqueIuWFNg
     * sꍇ
     */
    public void extractValueFromBEREncoding(byte[] enc)
        throws SnmpBadValueException {
        if (enc[0] == (byte) 0x9f) {
            int len2 = enc[LEN];

            switch (enc[1]) {
            case (byte) SnmpBERCodec.OPAQUE_COUNTER64:
                logger.info("OPAQUE_COUNTER64");
                snmpObj = new SnmpOpaqueCounter64(enc, DATA, len2);

                break;

            case (byte) SnmpBERCodec.OPAQUE_FLOAT:
                logger.info("OPAQUE_FLOAT");
                snmpObj = new SnmpOpaqueFloat(enc, DATA, len2);

                break;

            case (byte) SnmpBERCodec.OPAQUE_DOUBLE:
                logger.info("OPAQUE_DOUBLE");
                snmpObj = new SnmpOpaqueDouble(enc, DATA, len2);

                // obj.getValue();
                break;

            case (byte) SnmpBERCodec.OPAQUE_INTEGER64:
                logger.info("OPAQUE_INTEGER64");
                snmpObj = new SnmpOpaqueInteger64(enc, DATA, len2);

                break;

            case (byte) SnmpBERCodec.OPAQUE_UNSIGNED64:
                logger.info("OPAQUE_UNSIGNED64");
                snmpObj = new SnmpOpaqueUnsigned64(enc, DATA, len2);

                break;

            default:
                logger.warning("Unknown OPAQUE type");
                throw new SnmpBadValueException("Unknown OPAQUE type");
            }
        } else {
            logger.warning("OPAQUE format error");
            throw new SnmpBadValueException("OPAQUE format error");
        }
    }

    /**
     * OpaqueIuWFNgZbg܂B
     *
     * @param newValue OpaqueIuWFNg
     * @throws SnmpBadValueException f[^ZbgɎsꍇ
     */
    public void setValue(Object newValue) throws SnmpBadValueException {
    }

    /**
     * OpaqueIuWFNgԂ܂B
     *
     * @return obj OpaqueIuWFNg
     */
    public Object getValue() {
        return snmpObj;
    }

    /**
     * OpaqueIuWFNg𕶎ɕϊĕԂ܂B
     *
     * @return returnString 
     */
    public String toString() {
        String returnString = snmpObj.toString();

        return returnString;
    }
}
