/*
 * Created on 2004/04/01
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.snmp.snmpobject.message;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import netjfwatcher.snmp.messageformat.SNMPTLV;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.preference.SnmpBERCodec;



/**
 * SNMP SequenceIuWFNg\NXŁAscopedPDUf[^
 * CX^X܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class SnmpSequenceDecrypt extends SnmpSequence {
    /**
     * ASN.1 BERGR[fBOoCgzf[^SNMP SequenceIuWFNg
     * 𐶐܂B
     *
     * @param enc ASN.1 BERGR[fBOoCgzf[^
     * @throws SnmpBadValueException SNMP SequenceIuWFNgɎsꍇ
     */
    public SnmpSequenceDecrypt(byte[] enc) throws SnmpBadValueException {
        this.extractFromBEREncodingDecrypt(enc);
        tag = SnmpBERCodec.SNMPSEQUENCE_TAG;
        tagDescription = SnmpBERCodec.SNMPSEQUENCE;
    }

    /**
     * ASN.1 BERGR[fBOoCgzf[^SNMPIuWFNg𐶐
     * Xgɕێ܂B
     *
     * @param enc ASN.1 BERGR[fBOoCgzf[^
     * @throws SnmpBadValueException SNMPIuWFNgɎsꍇ
     */
    protected void extractFromBEREncodingDecrypt(byte[] enc)
        throws SnmpBadValueException {
        List sequenceDecryptList =
            Collections.synchronizedList(new ArrayList());
        int totalLength = enc.length;
        int position = 0;
        int newPosition = enc.length;
        sequenceContentsList.clear();

        while (position < totalLength) {
            /* oCgf[^wʒuATLVNXCX^X */
            SNMPTLV nextTLV = this.extractNextTLV(enc, position);

            if (nextTLV != null) {
                if (position == 0) {
                    newPosition = nextTLV.getTotalLength();
                }

                sequenceContentsList.add(this.extractNextTLV(enc, position));

                /* contents listSNMPIuWFNgi[ */
                sequenceDecryptList.add(
                    sequenceDecryptList.size(), this.extractEncoding(nextTLV));
                position += nextTLV.getTotalLength();
            } else {
                position++;
            }

            if (position >= newPosition) {
                break;
            }
        }

        sequenceList = sequenceDecryptList;
    }
}
