/*
 * Created on 2006/06/28
 *
 *
 * Copyright(c) 2006 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.view.editorpart.nodedetect;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;

import netjfwatcher.engine.alarm.AlarmPut;
import netjfwatcher.engine.nodecontrol.NodeKind;
import netjfwatcher.engine.server.protocol.ping.PingExcecEngine;
import netjfwatcher.engine.snmpmanager.process.ManagerDispatcher;
import netjfwatcher.engine.snmpmanager.process.MibGetNextInfo;
import netjfwatcher.engine.snmpmanager.process.MibGetNextInfoQueue;
import netjfwatcher.snmp.messageformat.SnmpMIBGetException;
import netjfwatcher.snmp.messageformat.SnmpSetException;
import netjfwatcher.snmp.messageformat.SnmpVarBindList;
import netjfwatcher.snmp.preference.SnmpBERCodec;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;
import netjfwatcher.snmp.snmpobject.message.SnmpObjectIdentifier;
import netjfwatcher.snmp.snmpobject.message.SnmpSequence;
import netjfwatcher.snmp.snmpv3.SnmpV3AuthAbortException;
import netjfwatcher.snmp.snmpv3.SnmpV3ConfigurationException;
import netjfwatcher.snmp.snmpv3.SnmpV3DecryptAbortException;


/**
 * m[h̎oThraedNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class ThreadAutoNodeDetect implements Runnable {
    /* MO */
    private static Logger logger;


    /* m[hIPAhX͈̓Xg */
    private ArrayList checkNodeAddressList;
    private ArrayList pingOKList = new ArrayList();
    private ArrayList pingNGList = new ArrayList();
    private ArrayList snmpOKList = new ArrayList();
    private ArrayList snmpNGList = new ArrayList();
    private ArrayList snmpIFOKList = new ArrayList();
    private ArrayList snmpIFNGList = new ArrayList();
    private ArrayList snmpPrintOKList = new ArrayList();
    private ArrayList snmpPrintNGList = new ArrayList();
    
    /* SNMP sysDescm[hʂ𔻕ʂłm[hIPAhXMap */
    private HashMap nodeKindMap = new HashMap();

    /* m[hThread */
    private Thread nodeDiscoveryThread;

    /* m[hop[^l */
    private String timeoutMilliSecParam = "1000";
    private String retryParam = "1";
    private String snmpROCommunity = "public";
    private int snmpVersion = 0;

    /* m[hThreadLZtO */
    private boolean isDiscoveryNoCancel;

    /* pingsGW */
    private PingExcecEngine execPingInstance;

    /* sysDescɊ܂܂镶KeyƂăm[hʖێMap */
    private HashMap nodeDectMap;

    /**
     * PingsCX^X𐶐܂B
     *
     */
    private ThreadAutoNodeDetect() {
        logger = Logger.getLogger(this.getClass().getName());
        nodeDectMap = NodeDetectFile.getInstance().getNodeDetectMap();
    }

    /**
     * m[hThraedX^[g܂B
     *
     * @param checkNodeAddressList m[hAhXXg
     */
    public synchronized void startThread(ArrayList checkNodeAddressList) {
        this.checkNodeAddressList = checkNodeAddressList;
        isDiscoveryNoCancel = true;
        resetNodeDetect();
        nodeDiscoveryThread = new Thread(getInstance());
        nodeDiscoveryThread.start();
    }

    /**
     * Thared~܂B
     *
     */
    public synchronized void stopThread() {
        isDiscoveryNoCancel = false;
    }

    /*
     * ێĂem[hAhXXgNA܂B
     *
     */
    private void resetNodeDetect() {
        pingOKList.clear();
        pingNGList.clear();
        snmpOKList.clear();
        snmpNGList.clear();
        snmpIFOKList.clear();
        snmpIFNGList.clear();
        nodeKindMap.clear();
        snmpPrintOKList.clear();
        snmpPrintNGList.clear();
    }

    /**
     * m[h𔭌܂B
     */
    public void run() {
        execPingInstance = new PingExcecEngine(timeoutMilliSecParam, retryParam);
        /* m[hsŃA[ƂȂ */
        AlarmPut.getInstance().setNodeDiscovery(true);

        for (int i = 0; i < checkNodeAddressList.size(); i++) {
            if (!isDiscoveryNoCancel) {
                /* m[hThread~w */
                break;
            }

            executePing((String) checkNodeAddressList.get(i));
        }

        /* m[hsŃA[ƂȂtOLZZbg */
        AlarmPut.getInstance().setNodeDiscovery(false);
    }

    /*
     * PingsAʂmFăf[^x[XɊi[܂B
     *
     * @param targetIPAddress  PingsΏIPAhX
     */
    private void executePing(String targetIPAddress) {
        /* PingsIPAhXZbg */
        execPingInstance.setTargetIPAddress(targetIPAddress);

        /* PingsԃftHglZbg */
        long diffTime = -1;

        if (execPingInstance.checkPingResponse()) {
            /* ԃ`FbN */
            diffTime = execPingInstance.getDifftime();

            /*
             * PingԂ臒lȓŐȏꍇ
             */
            diffTime = execPingInstance.getDifftime();

            checkSnmp(targetIPAddress, snmpVersion, snmpROCommunity);
           
            pingOKList.add(targetIPAddress);
        } else {
            /* ȉȂꍇiTimeout܂ށj */
            diffTime = execPingInstance.getDifftime();
            pingNGList.add(targetIPAddress);
        }
    }

    /*
     * m[hSNMP`FbN
     *
     * @param targeIP m[hIPAhX
     * @param version SNMPo[W
     * @param community SNMP ReadR~jeB
     */
    private void checkSnmp(
        final String targeIP, final int version, final String community) {
        try {
            String returnOID =
                getNodeMIB(targeIP, NodeDetectPreference.SYS_DESCRIPTOR_OID, version, community, true);

            if (returnOID.indexOf(NodeDetectPreference.SYS_DESCRIPTOR_OID) >= 0) {
                snmpOKList.add(targeIP);

                returnOID =
                    getNodeMIB(targeIP, NodeDetectPreference.IFNUMBER_OID, version, community, true);

                if (returnOID.indexOf(NodeDetectPreference.IFNUMBER_OID) >= 0) {
                    snmpIFOKList.add(targeIP);
                } else {
                    snmpIFNGList.add(targeIP);
                }
                checkPrintSnmp(targeIP, snmpVersion, snmpROCommunity);
            } else {
                snmpNGList.add(targeIP);
            }
        } catch (SnmpMIBGetException e) {
            snmpNGList.add(targeIP);
        }
    }

    private void checkPrintSnmp(
            final String targeIP, final int version, final String community) {
            try {
                String hrDeviceTypeVale =
                    getNodeMIB(targeIP, NodeDetectPreference.HR_DEVICE_TYPE_OID, version, community, false);

                if (hrDeviceTypeVale != null && hrDeviceTypeVale.indexOf(NodeDetectPreference.HRDEVICE_PRINTER_OID) >= 0) {
                	snmpPrintOKList.add(targeIP);
                	nodeKindMap.put(targeIP, NodeKind.PRINTER);
                } else {
                	snmpPrintNGList.add(targeIP);
                }
            } catch (SnmpMIBGetException e) {
            	snmpPrintNGList.add(targeIP);
            }
        }
    /*
     * m[hSNMP MIB̎
     *
     * @param targetIP m[hIPAhX
     * @param oid ̎OID
     * @param version SNMPo[W
     * @param community ReadR~jeB
     * @return ̎OID
     * @throws SnmpMIBGetException m[hMIB̎Ɏsꍇ
     */
    private String getNodeMIB(
        final String targetIP, final String oid, final int version,
        final String community, final boolean isOIDReturn) throws SnmpMIBGetException {
        MibGetNextInfo mibGetInstance = null;
        String returnOID = "";
        AbstractSnmpObject responseValue = null;
        ManagerDispatcher dispacher = null;

        try {
            String returnOid = oid;
            dispacher = new ManagerDispatcher();

            dispacher.setManagerDispatcher(targetIP, community, version);

            SnmpVarBindList newVars =
                dispacher.dispathGetMessage(
                    version, SnmpBERCodec.SNMPGETNEXTREQUEST, returnOid);

            SnmpSequence responsePair =
                (SnmpSequence) (newVars.getSNMPObjectAt(0));
            SnmpObjectIdentifier responseOID =
                (SnmpObjectIdentifier) responsePair.getSNMPObjectAt(0);

            responseValue = responsePair.getSNMPObjectAt(1);
            returnOID = responseOID.toString();
            if(oid.equals(NodeDetectPreference.SYS_DESCRIPTOR_OID)) {
            	/* m[hʔ */
            	autoDetectNodeKind(targetIP, responseValue.toString());
            }
        } catch (SnmpV3AuthAbortException e) {
            logger.warning(e.getMessage() + " :IP=" + targetIP);
            throw new SnmpMIBGetException(e.getMessage());
        } catch (SnmpV3DecryptAbortException e) {
            logger.warning(e.getMessage() + " :IP=" + targetIP);
            throw new SnmpMIBGetException(e.getMessage());
        } catch (SnmpMIBGetException e) {
            logger.warning(e.getMessage() + " :IP=" + targetIP);
            throw e;
        } catch (SnmpSetException e) {
            logger.warning(e.getMessage() + " :IP=" + targetIP);
            throw new SnmpMIBGetException(e.getMessage());
        } catch (SnmpV3ConfigurationException e) {
            logger.warning(e.getMessage() + " :IP=" + targetIP);
            throw new SnmpMIBGetException(e.getMessage());
        } catch (Exception e) {
            logger.warning(e.getMessage() + " :IP=" + targetIP);
            throw new SnmpMIBGetException(e.getMessage());
        } finally {
            if (mibGetInstance != null) {
                MibGetNextInfoQueue.getInstance().releaseMibGetInstance(
                    targetIP, Thread.currentThread().getName());
            }
        }
        if(isOIDReturn) {
        	return returnOID;
        } else {
        	return responseValue.toString();
        }
    }

    /*
     * SNMP sysDecriptorm[hʂ𔻕ʂ܂B
     *
     * @param ipAddress m[hIPAhX
     * @param value SNMP sysDecriptor
     */
    private void autoDetectNodeKind(String ipAddress, String value) {
        if ((nodeDectMap != null) && (nodeDectMap.size() > 0)) {
        	/* m[hʒ`t@Cɂm[hʔ */
            for (Iterator it = nodeDectMap.keySet().iterator(); it.hasNext();) {
                String key = (String) it.next();

                if (value.indexOf(key) >= 0) {
                    String nodeKind = (String) nodeDectMap.get(key);
                    nodeKindMap.put(ipAddress, nodeKind);
                }
            }
        } else {
        	/* m[hʒ`Ȃ̏ꍇ */
            if (value.indexOf("Windows") >= 0) {
                nodeKindMap.put(ipAddress, NodeKind.WINODWS);
            }

            if (value.indexOf("Linux") >= 0) {
                nodeKindMap.put(ipAddress, NodeKind.LINUX);
            }

            if (value.indexOf("Redhat") >= 0) {
                nodeKindMap.put(ipAddress, NodeKind.REDHAT);
            }

            if (value.indexOf("Router") >= 0) {
                nodeKindMap.put(ipAddress, NodeKind.ROUTER);
            }

            if (value.indexOf("LR") >= 0) {
                nodeKindMap.put(ipAddress, NodeKind.ROUTER);
            }
        }
    }

    /**
     * IPySNMPm[ĥ߂̃p[^Zbg܂B
     *
     * @param timeoutMilliSecParam IPo^CAEgl
     * @param snmpVersion SNMPo[W
     * @param snmpROCommunity SNMP ReadR~jeB
     */
    public void setNodeCheckParam(
        String timeoutMilliSecParam, int snmpVersion, String snmpROCommunity) {
        this.timeoutMilliSecParam = timeoutMilliSecParam;
        this.snmpVersion = snmpVersion;
        this.snmpROCommunity = snmpROCommunity;
    }

    /**
     * m[hIPAhXXgԂ܂B
     *
     * @return checkNodeAddressList m[hIPAhXXg
     */
    public ArrayList getCheckNodeAddressList() {
        return checkNodeAddressList;
    }

    /**
     * IP(Ping) NGm[hAhXXgԂ܂B
     *
     * @return pingNGList IP NGm[hAhXXg
     */
    public ArrayList getPingNGList() {
        return pingNGList;
    }

    /**
     * IP(Ping) OKm[hAhXXgԂ܂B
     *
     * @return pingOKList Ping OKm[hAhXXg
     */
    public ArrayList getPingOKList() {
        return pingOKList;
    }

    /**
     * SNMP NGm[hAhXXgԂ܂B
     *
     * @return snmpNGList SNMP NGm[hAhXXg
     */
    public ArrayList getSnmpNGList() {
        return snmpNGList;
    }

    /**
     * SNMP OKm[hAhXXgԂ܂B
     *
     * @return snmpOKList SNMP OKm[hAhXXg
     */
    public ArrayList getSnmpOKList() {
        return snmpOKList;
    }

    /**
     * SNMP i/f OKm[hAhXXgԂ܂B
     *
     * @return snmpIFOKList SNMP i/f OKm[hAhXXg
     */
    public ArrayList getSnmpIFOKList() {
        return snmpIFOKList;
    }

    /**
     * SNMP i/f NGm[hAhXXgԂ܂B
     *
     * @return snmpIFNGList SNMP i/f NGm[hAhXXg
     */
    public ArrayList getSnmpIFNGList() {
        return snmpIFNGList;
    }

    /**
     * m[h SNMP sysDescriptorm[hʂʂłAhXMapԂ܂B
     *
     * @return nodeKindMap m[hʂʂłAhXMap
     */
    public HashMap getNodeKindMap() {
        return nodeKindMap;
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static ThreadAutoNodeDetect getInstance() {
        return SingletonResource.THREAD;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final ThreadAutoNodeDetect THREAD = new ThreadAutoNodeDetect();
    }
}
