/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.nodemaneger.map;

import java.util.ArrayList;

import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.socket.info.NodeMapLinkInformation;
import netjfwatcher.engine.view.canvas.CanvasViewConfig;
import netjfwatcher.engine.view.editorpart.common.AbstractEditorNodeChart;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;

/**
 * m[hMap ViewɃm[hMap`悷NXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NodeMapViewDraw {
	/* zFColor` */
	private static Color whiteColor;

	private static Color blackColor;

	private static Color redColor;

	private static Color testColor;

	/* m[hIconN`悷IconItZbgl */
	private static final int NODE_ICON_LINK_OFFSET = 10;

	/* m[hMap Canvas */
	private Canvas canvas;

	/* GC */
	private GC gc;

	// private Rectangle mapViewRectangle;
	private ScrolledComposite scrollComposite;

	private Point mapScrollCompositePoint;

	private int overviewPointX;

	private int overviewPointY;

	private int canvaAbsPointX;

	private int canvaAbsPointY;
	private int nodeMapViewWidth;
	private int nodeMapViewHeight;
	/* TvXP[ */
	private static final int OVERVIEW_POINT_SCALL = 20;

	/**
	 * m[hMap View`NXCX^X𐶐܂B
	 * 
	 * @param canvas
	 *            Canvas
	 * @param gc
	 *            GC
	 */
	public NodeMapViewDraw(ScrolledComposite scrollComposite, Canvas canvas,
			GC gc) {
		this.scrollComposite = scrollComposite;
		this.canvas = canvas;
		this.gc = gc;

		nodeMapViewWidth = CanvasViewConfig.getInstance().getCanvasSizeInfo().getNodeMapWidth();
		nodeMapViewHeight = CanvasViewConfig.getInstance().getCanvasSizeInfo().getNodeMapHeight();
		
		whiteColor = new Color(null, 255, 255, 255);
		blackColor = new Color(null, 0, 0, 0);
		redColor = new Color(null, 255, 0, 0);
		testColor = new Color(null, 127, 127, 127);
	}

	/**
	 * m[hLinkyуm[hĕ`悵܂B
	 * 
	 * @param nodeMapNodeInfoList
	 *            m[hIcon񃊃Xg
	 * @param nodMapLinkInformationList
	 *            m[hN
	 */
	public void redraw(ArrayList nodeMapNodeInfoList,
			NodeMapLinkInformation nodMapLinkInformationList) {

		gc.fillRectangle(canvas.getClientArea());

		int height = canvas.getClientArea().height - 1;
		int width = canvas.getClientArea().width - 1;
		gc.setForeground(testColor);
		gc.drawLine(0, 0, width, 0);
		gc.drawLine(0, 0, 0, height);
		gc.setForeground(whiteColor);
		gc.drawLine(width, 0, width, height);
		gc.drawLine(0, height, width, height);
		gc.setBackground(whiteColor);
		gc.setForeground(blackColor);

		createOverviewPoint();
		setMapOverviewNode();

		/* m[hLink` */
		drawNodeLink(nodeMapNodeInfoList, nodMapLinkInformationList);

		/* m[h` */
		drawNode(nodeMapNodeInfoList);

	}

	/**
	 * Map Overview̕`ʒuZbg܂B
	 * 
	 */
	protected void createOverviewPoint() {
		/* SCanvasɂVieẅʒu */
		Point canvaPoint = canvas.getLocation();
		canvaAbsPointX = Math.abs(canvaPoint.x);
		canvaAbsPointY = Math.abs(canvaPoint.y);
		/* \ĂMapr[TCY */
		// mapViewRectangle = gc.getClipping();
		mapScrollCompositePoint = scrollComposite.getSize();
		overviewPointX = canvaAbsPointX;
		overviewPointY = canvaAbsPointY
				+ (mapScrollCompositePoint.y - (AbstractEditorNodeChart.OFFSET))
				- (nodeMapViewHeight/ OVERVIEW_POINT_SCALL);

	}

	/**
	 * Map Overview`悵܂B
	 * 
	 */
	protected void setMapOverviewNode() {

		gc.setForeground(blackColor);
		/* Map OverviewOg */
		gc.setLineStyle(SWT.LINE_DOT);
		gc.drawRectangle(overviewPointX, overviewPointY,
				nodeMapViewWidth / OVERVIEW_POINT_SCALL,
				nodeMapViewHeight / OVERVIEW_POINT_SCALL);
		/* Map view̑S̃LoẌʒu */
		gc.setLineWidth(2);
		gc.setLineStyle(SWT.LINE_SOLID);
		gc.drawRectangle(overviewPointX + canvaAbsPointX / OVERVIEW_POINT_SCALL,
				overviewPointY + canvaAbsPointY / OVERVIEW_POINT_SCALL,
				mapScrollCompositePoint.x / OVERVIEW_POINT_SCALL,
				mapScrollCompositePoint.y / OVERVIEW_POINT_SCALL);

		gc.setLineWidth(1);
	}

	/**
	 * Map OverviewɃm[hDraw܂B
	 * 
	 * @param nodex
	 *            m[hXW
	 * @param nodey
	 *            m[hYW
	 */
	protected void setMapOverviewNode(int nodex, int nodey) {

		gc.drawRectangle(overviewPointX + nodex / OVERVIEW_POINT_SCALL,
				overviewPointY + nodey / OVERVIEW_POINT_SCALL, 3, 3);
	}

	/**
	 * m[h`悵܂B
	 * 
	 * @param nodeMapNodeInfoList
	 *            m[hIcon񃊃Xg
	 */
	protected void drawNode(ArrayList nodeMapNodeInfoList) {
		setColor();

		for (int i = 0; i < nodeMapNodeInfoList.size(); i++) {
			/* m[hIcon imagedraw */
			NodeMapInfo nodeMapInfo = (NodeMapInfo) nodeMapNodeInfoList.get(i);
			int pointX = nodeMapInfo.getX();
			int pointY = nodeMapInfo.getY();
			gc.setForeground(blackColor);

			if (!nodeMapInfo.isSelected()) {
				gc.drawImage(nodeMapInfo.getNodeIconImage(), pointX, pointY);

			} else {
				gc.drawImage(nodeMapInfo.getNodeIconImage(), pointX, pointY);
				gc.drawOval(pointX, pointY, nodeMapInfo.getWidth(), nodeMapInfo
						.getHeight());
			}
			setMapOverviewNode(pointX, pointY);
			/*
			 * m[h,IPAhXIcon imagẻɃZbg
			 */
			gc.drawString(nodeMapInfo.getNodeInfo().getNodename(), pointX,
					pointY + 40);
			gc.drawString(nodeMapInfo.getNodeInfo().getIpaddress(), pointX,
					pointY + 60);

			/*
			 * A[Zbg
			 */
			NodeInformation nodeInfo = nodeMapInfo.getNodeInfo();

			if ((nodeInfo.getAlarmMessage() != null)
					&& !nodeInfo.getAlarmMessage().equals("")) {
				gc.setForeground(redColor);

				gc.drawString(nodeMapInfo.getNodeInfo().getAlarmDate() + " : "
						+ nodeMapInfo.getNodeInfo().getAlarmMessage(), pointX,
						pointY + 80);

				gc.drawLine(pointX, pointY, pointX + nodeMapInfo.getWidth(),
						pointY + nodeMapInfo.getHeight());
				gc.drawLine(pointX + nodeMapInfo.getWidth(), pointY, pointX,
						pointY + nodeMapInfo.getHeight());

				gc.setForeground(blackColor);
			}
		}
	}

	/**
	 * m[hLink`悵܂B
	 * 
	 * @param nodeMapNodeInfoList
	 *            m[hIcon񃊃Xg
	 * @param nodMapLinkInformationList
	 *            m[hN
	 */
	protected void drawNodeLink(ArrayList nodeMapNodeInfoList,
			NodeMapLinkInformation nodMapLinkInformationList) {
		if (nodMapLinkInformationList == null) {
			return;
		}

		ArrayList nodeLinkList0 = nodMapLinkInformationList.getNode0address();
		ArrayList nodeLinkList1 = nodMapLinkInformationList.getNode1address();

		/*
		 * m[hLinkoăm[hԂLink`
		 */
		for (int i = 0; i < nodeLinkList0.size(); i++) {
			String nodeX = (String) nodeLinkList0.get(i);
			String nodeY = (String) nodeLinkList1.get(i);
			for (int j = 0; j < nodeMapNodeInfoList.size(); j++) {
				NodeMapInfo nodeMapInfo = (NodeMapInfo) nodeMapNodeInfoList
						.get(j);
				NodeInformation nodeInfo = nodeMapInfo.getNodeInfo();
				if (nodeX.equals(nodeInfo.getIpaddress())) {
					for (int k = 0; k < nodeMapNodeInfoList.size(); k++) {
						NodeMapInfo nodeMapInfo2 = (NodeMapInfo) nodeMapNodeInfoList
								.get(k);
						NodeInformation nodeInfo2 = nodeMapInfo2.getNodeInfo();

						if (nodeY.equals(nodeInfo2.getIpaddress())) {
							int x0;
							int y0;
							int x1;
							int y1;

							x0 = (int) Float.parseFloat(nodeInfo.getNodeX())
									+ NODE_ICON_LINK_OFFSET;
							y0 = (int) Float.parseFloat(nodeInfo.getNodeY())
									+ NODE_ICON_LINK_OFFSET;
							x1 = (int) Float.parseFloat(nodeInfo2.getNodeX())
									+ NODE_ICON_LINK_OFFSET;
							y1 = (int) Float.parseFloat(nodeInfo2.getNodeY())
									+ NODE_ICON_LINK_OFFSET;
							gc.setForeground(blackColor);
							gc.drawLine(x0, y0, x1, y1);
						}
					}
				}
			}
		}
	}

	/*
	 * ColorIuWFNgZbg܂B
	 * 
	 */
	private void setColor() {
		/*
		 * ColorIuWFNgjĂ΍ăZbg
		 */
		if ((whiteColor == null) || whiteColor.isDisposed()) {
			whiteColor = new Color(null, 255, 255, 255);
		}

		if ((blackColor == null) || blackColor.isDisposed()) {
			blackColor = new Color(null, 0, 0, 0);
		}

		if ((redColor == null) || redColor.isDisposed()) {
			redColor = new Color(null, 255, 0, 0);
		}

		if ((testColor == null) || testColor.isDisposed()) {
			testColor = new Color(null, 127, 127, 127);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#finalize()
	 */
	protected void finalize() throws Throwable {
		super.finalize();

		if (whiteColor != null && !whiteColor.isDisposed()) {
			whiteColor.dispose();
		}

		if (blackColor != null && !blackColor.isDisposed()) {
			blackColor.dispose();
		}

		if (redColor != null && !redColor.isDisposed()) {
			redColor.dispose();
		}

		if (testColor != null && !testColor.isDisposed()) {
			testColor.dispose();
		}

		if (gc != null && !gc.isDisposed()) {
			gc.dispose();
		}
		if (canvas != null && !canvas.isDisposed()) {
			canvas.dispose();
		}
	}
}
