/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.model.action;

import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.common.view.MenuPreference;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeChart;
import netjfwatcher.engine.view.editorpart.jvm.EditorGarbageCollectionChart;
import netjfwatcher.engine.view.editorpart.ping.EditorNodePingChart;
import netjfwatcher.engine.view.editorpart.snmp.EditorNodeSnmpStatisticsChart;
import netjfwatcher.socketclient.NetworkClientNodeTreeView;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;


/**
 * Ot`\ANVNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ActionBuilderChart {
    /* MO */
    private static Logger logger;

    /* m[hPingOt`ANV */
    private IAction nodePingChartAction = new ActionNodePingChartView();

    /* m[hPingOt`ANV */
    private IAction nodePingChartActionSocket =
        new ActionNodePingChartViewSocket();

    /* m[hSNMPvOt`ANV */
    private IAction nodeSnmpStatisticsChartAction =
        new ActionNodeSnmpStatisticsChartView();

    /* lbg[NoRm[hSNMPvOt`ANV */
    private IAction nodeSnmpStatisticsChartActionSocket =
        new ActionNodeSnmpStatisticsChartViewSocket();

    /* JVM Garbage CollectionOt`ANV */
    private IAction garbageCollectionAction = new ActionGarbageCollectionView();

    /* lbg[NoRJVM Garbage CollectionOt`ANV */
    private IAction garbageCollectionActionSocket =
        new ActionGarbageCollectionViewSocket();

    /* 摜肷邽߂PluginResource bundle */
    private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();

    /**
     * m[hOt`ANVNXCX^X𐶐܂B
     *
     */
    public ActionBuilderChart() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * m[hPingOt`ANVԂ܂B
     *
     * @return nodeChartAction m[hPingOt`ANV
     */
    public IAction getActionNodePingChartView() {
        return nodePingChartAction;
    }

    /**
     * lbg[NoRm[hPingOt`ANV
     * Ԃ܂B
     *
     * @return nodePingChartActionSocket lbg[NoRm[h
     * PingOt`ANV
     */
    public IAction getActionNodePingChartViewSocket() {
        return nodePingChartActionSocket;
    }

    /**
     * m[hSNMPvOt`ANVԂ܂B
     *
     * @return m[hSnmpvOt`ANV
     */
    public IAction getActionNodeSnmpStatisticsChartView() {
        return nodeSnmpStatisticsChartAction;
    }

    /**
     * lbg[NoRm[hSNMPvOt`ANV
     * Ԃ܂B
     *
     * @return nodeSnmpStatisticsChartActionSocket lbg[NoR
     * m[hSNMPvOt`ANV
     */
    public IAction getActionNodeSnmpStatisticsChartViewSocket() {
        return nodeSnmpStatisticsChartActionSocket;
    }

    /**
    * SNMPvOt\ANVԂ܂B
    *
    * @return SNMPvOt\ANVԂ܂B
    */
    public IAction getNewActionNodeSnmpStatisticsChartView() {
        // return nodeSnmpStatisticsChartAction;
        return new ActionNodeSnmpStatisticsChartView();
    }

    /**
     * lbg[NoRSNMPvOt\ANVԂ܂B
     *
     * @return lbg[NoRSNMPvOt\ANV
     */
    public IAction getNewActionNodeSnmpStatisticsChartViewSocket() {
        // return nodeSnmpStatisticsChartAction;
        return new ActionNodeSnmpStatisticsChartViewSocket();
    }

    /**
     * JVM Garbage CollectionOt`ANVԂ܂B
     *
     * @return JVM Garbage CollectionOt`ANV
     */
    public IAction getActionGarbageCollectionView() {
        return garbageCollectionAction;
    }

    /**
     * lbg[NoRGarbageCollectionr[\ANVԂ܂B
     *
     * @return garbageCollectionActionSocket lbg[NoR
     * GarbageCollectionr[\ANV
     */
    public IAction getActionGarbageCollectionViewSocket() {
        return garbageCollectionActionSocket;
    }

    /**
     * m[hOt`ANV`钊ۃNXłB
     *
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    private abstract class AbstractNodeChartAction extends Action {
        /** r[^Cg */
        protected String title;

        /** m[hĎ */
        protected NodeInformation nodeInfo;

        /** OID */
        protected String oid;

        /** OtXg */
        protected ArrayList nameList;

        /** OtőlXg */
        protected String[] maxData;

        /** OtŏlXg */
        protected String[] minData;

        /** f[^Xg */
        protected ArrayList dataList;

        /** ̎Xg */
        protected ArrayList dateList;

        /**
         * ANVs܂B
         */
        public final void run() {
            doTask();
        }

        /**
         * ANVs^XNłB
         *
         */
        protected abstract void doTask();

        /**
         * ̎f[^ListZbg܂B
         *
         * @param dataList ̎f[^List
         */
        public void setDataList(ArrayList dataList) {
            this.dataList = dataList;
        }

        /**
         * ̎ListZbg܂B
         *
         * @param dateList ̎List
         */
        public void setDateList(ArrayList dateList) {
            this.dateList = dateList;
        }

        /**
         * m[hĎZbg܂B
         *
         * @param nodeInfo m[hĎ
         */
        public void setNodeInfo(NodeInformation nodeInfo) {
            this.nodeInfo = nodeInfo;
        }

        /**
         * őlZbg܂B
         *
         * @param maxData ől
         */
        public void setMaxData(String[] maxData) {
            this.maxData = maxData;
        }

        /**
         * ŏlZbg܂B
         *
         * @param minData ŏl
         */
        public void setMinData(String[] minData) {
            this.minData = minData;
        }

        /**
         * ̎f[^ListZbg܂B
         *
         * @param nameList ̎f[^List
         */
        public void setNameList(ArrayList nameList) {
            this.nameList = nameList;
        }

        /**
         * OtView^CgZbg܂B
         *
         * @param title OtView^Cg
         */
        public void setTitle(String title) {
            this.title = title;
        }

        /**
         * SNMPvOIDZbg܂B
         *
         * @param oid SNMPvOID
         */
        public void setOid(String oid) {
            this.oid = oid;
        }
    }

    /**
     * m[hPingOt`ANVNXłB
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    public class ActionNodePingChartView extends AbstractNodeChartAction {
        /**
         * m[hPingOt`ANṼACRImageDescriptorԂ܂B
         *
         * @return m[hOt`ANṼACRImageDescriptor
         */
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL(
                bundle.getEntry(MenuPreference.PING_CHART_IMAGE_FILE));
        }

        /**
         * m[hPingOt`ANṼeLXgԂ܂B
         *
         * @return Text
         */
        public String getText() {
            return MenuPreference.PING_CHART;
        }

        /**
         * m[hPingOt`ANVToolTipTextԂ܂B
         *
         * @return ToolTipText
         *
         */
        public String getToolTipText() {
            return MenuPreference.PING_CHART_TOOL_TIP;
        }

        /**
         * m[hPingOt`悵܂B
         *
         */
        protected void doTask() {
            IEditorPart editorNodeConfigView = null;

            IWorkbenchPage activePage =
                PlatformUI.getWorkbench().getActiveWorkbenchWindow()
                          .getActivePage();

            try {
                if (editorNodeConfigView != null) {
                    activePage.closeEditor(editorNodeConfigView, false);
                    editorNodeConfigView = null;
                }

                /*
                * IꂽGg̃m[hURLEditorɃuEU
                * I[v
                */
                editorNodeConfigView =
                    activePage.openEditor(
                        new EditorInputNodeChart(
                            title, nodeInfo, false, dataList, dateList, nameList,
                            maxData, minData, oid),
                        EditorNodePingChart.class.getName());
            } catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    /**
     * lbg[NoRł̃m[hPingOt`ANVNXłB
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    public class ActionNodePingChartViewSocket extends AbstractNodeChartAction {
        /**
         * m[hPingOt`ANṼACRImageDescriptorԂ܂B
         *
         * @return m[hPingOt`ANṼACRImageDescriptor
         */
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL(
                bundle.getEntry(MenuPreference.PING_CHART_IMAGE_FILE));
        }

        /**
         * m[hPingOt`ANṼeLXgԂ܂B
         *
         * @return Text
         */
        public String getText() {
            return MenuPreference.PING_CHART;
        }

        /**
         * m[hPingOt`ANVToolTipTextԂ܂B
         *
         * @return ToolTipText
         */
        public String getToolTipText() {
            return MenuPreference.PING_CHART_TOOL_TIP;
        }

        /**
         * m[hPingOt`悵܂B
         *
         */
        protected void doTask() {
            IEditorPart editorNodeConfigView = null;

            IWorkbenchPage activePage =
                PlatformUI.getWorkbench().getActiveWorkbenchWindow()
                          .getActivePage();

            try {
                if (editorNodeConfigView != null) {
                    activePage.closeEditor(editorNodeConfigView, false);
                    editorNodeConfigView = null;
                }

                /*
                * IꂽGg̃m[hURLEditorɃuEU
                * I[v
                */
                editorNodeConfigView =
                    activePage.openEditor(
                        new EditorInputNodeChart(
                            title
                            + NetworkClientNodeTreeView
                            .getTitleSuffixEngineAddress(), nodeInfo, true,
                            dataList, dateList, nameList, maxData, minData, oid),
                        EditorNodePingChart.class.getName());
            } catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    /**
     * m[hSNMPvOt`ANVNXłB
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    public class ActionNodeSnmpStatisticsChartView
        extends AbstractNodeChartAction {
        /**
         * m[hSNMPvOt`ANṼACR
         * ImageDescriptorԂ܂B
         *
         * @return m[hSNMPvOt`ANV
         * ACRImageDescriptor
         */
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL(
                bundle.getEntry(
                    MenuPreference.SNMP_STATISTICS_CHART_IMAGE_FILE));
        }

        /**
         * m[hSNMPvOt`悵܂B
         *
         */
        protected void doTask() {
            IEditorPart editorNodeConfigView = null;

            IWorkbenchPage activePage =
                PlatformUI.getWorkbench().getActiveWorkbenchWindow()
                          .getActivePage();

            try {
                if (editorNodeConfigView != null) {
                    activePage.closeEditor(editorNodeConfigView, false);
                    editorNodeConfigView = null;
                }

                /*
                * IꂽGg̃m[hURLEditorɃuEU
                * I[v
                */
                editorNodeConfigView =
                    activePage.openEditor(
                        new EditorInputNodeChart(
                            title, nodeInfo, false, dataList, dateList, nameList,
                            maxData, minData, oid),
                        EditorNodeSnmpStatisticsChart.class.getName());
            } catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    /**
     * lbg[NoRł̃m[hSNMPvOt`ANVNXłB
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    public class ActionNodeSnmpStatisticsChartViewSocket
        extends ActionNodeSnmpStatisticsChartView {
        /**
         * m[hSnmpvOt`悵܂B
         *
         */
        protected void doTask() {
            IEditorPart editorNodeConfigView = null;

            IWorkbenchPage activePage =
                PlatformUI.getWorkbench().getActiveWorkbenchWindow()
                          .getActivePage();

            try {
                if (editorNodeConfigView != null) {
                    activePage.closeEditor(editorNodeConfigView, false);
                    editorNodeConfigView = null;
                }

                /*
                * IꂽGg̃m[hURLEditorɃuEU
                * I[v
                */
                editorNodeConfigView =
                    activePage.openEditor(
                        new EditorInputNodeChart(
                            title
                            + NetworkClientNodeTreeView
                            .getTitleSuffixEngineAddress(), nodeInfo, true,
                            dataList, dateList, nameList, maxData, minData, oid),
                        EditorNodeSnmpStatisticsChart.class.getName());
            } catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    /**
     * GarbageCollection[Ot`ANVNXłB
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    public class ActionGarbageCollectionView extends AbstractNodeChartAction {
        /**
         * GarbageCollectionOt`ANṼACR
         * ImageDescriptorԂ܂B
         *
         * @return GarbageCollectionOt`ANV
         * ACRImageDescriptor
         */
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL(
                bundle.getEntry(MenuPreference.GARBAGECOLLECTION_IMAGE_FILE));
        }

        /**
         * GarbageCollectionOt`ANṼeLXgԂ܂B
         *
         * @return Text
         */
        public String getText() {
            return MenuPreference.GARBAGECOLLECTION_CHART;
        }

        /**
         * GarbageCollectionOt`ANVToolTipTextԂ܂B
         *
         * @return ToolTipText
         */
        public String getToolTipText() {
            return MenuPreference.GARBAGECOLLECTION_TOOL_TIP;
        }

        /**
         * GarbageCollectionOt`悵܂B
         *
         */
        protected void doTask() {
            IEditorPart editorNodeConfigView = null;

            IWorkbenchPage activePage =
                PlatformUI.getWorkbench().getActiveWorkbenchWindow()
                          .getActivePage();

            try {
                if (editorNodeConfigView != null) {
                    activePage.closeEditor(editorNodeConfigView, false);
                    editorNodeConfigView = null;
                }

                /*
                * IꂽGg̃m[hURLEditorɃuEU
                * I[v
                */
                editorNodeConfigView =
                    activePage.openEditor(
                        new EditorInputNodeChart(
                            title, nodeInfo, false, dataList, dateList, nameList,
                            maxData, minData),
                        EditorGarbageCollectionChart.class.getName());
            } catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }

    /**
     * lbg[NoRłGarbageCollection[Ot`ANVNXłB
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    public class ActionGarbageCollectionViewSocket
        extends ActionGarbageCollectionView {
        /**
         * GarbageCollectionOt`悵܂B
         *
         */
        protected void doTask() {
            IEditorPart editorNodeConfigView = null;

            IWorkbenchPage activePage =
                PlatformUI.getWorkbench().getActiveWorkbenchWindow()
                          .getActivePage();

            try {
                if (editorNodeConfigView != null) {
                    activePage.closeEditor(editorNodeConfigView, false);
                    editorNodeConfigView = null;
                }

                /*
                * IꂽGg̃m[hURLEditorɃuEU
                * I[v
                */
                editorNodeConfigView =
                    activePage.openEditor(
                        new EditorInputNodeChart(
                            title
                            + NetworkClientNodeTreeView
                            .getTitleSuffixEngineAddress(), nodeInfo, true,
                            dataList, dateList, nameList, maxData, minData),
                        EditorGarbageCollectionChart.class.getName());
            } catch (PartInitException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }
    }
}
