/*
 * Created on 2004/12/22
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.command.model;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableAlarmFilter;
import netjfwatcher.engine.command.control.TemplateCommandImpl;
import netjfwatcher.engine.socket.CommandInfo;
import netjfwatcher.engine.socket.info.AlarmViewFilter;


/**
 * A[tB^[e[u𑀍삵܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class CommandAlarmFilter extends TemplateCommandImpl {
    // MO
    private static Logger logger;

    /**
     * A[tB^[̐s\bhłB
     *
     * @param com R}h
     * @param ois ̓Xg[
     * @param oos o̓Xg[
     */
    public void doInvoke(
        CommandInfo com, ObjectInputStream ois, ObjectOutputStream oos) {
        logger = Logger.getLogger(this.getClass().getName());

        AlarmViewFilter alarmFilterInfo = com.getAlarmFilterInfo();

        DBTableAlarmFilter alarmFilterDBTable = new DBTableAlarmFilter();

        ArrayList alarmFilterList = null;

        try {
            if (
                alarmFilterInfo.getSubCommand().equals(
                        AlarmViewFilter.ALARM_FILTER_GET)) {
                /* A[Filter擾 */
                alarmFilterList = alarmFilterDBTable.findAll();
            } else if (
                alarmFilterInfo.getSubCommand().equals(
                        AlarmViewFilter.ALARM_FILTER_SET)) {
                /* A[FilterXV */
                alarmFilterDBTable.updateAlarmFilter(alarmFilterInfo);
            }
        } catch (DatabaseConnectionException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        } catch (SQLException e) {
            logger.warning(e.getMessage());
            e.printStackTrace();
        }

        sendResponse(alarmFilterList, ois, oos);
    }
}
