/*
 * Created on 2004/04/20
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.alarm;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;


/**
 * A[񃊃XgێNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class AlarmRecoveryIP {
    /*
     * A[IDL[ƂăA[̈ȉ̏ێMapłB
     * EA[ID
     * EA[Level
     * EA[Code
     * EA[Message
     */
    private Map<String, AlarmCodeInformation> alarmIDMap = Collections.synchronizedMap(new HashMap<String, AlarmCodeInformation>());

    /**
     * A[񃊃XgێNXCX^X𐶐܂B
     *
     */
    public AlarmRecoveryIP() {
    }

    /**
     * A[IDL[ƂāAA[MapɊi[܂B
     * A[ɌĂ΂Am[hIP AddressPʂŃZbg܂B
     *
     * @param alarmId A[ID
     * @param alarmCodeInfo A[R[h
     */
    public void putAlarmInfo(
        final String alarmId, final AlarmCodeInformation alarmCodeInfo) {
        alarmIDMap.put(alarmId, alarmCodeInfo);
    }

    /**
     * Ďm[hɂw̃A[IDɑΉA[Ԃ܂B
     * A[IDɊY񂪂ȂꍇnullԂ܂B
     *
     * @param alarmId A[ID
     * @return A[R[h
     */
    public AlarmCodeInformation getAlarmInfo(final String alarmId) {
        AlarmCodeInformation info =
            (AlarmCodeInformation) alarmIDMap.get(alarmId);

        if (info != null) {
            return info;
        }

        return null;
    }

    /**
     * w̃A[IDɊYMapォ폜܂B
     * A[ɂĂ΂܂
     *
     * @param alarmId A[ID
     */
    public void delete(final String alarmId) {
        alarmIDMap.remove(alarmId);
    }

    /**
     * A[IDL[ƂăA[R[hێMapԂ܂B
     *
     * @return alarmIdmap A[IDL[ƂăA[R[hێMap
     */
    public Map getMap() {
        return alarmIDMap;
    }
}
