/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmpmanager.trap;

import java.util.List;
import java.util.logging.Logger;
import netjfwatcher.snmp.messageformat.SNMPTLV;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.messageformat.SnmpTrapPDU;
import netjfwatcher.snmp.snmpobject.message.SnmpMessage;
import netjfwatcher.snmpmanager.trap.AbstractTrapMessageProcessing;
import netjfwatcher.snmpmanager.trap.ITrapListener;

public class TrapV1ReceiveMP
extends AbstractTrapMessageProcessing {
    private static Logger logger;

    public TrapV1ReceiveMP() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public final void process(String agentAddress, byte[] encodedMessage, List listenerList) throws SnmpBadValueException {
        logger.info("Snmp V1 Trap : " + agentAddress);
        SnmpMessage receivedMessage = new SnmpMessage();
        SNMPTLV nextTLV = receivedMessage.extractNextTLV(encodedMessage, 0);
        receivedMessage.setTLV(nextTLV);
        SnmpTrapPDU receivedTrapPDU = receivedMessage.getTrapPDU();
        byte[] communityByte = receivedMessage.getCommunity();
        String community = TrapV1ReceiveMP.bytetoChar(communityByte);
        int i = 0;
        while (i < listenerList.size()) {
            ITrapListener listener = (ITrapListener)listenerList.get(i);
            listener.processTrap(community, receivedTrapPDU, agentAddress);
            ++i;
        }
    }
}

