/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmpagent;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.mibtree.AgentMibTree;
import netjfwatcher.snmp.mibtree.MibInfo;
import netjfwatcher.snmp.snmpobject.integer.SnmpCounter32;
import netjfwatcher.snmp.snmpobject.integer.SnmpCounter64;
import netjfwatcher.snmp.snmpobject.integer.SnmpGauge32;
import netjfwatcher.snmp.snmpobject.integer.SnmpInteger;
import netjfwatcher.snmp.snmpobject.integer.SnmpTimeTicks;
import netjfwatcher.snmp.snmpobject.integer.SnmpUInteger32;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;
import netjfwatcher.snmp.snmpobject.message.SnmpObjectIdentifier;
import netjfwatcher.snmp.snmpobject.octetstring.SnmpOctetString;
import netjfwatcher.snmpagent.AbstractAgentView;
import netjfwatcher.snmpagent.model.AgentInstanceDataMap;
import netjfwatcher.snmpagent.model.AgentInstanceDataRefreshQueue;
import netjfwatcher.snmpagent.process.ThreadAgent;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;

public class AgentDataEditorView
extends AbstractAgentView {
    private static final int TEXT_WIDTH = 300;
    private static Logger logger;
    private static final int[] SCROLL_COMPOSITE_SIZE;
    private Text noText;
    private Text oidDescriptionText;
    private Text oidText;
    private Text valueText;
    private Text typeText;
    private Text accessText;
    private Button agentDataUpdateButton;
    private Color textBackColor;

    static {
        SCROLL_COMPOSITE_SIZE = new int[]{600, 300};
    }

    public void createPartControl(Composite parent) {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        this.textBackColor = whiteColor;
        ScrolledComposite scrollComposite = new ScrolledComposite(parent, 768);
        GridLayout layout = new GridLayout(1, false);
        scrollComposite.setLayout((Layout)layout);
        GridData gridData = null;
        GridLayout gridLayout = new GridLayout(3, false);
        Composite composite = new Composite((Composite)scrollComposite, 0);
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(256));
        gridData = new GridData();
        Label label = new Label(composite, 0);
        label.setText("No.");
        label.setLayoutData((Object)new GridData());
        this.noText = new Text(composite, 2056);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 300;
        this.noText.setEnabled(false);
        this.noText.setBackground(this.textBackColor);
        this.noText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("OID Description");
        label.setLayoutData((Object)new GridData());
        this.oidDescriptionText = new Text(composite, 2056);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 300;
        this.oidDescriptionText.setEnabled(false);
        this.oidDescriptionText.setBackground(this.textBackColor);
        this.oidDescriptionText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("OID");
        label.setLayoutData((Object)new GridData());
        this.oidText = new Text(composite, 2056);
        this.oidText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 300;
        this.oidText.setEnabled(false);
        this.oidText.setBackground(this.textBackColor);
        this.oidText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Value");
        label.setLayoutData((Object)new GridData());
        this.valueText = new Text(composite, 2048);
        this.valueText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 300;
        this.valueText.setBackground(this.textBackColor);
        this.valueText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Type");
        label.setLayoutData((Object)new GridData());
        this.typeText = new Text(composite, 2056);
        this.typeText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 300;
        this.typeText.setEnabled(false);
        this.typeText.setBackground(this.textBackColor);
        this.typeText.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setText("Access");
        label.setLayoutData((Object)new GridData());
        this.accessText = new Text(composite, 2056);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 300;
        this.accessText.setEnabled(false);
        this.accessText.setBackground(this.textBackColor);
        this.accessText.setLayoutData((Object)gridData);
        this.agentDataUpdateButton = new Button(composite, 0);
        this.agentDataUpdateButton.setText("Edit");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        scrollComposite.setContent((Control)composite);
        scrollComposite.setMinSize(SCROLL_COMPOSITE_SIZE[0], SCROLL_COMPOSITE_SIZE[1]);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);
        this.agentDataUpdateButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                String oid = AgentDataEditorView.this.oidText.getText();
                String value = AgentDataEditorView.this.valueText.getText();
                String oidType = AgentDataEditorView.this.typeText.getText();
                if (oid.equals("") || value.equals("") || oidType.equals("")) {
                    MessageBox alertMessageBox = new MessageBox(AgentDataEditorView.this.getSite().getShell(), 72);
                    alertMessageBox.setMessage("Illegal Agent data");
                    alertMessageBox.open();
                    return;
                }
                MibInfo miboid = null;
                miboid = AgentDataEditorView.this.editAgentInstanceData(oid, value, oidType);
                if (miboid != null) {
                    AgentInstanceDataRefreshQueue.getInstance().pushQueue(miboid);
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
    }

    private MibInfo editAgentInstanceData(String oid, String value, String oidType) {
        AgentMibTree mibtable = AgentMibTree.getInstance();
        HashMap agentOidHashMap = mibtable.getOidHashMap();
        MibInfo agentInstanceDataOidInfo = null;
        if (agentOidHashMap.containsKey(oid) && (agentInstanceDataOidInfo = (MibInfo)agentOidHashMap.get(oid)) != null) {
            AbstractSnmpObject newSnmpObject = this.createSnmpObject(oid, value, oidType);
            Map tableAgentMap = AgentInstanceDataMap.getInstance().getAgentInstanceMap();
            MibInfo agentTableOidInfo = (MibInfo)tableAgentMap.get(oid);
            agentTableOidInfo.setValue(newSnmpObject.toString());
            AgentInstanceDataMap.getInstance().setAgentInstanceDataMap(oid, agentTableOidInfo);
            agentInstanceDataOidInfo.setAgentMibValue(newSnmpObject);
            agentOidHashMap.put(oid, agentInstanceDataOidInfo);
            mibtable.setOidHashMap(agentOidHashMap);
            mibtable = AgentMibTree.getInstance();
            agentOidHashMap = mibtable.getOidHashMap();
            agentInstanceDataOidInfo = (MibInfo)agentOidHashMap.get(oid);
        }
        return agentInstanceDataOidInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AbstractSnmpObject createSnmpObject(String oid, String value, String oidType) {
        AbstractSnmpObject newSnmpObject = null;
        if (oidType.equals("INTEGER")) {
            newSnmpObject = new SnmpInteger();
            try {
                newSnmpObject.setValue(value);
                return newSnmpObject;
            }
            catch (SnmpBadValueException snmpBadValueException) {
                MessageBox alertMessageBox = new MessageBox(this.getSite().getShell(), 72);
                alertMessageBox.setMessage("Illegal Value");
                alertMessageBox.open();
                this.valueText.setFocus();
                return null;
            }
        }
        if (oidType.equals("Counter32")) {
            newSnmpObject = new SnmpCounter32();
            try {
                newSnmpObject.setValue(value);
                return newSnmpObject;
            }
            catch (SnmpBadValueException snmpBadValueException) {
                MessageBox alertMessageBox = new MessageBox(this.getSite().getShell(), 72);
                alertMessageBox.setMessage("Illegal Value");
                alertMessageBox.open();
                this.valueText.setFocus();
                return null;
            }
        }
        if (oidType.equals("Counter64")) {
            newSnmpObject = new SnmpCounter64();
            try {
                newSnmpObject.setValue(value);
                return newSnmpObject;
            }
            catch (SnmpBadValueException snmpBadValueException) {
                MessageBox alertMessageBox = new MessageBox(this.getSite().getShell(), 72);
                alertMessageBox.setMessage("Illegal Value");
                alertMessageBox.open();
                this.valueText.setFocus();
                return null;
            }
        }
        if (oidType.equals("Gauge32")) {
            newSnmpObject = new SnmpGauge32();
            try {
                newSnmpObject.setValue(value);
                return newSnmpObject;
            }
            catch (SnmpBadValueException snmpBadValueException) {
                MessageBox alertMessageBox = new MessageBox(this.getSite().getShell(), 72);
                alertMessageBox.setMessage("Illegal Value");
                alertMessageBox.open();
                this.valueText.setFocus();
                return null;
            }
        }
        if (oidType.equals("Uinteger32")) {
            newSnmpObject = new SnmpUInteger32();
            try {
                newSnmpObject.setValue(value);
                return newSnmpObject;
            }
            catch (SnmpBadValueException snmpBadValueException) {
                MessageBox alertMessageBox = new MessageBox(this.getSite().getShell(), 72);
                alertMessageBox.setMessage("Illegal Value");
                alertMessageBox.open();
                this.valueText.setFocus();
                return null;
            }
        }
        if (oidType.equals("ObjectID")) {
            newSnmpObject = new SnmpObjectIdentifier();
            try {
                newSnmpObject.setValue(value);
                return newSnmpObject;
            }
            catch (SnmpBadValueException snmpBadValueException) {
                MessageBox alertMessageBox = new MessageBox(this.getSite().getShell(), 72);
                alertMessageBox.setMessage("Illegal Value");
                alertMessageBox.open();
                this.valueText.setFocus();
                return null;
            }
        }
        if (oidType.equals("TimeTicks")) {
            newSnmpObject = new SnmpTimeTicks();
            try {
                newSnmpObject.setValue(value);
                if (!oid.equals("1.3.6.1.2.1.1.3.0")) return newSnmpObject;
                long sysupTimeMills = System.currentTimeMillis() - Long.parseLong(value) * 1000L;
                ThreadAgent.getInstance().setStartEngineTime(sysupTimeMills);
                return newSnmpObject;
            }
            catch (SnmpBadValueException snmpBadValueException) {
                MessageBox alertMessageBox = new MessageBox(this.getSite().getShell(), 72);
                alertMessageBox.setMessage("Illegal Value");
                alertMessageBox.open();
                this.valueText.setFocus();
                return null;
            }
        }
        if (!oidType.equals("OctetString")) return newSnmpObject;
        newSnmpObject = new SnmpOctetString();
        try {
            newSnmpObject.setValue(value);
            return newSnmpObject;
        }
        catch (SnmpBadValueException snmpBadValueException) {
            MessageBox alertMessageBox = new MessageBox(this.getSite().getShell(), 72);
            alertMessageBox.setMessage("Illegal Value");
            alertMessageBox.open();
            this.valueText.setFocus();
            return null;
        }
    }

    public Text getAccessText() {
        return this.accessText;
    }

    public Text getNoText() {
        return this.noText;
    }

    public Text getOidDescriptionText() {
        return this.oidDescriptionText;
    }

    public Text getOidText() {
        return this.oidText;
    }

    public Text getTypeText() {
        return this.typeText;
    }

    public Text getValueText() {
        return this.valueText;
    }
}

