/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmp.snmpobject.octetstring;

import java.io.ByteArrayOutputStream;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;

public class SnmpOctetString
extends AbstractSnmpObject {
    protected byte[] dataArray;

    public SnmpOctetString() {
        this.dataArray = new byte[0];
        this.tag = (byte)4;
        this.tagDescription = "OCTETSTRING";
    }

    public SnmpOctetString(String stringData) {
        this.dataArray = stringData.getBytes();
        this.tag = (byte)4;
        this.tagDescription = "OCTETSTRING";
    }

    public SnmpOctetString(byte[] enc) {
        this.extractFromBEREncoding(enc);
        this.tag = (byte)4;
        this.tagDescription = "OCTETSTRING";
    }

    public Object getValue() {
        return this.dataArray;
    }

    public void setValue(Object data) throws SnmpBadValueException {
        if (data instanceof byte[]) {
            this.dataArray = (byte[])data;
        } else if (data instanceof String) {
            this.dataArray = ((String)data).getBytes();
        } else {
            throw new SnmpBadValueException(" Octet String: bad object supplied to set value ");
        }
    }

    public byte[] getBEREncoding() {
        ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
        byte[] len = this.encodeLength(this.dataArray.length);
        outBytes.write(this.tag);
        outBytes.write(len, 0, len.length);
        outBytes.write(this.dataArray, 0, this.dataArray.length);
        return outBytes.toByteArray();
    }

    protected void extractFromBEREncoding(byte[] enc) {
        this.dataArray = new byte[enc.length];
        int i = 0;
        while (i < enc.length) {
            this.dataArray[i] = enc[i];
            ++i;
        }
    }

    public String toString() {
        String returnString;
        if (this.dataArray.length > 0 && this.dataArray.length > 1 && this.dataArray[0] <= 127 && this.dataArray[0] >= 32) {
            returnString = new String(this.dataArray);
        } else {
            returnString = this.dataArray.length > 2 ? "0x" : "";
            int i = 0;
            while (i < this.dataArray.length) {
                returnString = String.valueOf(returnString) + this.hexByte(this.dataArray[i]);
                ++i;
            }
        }
        return returnString;
    }
}

