/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmp.snmpobject.octetstring;

import java.util.StringTokenizer;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.snmpobject.octetstring.SnmpOctetString;

public class SnmpNSAPAddress
extends SnmpOctetString {
    private static final int NSAADDRESS_LENGTH = 6;

    public SnmpNSAPAddress() {
        this.dataArray = new byte[6];
        int i = 0;
        while (i < 6) {
            this.dataArray[i] = 0;
            ++i;
        }
        this.tag = (byte)69;
        this.tagDescription = "NSAPADDRESS";
    }

    public SnmpNSAPAddress(String string) throws SnmpBadValueException {
        this.dataArray = this.parseNSAPAddress(string);
        this.tag = (byte)69;
        this.tagDescription = "NSAPADDRESS";
    }

    public SnmpNSAPAddress(byte[] enc) throws SnmpBadValueException {
        this.tag = (byte)69;
        if (enc.length != 6) {
            throw new SnmpBadValueException(" NSAPAddress: bad BER encoding supplied to set value ");
        }
        this.dataArray = enc;
    }

    public void setValue(Object newAddress) throws SnmpBadValueException {
        if (newAddress instanceof byte[] && ((byte[])newAddress).length == 6) {
            this.dataArray = (byte[])newAddress;
        } else if (newAddress instanceof String) {
            this.dataArray = this.parseNSAPAddress((String)newAddress);
        } else {
            throw new SnmpBadValueException(" NSAPAddress: bad length byte string supplied to set value ");
        }
    }

    public String toString() {
        String returnString = "";
        if (this.dataArray.length > 0) {
            int convert = this.dataArray[0];
            if (convert < 0) {
                convert += 256;
            }
            returnString = String.valueOf(returnString) + Integer.toHexString(convert);
            int i = 1;
            while (i < this.dataArray.length) {
                convert = this.dataArray[i];
                if (convert < 0) {
                    convert += 256;
                }
                returnString = String.valueOf(returnString) + "-" + Integer.toHexString(convert);
                ++i;
            }
        }
        return returnString;
    }

    private byte[] parseNSAPAddress(String addressString) throws SnmpBadValueException {
        try {
            StringTokenizer st = new StringTokenizer(addressString, " .-");
            int size = 0;
            while (st.hasMoreTokens()) {
                ++size;
                st.nextToken();
            }
            if (size != 6) {
                throw new SnmpBadValueException(" NSAPAddress: wrong number of components supplied to set value ");
            }
            byte[] returnBytes = new byte[size];
            st = new StringTokenizer(addressString, " .-");
            int i = 0;
            while (i < size) {
                int addressComponent = Integer.parseInt(st.nextToken(), 16);
                if (addressComponent < 0 || addressComponent > 255) {
                    throw new SnmpBadValueException(" NSAPAddress: invalid component supplied to set value ");
                }
                returnBytes[i] = (byte)addressComponent;
                ++i;
            }
            return returnBytes;
        }
        catch (NumberFormatException numberFormatException) {
            throw new SnmpBadValueException(" NSAPAddress: invalid component supplied to set value ");
        }
    }
}

