/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.snmp.snmpobject.bit;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Vector;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.snmpobject.bit.SnmpBit;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;

public class SnmpBitString
extends AbstractSnmpObject {
    private SnmpBit snmpBitValue;

    public SnmpBitString(SnmpBit value) {
        this.tag = (byte)3;
        this.tagDescription = "BITSTRING";
        this.snmpBitValue = value;
    }

    public SnmpBitString(byte[] data) throws SnmpBadValueException {
        this.tag = (byte)3;
        this.tagDescription = "BITSTRING";
        int offset = 0;
        int length = data.length;
        this.snmpBitValue = SnmpBitString.decode(data, offset, length);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("");
        if (this.snmpBitValue != null) {
            sb.append("0x");
            sb.append(this.snmpBitValue.toString());
        }
        return sb.toString();
    }

    public Object getValue() {
        return this.snmpBitValue;
    }

    byte[] encode() {
        return this.encode(this.snmpBitValue);
    }

    public byte[] encode(SnmpBit bits) {
        byte[] value = null;
        value = bits != null ? bits.getBEREncoding() : new byte[]{};
        Vector<Byte> vector = new Vector<Byte>();
        int length = value.length;
        if (length > 127) {
            vector.addElement(new Byte(0));
            vector.addElement(new Byte((byte)(length >> 24 & 0xFF)));
            vector.addElement(new Byte((byte)(length >> 16 & 0xFF)));
            vector.addElement(new Byte((byte)(length >> 8 & 0xFF)));
            vector.addElement(new Byte((byte)(length & 0xFF)));
            int i = 0;
            while (i < 4) {
                byte b = (Byte)vector.elementAt(1);
                if (b != 0) {
                    if (b < 0) break;
                    vector.removeElementAt(0);
                    break;
                }
                vector.removeElementAt(0);
                ++i;
            }
            vector.insertElementAt(new Byte((byte)(vector.size() | 0x80)), 0);
        } else {
            vector.addElement(new Byte((byte)length));
        }
        byte[] array = new byte[1 + vector.size() + length];
        int index = 0;
        array[index++] = 3;
        int i = 0;
        int li = vector.size();
        while (i < li) {
            array[index++] = (Byte)vector.elementAt(i);
            ++i;
        }
        vector.removeAllElements();
        System.arraycopy(value, 0, array, index, length);
        return array;
    }

    static SnmpBit decode(byte[] data, int offset, int length) throws SnmpBadValueException {
        byte[] bytes = new byte[length];
        try {
            System.arraycopy(data, offset, bytes, 0, length);
        }
        catch (IndexOutOfBoundsException e) {
            throw new SnmpBadValueException(e.getMessage());
        }
        return new SnmpBit(bytes);
    }

    public byte[] getBEREncoding() {
        ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
        byte[] outBytesArray = null;
        try {
            byte[] data = this.snmpBitValue.getBEREncoding();
            byte[] len = this.encodeLength(data.length);
            outBytes.write(this.tag);
            outBytes.write(len, 0, len.length);
            outBytes.write(data, 0, data.length);
            outBytesArray = outBytes.toByteArray();
        }
        finally {
            try {
                outBytes.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return outBytesArray;
    }

    public void setValue(Object newValue) throws SnmpBadValueException {
    }
}

