/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.view.editorpart.ping;

import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Logger;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.model.action.ActionBuilderChart;
import netjfwatcher.engine.model.action.ActionBuilderNodeDataTable;
import netjfwatcher.engine.nodemaneger.map.NodeMapMenuNodePingChart;
import netjfwatcher.engine.nodemaneger.map.NodeMapMenuNodePingTable;
import netjfwatcher.engine.socket.info.NodeInformation;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.osgi.framework.Bundle;

public class NodePingMenu {
    private static Logger logger;
    private Bundle bundle;
    private Image chartImage;
    private Image tableImage;
    private ActionBuilderNodeDataTable dataTableAction = new ActionBuilderNodeDataTable();
    private ActionBuilderChart nodeChart = new ActionBuilderChart();

    public NodePingMenu() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    public void createPingMenu(IMenuManager manager, NodeInformation targetNodeInfo, boolean isSocket) {
        MenuManager optionMenu = new MenuManager("Node Ping Response Data");
        manager.add((IContributionItem)optionMenu);
        optionMenu.add((IContributionItem)new Separator());
        String title = String.valueOf(targetNodeInfo.getNodename()) + "(" + targetNodeInfo.getIpaddress() + ") " + "Ping " + " Chart";
        ArrayList<String> nameList = new ArrayList<String>();
        nameList.add(String.valueOf(targetNodeInfo.getNodename()) + "(" + targetNodeInfo.getIpaddress() + ")");
        if (!isSocket) {
            ActionBuilderNodeDataTable.ActionShowPingResponseData pingDataTableAction = (ActionBuilderNodeDataTable.ActionShowPingResponseData)this.dataTableAction.actionShowPingDataView();
            pingDataTableAction.setNodeInfo(targetNodeInfo);
            optionMenu.add((IAction)pingDataTableAction);
            ((ActionBuilderChart.ActionNodePingChartView)this.nodeChart.getActionNodePingChartView()).setTitle(title);
            ((ActionBuilderChart.ActionNodePingChartView)this.nodeChart.getActionNodePingChartView()).setNodeInfo(targetNodeInfo);
            ((ActionBuilderChart.ActionNodePingChartView)this.nodeChart.getActionNodePingChartView()).setNameList(nameList);
            optionMenu.add(this.nodeChart.getActionNodePingChartView());
        } else {
            ActionBuilderNodeDataTable.ActionShowPingResponseDataSocket pingDataTableAction = (ActionBuilderNodeDataTable.ActionShowPingResponseDataSocket)this.dataTableAction.actionShowPingDataViewSocket();
            pingDataTableAction.setNodeInfo(targetNodeInfo);
            optionMenu.add((IAction)pingDataTableAction);
            ((ActionBuilderChart.ActionNodePingChartViewSocket)this.nodeChart.getActionNodePingChartViewSocket()).setTitle(title);
            ((ActionBuilderChart.ActionNodePingChartViewSocket)this.nodeChart.getActionNodePingChartViewSocket()).setNodeInfo(targetNodeInfo);
            ((ActionBuilderChart.ActionNodePingChartViewSocket)this.nodeChart.getActionNodePingChartViewSocket()).setNameList(nameList);
            optionMenu.add(this.nodeChart.getActionNodePingChartViewSocket());
        }
    }

    public void createPingMenu(Menu popUpMenu, NodeInformation targetNodeInfo, boolean isSocket) {
        MenuItem pingMenuItem = new MenuItem(popUpMenu, 64);
        this.bundle = NetJFWatcherPlugin.getInstance().getBundle();
        ImageDescriptor chartImageDescriptor = ImageDescriptor.createFromURL((URL)this.bundle.getEntry("icons/chart.gif"));
        ImageDescriptor tableImageDescriptor = ImageDescriptor.createFromURL((URL)this.bundle.getEntry("icons/table.gif"));
        if (this.chartImage == null) {
            this.chartImage = chartImageDescriptor.createImage();
        }
        if (this.tableImage == null) {
            this.tableImage = tableImageDescriptor.createImage();
        }
        pingMenuItem.setText("Node Ping Response Data");
        Menu pingSubmenu = new Menu(pingMenuItem);
        pingMenuItem.setMenu(pingSubmenu);
        String title = String.valueOf(targetNodeInfo.getNodename()) + "(" + targetNodeInfo.getIpaddress() + ") " + "Ping ";
        MenuItem subMenuItemPingTable = new MenuItem(pingSubmenu, 8);
        subMenuItemPingTable.setText(String.valueOf(title) + " Table");
        subMenuItemPingTable.setImage(this.tableImage);
        NodeMapMenuNodePingTable nodePingTable = new NodeMapMenuNodePingTable(targetNodeInfo, isSocket);
        subMenuItemPingTable.addSelectionListener((SelectionListener)nodePingTable);
        MenuItem subMenuItemPingChart = new MenuItem(pingSubmenu, 8);
        subMenuItemPingChart.setText(String.valueOf(title) + " Chart");
        subMenuItemPingChart.setImage(this.chartImage);
        ArrayList<String> nameList = new ArrayList<String>();
        nameList.add(String.valueOf(targetNodeInfo.getNodename()) + "(" + targetNodeInfo.getIpaddress() + ")");
        NodeMapMenuNodePingChart nodePingChart = new NodeMapMenuNodePingChart(targetNodeInfo, isSocket, nameList);
        subMenuItemPingChart.addSelectionListener((SelectionListener)nodePingChart);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.chartImage != null) {
            this.chartImage.dispose();
        }
        if (this.tableImage != null) {
            this.tableImage.dispose();
        }
    }
}

