/*
 * Decompiled with CFR 0.152.
 */
package netjfwatcher.engine.view;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;
import netjfwatcher.database.access.control.DatabaseAccessControlKind;
import netjfwatcher.database.access.model.DatabaseTest;
import netjfwatcher.database.access.model.apachederby.ApacheDerbyEmbeddedDerby;
import netjfwatcher.database.access.model.apachederby.ApacheDerbyNetworkServer;
import netjfwatcher.database.access.model.hsqldb.HsqldbControl;
import netjfwatcher.engine.model.action.EngineStatus;
import netjfwatcher.engine.resource.DatabasePropertyResource;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.resource.XMLOutputterFormat;
import netjfwatcher.engine.socket.info.DatabasePropertyInfo;
import netjfwatcher.engine.socket.info.ResourceInfo;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.jdom.Document;
import org.jdom.output.XMLOutputter;

public class DatabasePropertyView
extends ViewPart {
    private static final int[] SCROLL_COMPOSITE_MIN_SIZE = new int[]{1000, 400};
    private static final int DATABASE_TEST_LIST_WIDTHHINT = 400;
    private static final int DATABASE_TEST_LIST_ITEM_HEIGHT = 7;
    public static final String PHASE0 = "Phase 0 : Engine Connect ";
    public static final String PHASE1 = "Phase 1 : JDBC Driver ";
    public static final String PHASE2 = "Phase 2 : DriverManager getConnection ";
    public static final String PHASE3 = "Phase 3 : Database create table execute ";
    public static final String PHASE4 = "Phase 4 : Database drop table execute ";
    public static final String[] PHASE = new String[]{"Phase 0 : Engine Connect ", "Phase 1 : JDBC Driver ", "Phase 2 : DriverManager getConnection ", "Phase 3 : Database create table execute ", "Phase 4 : Database drop table execute "};
    private static final int DATABASE_NAME_COMBO_WIDTH = 200;
    private static final int TEXT_WIDTH = 200;
    private static Logger logger;
    private ResourceInfo info;
    private String oldDatabaseName = "";
    private ArrayList databasePropList;
    private DatabasePropertyInfo databaseProp;
    private Combo databaseNameCombo;
    private Text databaseNameText;
    private Text databaseDriverText;
    private Text workDatabaseDriverText;
    private Text databaseUrlText;
    private Text workDatabaseUrlText;
    private Text databaseUserText;
    private Text workDatabaseUserText;
    private Text databasePasswordText;
    private Text workDatabasePasswordText;
    private Button saveButton;
    private Button copyButton;
    private Button testButton;
    private List resultDatabaseTestList;

    public DatabasePropertyView() {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    }

    public void createPartControl(Composite parent) {
        this.info = SystemResourceConfig.getInstance().getResourceFileParse().getResourceInfo();
        this.oldDatabaseName = this.info.getDatabaseName();
        this.databasePropList = DatabasePropertyResource.getInstance().getdatabasePropList().getDatabasePropList();
        ScrolledComposite scrollComposite = new ScrolledComposite(parent, 768);
        GridLayout layout = new GridLayout(1, false);
        scrollComposite.setLayout((Layout)layout);
        GridLayout gridLayout0 = new GridLayout(1, false);
        Composite baseComposite = new Composite((Composite)scrollComposite, 16384);
        baseComposite.setLayout((Layout)gridLayout0);
        baseComposite.setLayoutData((Object)new GridData(2));
        gridLayout0 = new GridLayout(3, false);
        Composite subBaseComposite = new Composite(baseComposite, 16384);
        subBaseComposite.setLayout((Layout)gridLayout0);
        subBaseComposite.setLayoutData((Object)new GridData(2));
        GridData gridData = null;
        GridLayout gridLayout = new GridLayout(2, false);
        Composite leftComposite = new Composite(subBaseComposite, 16384);
        leftComposite.setLayout((Layout)gridLayout);
        leftComposite.setLayoutData((Object)new GridData(2));
        gridData = new GridData();
        gridLayout = new GridLayout(1, false);
        Composite centerComposite = new Composite(subBaseComposite, 16384);
        centerComposite.setLayout((Layout)gridLayout);
        centerComposite.setLayoutData((Object)new GridData(2));
        gridLayout = new GridLayout(2, false);
        Composite rightComposite = new Composite(subBaseComposite, 16384);
        rightComposite.setLayout((Layout)gridLayout);
        rightComposite.setLayoutData((Object)new GridData(2));
        Label label = new Label(leftComposite, 0);
        label.setText("Database Name");
        label.setLayoutData((Object)new GridData(2));
        this.databaseNameText = new Text(leftComposite, 2048);
        gridData = new GridData(2);
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.databaseNameText.setLayoutData((Object)gridData);
        label = new Label(leftComposite, 0);
        label.setText("Database Driver");
        gridData = new GridData(2);
        label.setLayoutData((Object)gridData);
        this.databaseDriverText = new Text(leftComposite, 2048);
        gridData = new GridData(2);
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.databaseDriverText.setLayoutData((Object)gridData);
        label = new Label(leftComposite, 0);
        label.setText("Database URL");
        gridData = new GridData();
        label.setLayoutData((Object)gridData);
        this.databaseUrlText = new Text(leftComposite, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.databaseUrlText.setLayoutData((Object)gridData);
        label = new Label(leftComposite, 0);
        label.setText("Database User");
        label.setLayoutData((Object)new GridData());
        this.databaseUserText = new Text(leftComposite, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.databaseUserText.setLayoutData((Object)gridData);
        label = new Label(leftComposite, 0);
        label.setText("Database Password");
        label.setLayoutData((Object)new GridData());
        this.databasePasswordText = new Text(leftComposite, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.databasePasswordText.setLayoutData((Object)gridData);
        label = new Label(leftComposite, 0);
        label.setText(" ");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.saveButton = new Button(leftComposite, 0);
        this.saveButton.setText("Save");
        this.saveButton.setLayoutData((Object)new GridData());
        label = new Label(leftComposite, 0);
        label.setText(" ");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(leftComposite, 0);
        label.setText(" ");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(centerComposite, 0);
        label.setText(" ");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.copyButton = new Button(centerComposite, 0);
        this.copyButton.setText("Copy");
        this.copyButton.setLayoutData((Object)new GridData(2));
        label = new Label(centerComposite, 0);
        label.setText(" <---");
        label.setLayoutData((Object)new GridData(2));
        label = new Label(rightComposite, 0);
        label.setText("Database Name");
        label.setLayoutData((Object)new GridData());
        this.databaseNameCombo = new Combo(rightComposite, 12);
        int selectDatabaseName = 0;
        int i = 0;
        while (i < this.databasePropList.size()) {
            this.databaseNameCombo.add(((DatabasePropertyInfo)this.databasePropList.get(i)).getDatabaseName());
            if (this.info.getDatabaseName().equals(((DatabasePropertyInfo)this.databasePropList.get(i)).getDatabaseName())) {
                selectDatabaseName = i;
            }
            ++i;
        }
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.databaseNameCombo.setLayoutData((Object)gridData);
        this.databaseNameCombo.select(selectDatabaseName);
        label = new Label(rightComposite, 0);
        label.setText("Database Driver");
        label.setLayoutData((Object)new GridData());
        this.workDatabaseDriverText = new Text(rightComposite, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.workDatabaseDriverText.setLayoutData((Object)gridData);
        label = new Label(rightComposite, 0);
        label.setText("Database URL");
        label.setLayoutData((Object)new GridData());
        this.workDatabaseUrlText = new Text(rightComposite, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.workDatabaseUrlText.setLayoutData((Object)gridData);
        label = new Label(rightComposite, 0);
        label.setText("Database User");
        label.setLayoutData((Object)new GridData());
        this.workDatabaseUserText = new Text(rightComposite, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.workDatabaseUserText.setLayoutData((Object)gridData);
        label = new Label(rightComposite, 0);
        label.setText("Database Password");
        label.setLayoutData((Object)new GridData());
        this.workDatabasePasswordText = new Text(rightComposite, 2048);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = 200;
        this.workDatabasePasswordText.setLayoutData((Object)gridData);
        label = new Label(rightComposite, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label = new Label(rightComposite, 0);
        label.setText("");
        label.setLayoutData((Object)new GridData());
        this.testButton = new Button(rightComposite, 0);
        this.testButton.setText("Test");
        this.testButton.setLayoutData((Object)new GridData());
        label = new Label(rightComposite, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label = new Label(rightComposite, 0);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.resultDatabaseTestList = new List(rightComposite, 2820);
        GridData data = new GridData(1808);
        data.horizontalSpan = 1;
        data.verticalSpan = 1;
        data.widthHint = 400;
        data.heightHint = this.resultDatabaseTestList.getItemHeight() * 7;
        this.resultDatabaseTestList.select(0);
        this.resultDatabaseTestList.setLayoutData((Object)data);
        gridLayout0 = new GridLayout(3, false);
        Composite composite01 = new Composite(baseComposite, 0);
        composite01.setLayout((Layout)gridLayout0);
        composite01.setLayoutData((Object)new GridData());
        gridLayout = new GridLayout(2, false);
        Composite composite11 = new Composite(composite01, 16384);
        composite11.setLayout((Layout)gridLayout);
        composite11.setLayoutData((Object)new GridData());
        gridLayout = new GridLayout(1, false);
        Composite composite12 = new Composite(composite01, 16384);
        composite12.setLayout((Layout)gridLayout);
        composite12.setLayoutData((Object)new GridData());
        gridLayout = new GridLayout(2, false);
        Composite composite13 = new Composite(composite01, 16384);
        composite13.setLayout((Layout)gridLayout);
        composite13.setLayoutData((Object)new GridData());
        this.setShowText();
        this.setSelectDatabase(selectDatabaseName);
        scrollComposite.setContent((Control)baseComposite);
        scrollComposite.setMinSize(SCROLL_COMPOSITE_MIN_SIZE[0], SCROLL_COMPOSITE_MIN_SIZE[1]);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);
        this.setListener();
    }

    private void setListener() {
        this.databaseNameCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int smtpHostSelectIndex = DatabasePropertyView.this.databaseNameCombo.getSelectionIndex();
                DatabasePropertyView.this.setSelectDatabase(smtpHostSelectIndex);
            }
        });
        this.testButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                DatabasePropertyView.this.testButton.setEnabled(false);
                try {
                    BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

                        public void run() {
                            DatabasePropertyView.this.testDatabase();
                        }
                    });
                }
                finally {
                    DatabasePropertyView.this.testButton.setEnabled(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.copyButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                DatabasePropertyView.this.info.setDatabaseName(DatabasePropertyView.this.databaseNameCombo.getText());
                DatabasePropertyView.this.info.setDatabaseDriver(DatabasePropertyView.this.workDatabaseDriverText.getText());
                DatabasePropertyView.this.info.setDatabaseUrl(DatabasePropertyView.this.workDatabaseUrlText.getText());
                DatabasePropertyView.this.info.setDatabaseUser(DatabasePropertyView.this.workDatabaseUserText.getText());
                DatabasePropertyView.this.info.setDatabasePassword(DatabasePropertyView.this.workDatabasePasswordText.getText());
                DatabasePropertyView.this.setShowText();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.saveButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                DatabasePropertyView.this.saveButton.setEnabled(false);
                try {
                    if (!DatabasePropertyView.this.oldDatabaseName.equals(DatabasePropertyView.this.databaseNameText.getText())) {
                        DatabasePropertyView.this.stopDatabase(DatabasePropertyView.this.oldDatabaseName);
                        if (EngineStatus.getInstance().isEngine()) {
                            MessageDialog.openInformation((Shell)DatabasePropertyView.this.getSite().getShell(), (String)"Information", (String)"Please Restart Engine");
                        }
                    }
                    DatabasePropertyView.this.info.setDatabaseName(DatabasePropertyView.this.databaseNameText.getText());
                    DatabasePropertyView.this.info.setDatabaseDriver(DatabasePropertyView.this.databaseDriverText.getText());
                    DatabasePropertyView.this.info.setDatabaseUrl(DatabasePropertyView.this.databaseUrlText.getText());
                    DatabasePropertyView.this.info.setDatabaseUser(DatabasePropertyView.this.databaseUserText.getText());
                    DatabasePropertyView.this.info.setDatabasePassword(DatabasePropertyView.this.databasePasswordText.getText());
                    DatabasePropertyView.this.oldDatabaseName = DatabasePropertyView.this.databaseNameText.getText();
                    DatabasePropertyView.this.saveResourceXMLInfo(DatabasePropertyView.this.info);
                    DatabaseAccessControlKind.getInstance().updateDatabaseKindControl();
                }
                finally {
                    DatabasePropertyView.this.saveButton.setEnabled(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
    }

    private void stopDatabase(String oldDatabaseKind) {
        if (oldDatabaseKind.equals("HSQLDB")) {
            try {
                HsqldbControl.getInstance().stopHsqlDB();
            }
            catch (ClassNotFoundException e) {
                logger.warning("ClassNotFoundException HSQLDB " + e.getMessage());
            }
            catch (SQLException e) {
                logger.warning("SQLException HSQLDB " + e.getMessage());
            }
        } else if (oldDatabaseKind.equals("Apache Derby")) {
            try {
                ApacheDerbyNetworkServer.getInstance().stopDerbyNetworkServer();
            }
            catch (Exception e) {
                logger.warning("DERBY " + e.getMessage());
            }
        } else if (oldDatabaseKind.equals("Embedded Derby")) {
            try {
                ApacheDerbyEmbeddedDerby.getInstance().stopEmbeddedDerby();
            }
            catch (Exception e) {
                logger.warning("EMBEDDED_DERBY " + e.getMessage());
            }
        }
    }

    private void setShowText() {
        this.databaseNameText.setText(this.info.getDatabaseName());
        this.databaseDriverText.setText(this.info.getDatabaseDriver());
        this.databaseUrlText.setText(this.info.getDatabaseUrl());
        this.databaseUserText.setText(this.info.getDatabaseUser());
        this.databasePasswordText.setText(this.info.getDatabasePassword());
    }

    private void setSelectDatabase(int selectDatabaseName) {
        this.databaseProp = (DatabasePropertyInfo)this.databasePropList.get(selectDatabaseName);
        this.databaseNameCombo.setText(this.databaseProp.getDatabaseName());
        this.workDatabaseDriverText.setText(this.databaseProp.getDatabaseDriver());
        this.workDatabaseUrlText.setText(this.databaseProp.getDatabaseUrl());
        this.workDatabaseUserText.setText(this.databaseProp.getDatabaseUser());
        this.workDatabasePasswordText.setText(this.databaseProp.getDatabasePassword());
    }

    private void testDatabase() {
        this.resultDatabaseTestList.removeAll();
        String databaseName = this.databaseNameCombo.getText();
        String databaseDriver = this.workDatabaseDriverText.getText();
        String databaseUrl = this.workDatabaseUrlText.getText();
        String databaseUser = this.workDatabaseUserText.getText();
        String databasePassword = this.workDatabasePasswordText.getText();
        logger.info("databaseName : " + databaseName);
        logger.info("databaseDriver : " + databaseDriver);
        logger.info("databaseUrl : " + databaseUrl);
        logger.info("databaseUser : " + databaseUser);
        logger.info("databasePassword : " + databasePassword);
        DatabaseTest databaseTest = new DatabaseTest(databaseName);
        String[] testResult = databaseTest.checkDatabase(databaseDriver, databaseUrl, databaseUser, databasePassword);
        int i = 0;
        while (i < testResult.length) {
            logger.info("Phase " + i + " : " + testResult[i]);
            if (i != 0) {
                this.resultDatabaseTestList.add(String.valueOf(PHASE[i]) + " : " + testResult[i]);
            }
            ++i;
        }
    }

    protected void saveResourceXMLInfo(ResourceInfo info) {
        Document dom = null;
        BufferedWriter bufWriter = null;
        dom = this.updateResource(info);
        bufWriter = SystemResourceConfig.getInstance().getResourceFileParse().getResourceFileWriter();
        this.outputXMLFile(bufWriter, dom);
        if (bufWriter != null) {
            try {
                bufWriter.close();
            }
            catch (IOException e) {
                logger.warning("Abort close BufferedWriter for snmp resource : " + e.getMessage());
                e.printStackTrace();
            }
        }
        SystemResourceConfig.getInstance().updateResourceset();
    }

    protected Document updateResource(ResourceInfo info) {
        Document dom = SystemResourceConfig.getInstance().getResourceFileParse().updateDocument(info);
        return dom;
    }

    public void outputXMLFile(BufferedWriter bufWriter, Document dom) {
        logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
        XMLOutputter outputter = XMLOutputterFormat.getInstance().getXMLOutputterFormat();
        OutputStreamWriter writer = null;
        try {
            try {
                outputter.output(dom, (OutputStream)System.out);
                outputter.output(dom, (Writer)bufWriter);
            }
            catch (IOException e1) {
                logger.warning(e1.getMessage());
                e1.printStackTrace();
            }
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e2) {
                    logger.warning(e2.getMessage());
                    e2.printStackTrace();
                }
            }
        }
    }

    public void setFocus() {
    }
}

